# Condition Present on Admission (POA) Value Set - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Condition Present on Admission (POA) Value Set**

## ValueSet: Condition Present on Admission (POA) Value Set (Experimental) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/hdr/ValueSet/hdr-poa-indicator-xpandh-vs | *Version*:0.1.0 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:HdrPOAIndicatorXpandhVS |
| **Copyright/Legal**: Used by permission of the XpanDH project, all rights reserved Creative Commons License | | |

 
Hospital Discharge Report Condition Present on Admission value set includes codes from Present on Admission code system. 

 **References** 

* [Condition Xpandh Hospital Dischage Encounter](StructureDefinition-condition-encounter-hdr-xpandh.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "hdr-poa-indicator-xpandh-vs",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "http://hl7.eu/fhir/ig/xpandh/hdr/ValueSet/hdr-poa-indicator-xpandh-vs",
  "version" : "0.1.0",
  "name" : "HdrPOAIndicatorXpandhVS",
  "title" : "Condition Present on Admission (POA) Value Set",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-10-10T16:32:47+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "Hospital Discharge Report Condition Present on Admission value set includes codes from Present on Admission code system.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of the XpanDH project, all rights reserved Creative Commons License",
  "compose" : {
    "include" : [
      {
        "system" : "http://hl7.eu/fhir/ig/xpandh/hdr/CodeSystem/poa-indicator-xpandh-cs",
        "concept" : [
          {
            "code" : "POA",
            "display" : "Present on admission"
          },
          {
            "code" : "HAC",
            "display" : "Hospital acquired condition"
          },
          {
            "code" : "NA",
            "display" : "Not applicable or unknown"
          }
        ]
      }
    ]
  }
}

```
