# Mandatory Condition Value Set - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Mandatory Condition Value Set**

## ValueSet: Mandatory Condition Value Set 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/hdr/ValueSet/hdr-condition-mandatory-xpandh-vs | *Version*:0.1.0 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:HdrConditionMandatoryXpandhVS |
| **Copyright/Legal**: Used by permission of the XpanDH project, all rights reserved Creative Commons License | | |

 
Hospital Discharge Report Mandatory Condition value set includes selected codes from recommended EU code systems for health conditions (WHO-ICD-10, SNOMED CT and Orphacodes) and IPS Absent and Unknown Data. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

No Expansion for this valueset (Unknown Code System)

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "hdr-condition-mandatory-xpandh-vs",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "http://hl7.eu/fhir/ig/xpandh/hdr/ValueSet/hdr-condition-mandatory-xpandh-vs",
  "version" : "0.1.0",
  "name" : "HdrConditionMandatoryXpandhVS",
  "title" : "Mandatory Condition Value Set",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-10T16:32:47+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "Hospital Discharge Report Mandatory Condition value set includes selected codes from recommended EU code systems for health conditions (WHO-ICD-10, SNOMED CT and Orphacodes) and IPS Absent and Unknown Data.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of the XpanDH project, all rights reserved Creative Commons License",
  "compose" : {
    "include" : [
      {
        "valueSet" : [
          "http://hl7.eu/fhir/ig/xpandh/hdr/ValueSet/hdr-condition-xpandh-vs"
        ]
      },
      {
        "system" : "http://hl7.org/fhir/uv/ips/CodeSystem/absent-unknown-uv-ips",
        "concept" : [
          {
            "code" : "no-problem-info",
            "display" : "No information about problems"
          },
          {
            "code" : "no-known-problems",
            "display" : "No known problems"
          }
        ]
      },
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "385432009",
            "display" : "Not applicable"
          }
        ]
      }
    ]
  }
}

```
