# Inpatient Encounter Xpandh - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Inpatient Encounter Xpandh**

## Resource Profile: Inpatient Encounter Xpandh 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/inpatient-encounter-hdr-xpandh | *Version*:0.1.0 |
| Draft as of 2025-10-10 | *Computable Name*:InpatientEncounterHDRXpandh |
| **Copyright/Legal**: Used by permission of the XpanDH project, all rights reserved Creative Commons License | |

 
This profile defines how to represent Inpatient Encounter in FHIR for the purpose of the XpanDH Hospital Discharge Report. 

**Usages:**

* Refer to this Profile: [Composition: Hospital Discharge Report](StructureDefinition-Composition-hdr-eu-xpandh.md)
* Examples for this Profile: [Encounter/SK-Hospital-Encounter](Encounter-SK-Hospital-Encounter.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.xpandh.hdr|current/StructureDefinition/inpatient-encounter-hdr-xpandh)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-inpatient-encounter-hdr-xpandh.csv), [Excel](StructureDefinition-inpatient-encounter-hdr-xpandh.xlsx), [Schematron](StructureDefinition-inpatient-encounter-hdr-xpandh.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "inpatient-encounter-hdr-xpandh",
  "url" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/inpatient-encounter-hdr-xpandh",
  "version" : "0.1.0",
  "name" : "InpatientEncounterHDRXpandh",
  "title" : "Inpatient Encounter Xpandh",
  "status" : "draft",
  "date" : "2025-10-10T16:32:47+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "This profile defines how to represent Inpatient Encounter in FHIR for the purpose of the XpanDH Hospital Discharge Report.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of the XpanDH project, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Encounter",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Encounter",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Encounter",
        "path" : "Encounter"
      },
      {
        "id" : "Encounter.identifier",
        "path" : "Encounter.identifier",
        "short" : "Identifier(s) by which this encounter is known."
      },
      {
        "id" : "Encounter.status",
        "path" : "Encounter.status",
        "short" : "Status of this Hospital stay",
        "definition" : "At the discharge report status of the encounter should be always = \"finished\"",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.eu/fhir/ig/xpandh/hdr/ValueSet/encounter-status-vs-eu-hdr"
        }
      },
      {
        "id" : "Encounter.class",
        "path" : "Encounter.class",
        "definition" : "Concepts representing classification of inpatient encounter such as inpatient, emergency or others due to local variations.",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.eu/fhir/ig/xpandh/hdr/ValueSet/hdr-encounterClass-xpandh-vs"
        }
      },
      {
        "id" : "Encounter.type",
        "path" : "Encounter.type",
        "short" : "Specific type of Hospital stay",
        "definition" : "Allows to classify encounter using information about care provision regimen during an inpatient encounter.",
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://hl7.eu/fhir/ig/xpandh/hdr/ValueSet/hdr-encounter-type-xpandh-vs"
        }
      },
      {
        "id" : "Encounter.serviceType",
        "path" : "Encounter.serviceType",
        "short" : "Specific type of service."
      },
      {
        "id" : "Encounter.priority",
        "path" : "Encounter.priority",
        "short" : "Encounter priority",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.eu/fhir/ig/xpandh/hdr/ValueSet/hdr-admission-urgency-xpandh-vs"
        }
      },
      {
        "id" : "Encounter.subject",
        "path" : "Encounter.subject",
        "short" : "The patient present at the encounter",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Patient-eu-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.basedOn",
        "path" : "Encounter.basedOn",
        "short" : "The request for which this encounter has been made"
      },
      {
        "id" : "Encounter.participant",
        "path" : "Encounter.participant",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "type"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "List of participants involved in the encounters",
        "definition" : "Slice per type of participant: admitter, discharger,.."
      },
      {
        "id" : "Encounter.participant.individual",
        "path" : "Encounter.participant.individual",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Practitioner-eu-xpandh",
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/PractitionerRole-eu-xpandh",
              "http://hl7.org/fhir/StructureDefinition/RelatedPerson"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.participant:admitter",
        "path" : "Encounter.participant",
        "sliceName" : "admitter",
        "short" : "Admitting professional",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Encounter.participant:admitter.type",
        "path" : "Encounter.participant.type",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
              "code" : "ADM"
            }
          ]
        }
      },
      {
        "id" : "Encounter.participant:discharger",
        "path" : "Encounter.participant",
        "sliceName" : "discharger",
        "short" : "Discharging professional",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Encounter.participant:discharger.type",
        "path" : "Encounter.participant.type",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
              "code" : "DIS"
            }
          ]
        }
      },
      {
        "id" : "Encounter.participant:referrer",
        "path" : "Encounter.participant",
        "sliceName" : "referrer",
        "short" : "Referring professional",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Encounter.participant:referrer.type",
        "path" : "Encounter.participant.type",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
              "code" : "REF"
            }
          ]
        }
      },
      {
        "id" : "Encounter.period",
        "path" : "Encounter.period",
        "short" : "The start and end time of this encounter.",
        "definition" : "The start and end time of this inpatient stay."
      },
      {
        "id" : "Encounter.reasonCode",
        "path" : "Encounter.reasonCode",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.eu/fhir/ig/xpandh/hdr/ValueSet/hdr-condition-xpandh-vs"
        }
      },
      {
        "id" : "Encounter.reasonReference",
        "path" : "Encounter.reasonReference",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Observation",
              "http://hl7.org/fhir/StructureDefinition/Condition",
              "http://hl7.org/fhir/StructureDefinition/Procedure"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.diagnosis",
        "path" : "Encounter.diagnosis",
        "short" : "The list of diagnosis relevant to this encounter, see comment",
        "comment" : "While Encounter.diagnosis could be optionally populated, mainly for administrative purposes, we strongly recommend to put all clinical relevant diagnoses, stated at start, during and at the end of the hospital stay, into the corresponding section(s) of the HDR."
      },
      {
        "id" : "Encounter.hospitalization.admitSource",
        "path" : "Encounter.hospitalization.admitSource",
        "short" : "From where patient was admitted (physician referral, transfer)."
      },
      {
        "id" : "Encounter.hospitalization.destination",
        "path" : "Encounter.hospitalization.destination",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Organization",
              "http://hl7.org/fhir/StructureDefinition/Location"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.location",
        "path" : "Encounter.location",
        "short" : "Locations where the patient stayed"
      },
      {
        "id" : "Encounter.location.period",
        "path" : "Encounter.location.period",
        "short" : "Location period"
      }
    ]
  }
}

```
