# Condition Xpandh Hospital Dischage Encounter - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Condition Xpandh Hospital Dischage Encounter**

## Resource Profile: Condition Xpandh Hospital Dischage Encounter 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/condition-encounter-hdr-xpandh | *Version*:0.1.0 |
| Draft as of 2025-10-10 | *Computable Name*:ConditionEncounterHdrXpandh |
| **Copyright/Legal**: Used by permission of the XpanDH project, all rights reserved Creative Commons License | |

 
This profile represents the constraint applied to the Condition in the scope of Xpandh hospital discharge encounter resource. Encounter conditions implements Diagnostic summary part of the eHN data model adding two additional categories: First category distingueshes conditions present at admission and acquired during hospital stay (POA, HAC, NA - Not applicable or unknown) while second category is used to indicate impact of the condition to the treatement during hospital stay (treated, untreated). 

**Usages:**

* Refer to this Profile: [Composition: Hospital Discharge Report](StructureDefinition-Composition-hdr-eu-xpandh.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.xpandh.hdr|current/StructureDefinition/condition-encounter-hdr-xpandh)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-condition-encounter-hdr-xpandh.csv), [Excel](StructureDefinition-condition-encounter-hdr-xpandh.xlsx), [Schematron](StructureDefinition-condition-encounter-hdr-xpandh.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "condition-encounter-hdr-xpandh",
  "url" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/condition-encounter-hdr-xpandh",
  "version" : "0.1.0",
  "name" : "ConditionEncounterHdrXpandh",
  "title" : "Condition Xpandh Hospital Dischage Encounter",
  "status" : "draft",
  "date" : "2025-10-10T16:32:47+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "This profile represents the constraint applied to the Condition in the scope of Xpandh hospital discharge encounter resource. Encounter conditions implements Diagnostic summary part of the eHN data model adding two additional categories: First category distingueshes conditions present at admission and acquired during hospital stay (POA, HAC, NA - Not applicable or unknown) while second category is used to indicate impact of the condition to the treatement during hospital stay (treated, untreated).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of the XpanDH project, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Condition",
  "baseDefinition" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/condition-hdr-xpandh",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Condition",
        "path" : "Condition"
      },
      {
        "id" : "Condition.category",
        "path" : "Condition.category",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "short" : "category codes",
        "definition" : "Slices per type of classificaton",
        "min" : 3
      },
      {
        "id" : "Condition.category:hdr-core",
        "path" : "Condition.category",
        "sliceName" : "hdr-core",
        "short" : "encounter-diagnosis",
        "min" : 1,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
              "code" : "encounter-diagnosis"
            }
          ]
        }
      },
      {
        "id" : "Condition.category:poa",
        "path" : "Condition.category",
        "sliceName" : "poa",
        "short" : "POA, HAC, NA",
        "definition" : "Present on admission, Hospital acquired condition, Not applicable or unknown",
        "min" : 1,
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.eu/fhir/ig/xpandh/hdr/ValueSet/hdr-poa-indicator-xpandh-vs"
        }
      },
      {
        "id" : "Condition.category:treated",
        "path" : "Condition.category",
        "sliceName" : "treated",
        "short" : "Treated or untreated",
        "definition" : "Class of the problem (treated, other) in relation to the hospital encounter. Treated problems were treated or affected provisioning of care (diagnostics, therapy, nursing, monitoring) during the hospital encounter. At least one problem should be marked as Treated. Other problems are recorded only if they are important for continuity of care (after discharge).",
        "min" : 1,
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.eu/fhir/ig/xpandh/hdr/ValueSet/hdr-treated-xpandh-vs"
        }
      }
    ]
  }
}

```
