# Hospital Discharge Report (SK) - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Hospital Discharge Report (SK)**

## Logical Model: Hospital Discharge Report (SK) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HospitalDischargeReportSK | *Version*:0.1.0 |
| Draft as of 2025-10-10 | *Computable Name*:HospitalDischargeReportSK |
| **Copyright/Legal**: Used by permission of the XpanDH project, all rights reserved Creative Commons License | |

 
Hospital Discharge Report SK Maturity Level: 0 Draft 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.xpandh.hdr|current/StructureDefinition/HospitalDischargeReportSK)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-HospitalDischargeReportSK.csv), [Excel](StructureDefinition-HospitalDischargeReportSK.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "HospitalDischargeReportSK",
  "url" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HospitalDischargeReportSK",
  "version" : "0.1.0",
  "name" : "HospitalDischargeReportSK",
  "title" : "Hospital Discharge Report (SK)",
  "status" : "draft",
  "date" : "2025-10-10T16:32:47+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "Hospital Discharge Report SK\nMaturity Level: 0 Draft",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of the XpanDH project, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "fhir",
      "uri" : "hl7.org/fhir/r4",
      "name" : "Hospital Discharge Report model to FHIR R4 Map"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HospitalDischargeReportSK",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "HospitalDischargeReportSK",
        "path" : "HospitalDischargeReportSK",
        "short" : "Hospital Discharge Report (SK)",
        "definition" : "Hospital Discharge Report SK\nMaturity Level: 0 Draft",
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header",
        "path" : "HospitalDischargeReportSK.header",
        "short" : "A.1-Report header data element [Mandatory]",
        "definition" : "A.1-Report header data element [Mandatory]",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.subjectIdentification",
        "path" : "HospitalDischargeReportSK.header.subjectIdentification",
        "short" : "A.1.1-Identification of the patient/subject [Mandatory]",
        "definition" : "A.1.1-Identification of the patient/subject [Mandatory]",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.subjectIdentification.given",
        "path" : "HospitalDischargeReportSK.header.subjectIdentification.given",
        "short" : "A.1.1.1-Given name [Mandatory]",
        "definition" : "The given name/first name of the patient (also known as forename or first name). This field can contain more than one element.  ",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.subjectIdentification.family",
        "path" : "HospitalDischargeReportSK.header.subjectIdentification.family",
        "short" : "A.1.1.2-Family name/surname [Mandatory]",
        "definition" : "The family name/surname/last name of the patient. This field can contain more than one element or multiple fields could be present. ",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.subjectIdentification.birthDate",
        "path" : "HospitalDischargeReportSK.header.subjectIdentification.birthDate",
        "short" : "A.1.1.3-Date of birth [Required]",
        "definition" : "The date of birth of the patient [ISO TS 22220]. As age of the patient might be important for correct interpretation of the test result values, complete date of birth should be provided.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.subjectIdentification.identifier",
        "path" : "HospitalDischargeReportSK.header.subjectIdentification.identifier",
        "short" : "A.1.1.4-Personal identifier [Required]",
        "definition" : "An identifier of the patient that is unique within a defined scope. Example: National ID (birth number) for Czech patient. Multiple identifiers could be provided.  ",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.subjectIdentification.nationality",
        "path" : "HospitalDischargeReportSK.header.subjectIdentification.nationality",
        "short" : "A.1.1.5-Nationality [Required]",
        "definition" : "Nationality of the patient.",
        "comment" : "eHDSICountry (ISO 3166)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.subjectIdentification.gender",
        "path" : "HospitalDischargeReportSK.header.subjectIdentification.gender",
        "short" : "A.1.1.6-Gender [Mandatory]",
        "definition" : "This field must contain a recognised valid value for 'administrative gender'. If different, 'physiological gender' should be communicated elsewhere.",
        "comment" : "HL7 Administrative Gender ",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.subjectIdentification.language",
        "path" : "HospitalDischargeReportSK.header.subjectIdentification.language",
        "short" : "A.1.1.7-Language communication [Optional]",
        "definition" : "Patient communication language. Multiple communication languages might be provided.  ",
        "comment" : "BCP 47",
        "min" : 0,
        "max" : "0",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.subjectContact",
        "path" : "HospitalDischargeReportSK.header.subjectContact",
        "short" : "A.1.2-Patient/subject related contact information [Required]",
        "definition" : "A.1.2-Patient/subject related contact information [Required]",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.subjectContact.contactPoint",
        "path" : "HospitalDischargeReportSK.header.subjectContact.contactPoint",
        "short" : "A.1.2.1-Patient address []",
        "definition" : "A.1.2.1-Patient address []",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.subjectContact.contactPoint.address",
        "path" : "HospitalDischargeReportSK.header.subjectContact.contactPoint.address",
        "short" : "A.1.2.1.1-Address [Required]",
        "definition" : "Mailing and home or office addresses. The addresses are always sequences of address parts (e.g. street address line, country, ZIP code, city) even if postal address formats may vary depending on the country. An address may or may not include a specific use code; if this attribute is not present it is assumed to be the default address useful for any purpose.",
        "comment" : "eHDSICountry (ISO 3166)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Address"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.subjectContact.contactPoint.telecom",
        "path" : "HospitalDischargeReportSK.header.subjectContact.contactPoint.telecom",
        "short" : "A.1.2.1.2-Telecom [Required]",
        "definition" : "Telecommunication contact information (addresses) associated to a person. Multiple telecommunication addresses might be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.subjectContact.contactPoint.preferredHP",
        "path" : "HospitalDischargeReportSK.header.subjectContact.contactPoint.preferredHP",
        "short" : "A.1.2.2-Preferred healthcare professional (HP) [Optional]",
        "definition" : "- This section can be repeated and linked to any specific information in the document, for example a link between a rare disease problem and the rare disease specialist responsible for the care of the individual patient (this section).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.subjectContact.contactPoint.preferredHP.identifier",
        "path" : "HospitalDischargeReportSK.header.subjectContact.contactPoint.preferredHP.identifier",
        "short" : "A.1.2.2.1-Identifier [Required]",
        "definition" : "An identifier of the healthcare professional that is unique within a defined scope. Example: National healthcare professional ID. Multiple identifiers could be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.subjectContact.contactPoint.preferredHP.name",
        "path" : "HospitalDischargeReportSK.header.subjectContact.contactPoint.preferredHP.name",
        "short" : "A.1.2.2.2-Name of the HP [Required]",
        "definition" : "Name of the Health Professional that has been treating or taking responsibility for the patient.\nThis element can be repeated if several medical problems for the patient require multiple contact information, with references from individual entries.\n[the structure of the name will be the same as for the patient (given name, family name / surname)]",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.subjectContact.contactPoint.preferredHP.role",
        "path" : "HospitalDischargeReportSK.header.subjectContact.contactPoint.preferredHP.role",
        "short" : "A.1.2.2.3-Role of the HP [Required]",
        "definition" : "Healthcare professional role",
        "comment" : "ISCO or SNOMED CT specialty - to be discussed",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.subjectContact.contactPoint.preferredHP.organization",
        "path" : "HospitalDischargeReportSK.header.subjectContact.contactPoint.preferredHP.organization",
        "short" : "A.1.2.2.4-HP Organisation [Required]",
        "definition" : "Healthcare Professional Organisation",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.subjectContact.contactPoint.preferredHP.address",
        "path" : "HospitalDischargeReportSK.header.subjectContact.contactPoint.preferredHP.address",
        "short" : "A.1.2.2.5-Address [Optional]",
        "definition" : "Mailing and home or office addresses. The addresses are always sequences of address parts (e.g. street address line, country, ZIP code, city) even if postal address formats may vary depending on the country. An address may or may not include a specific use code; if this attribute is not present it is assumed to be the default address useful for any purpose.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Address"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.subjectContact.contactPoint.preferredHP.telecom",
        "path" : "HospitalDischargeReportSK.header.subjectContact.contactPoint.preferredHP.telecom",
        "short" : "A.1.2.2.6-Telecom [Required]",
        "definition" : "Telecommunication contact information (addresses) associated to a person. Multiple telecommunication addresses might be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.subjectContact.contactPoint.person",
        "path" : "HospitalDischargeReportSK.header.subjectContact.contactPoint.person",
        "short" : "A.1.2.3-Contact person/ legal guardian [Required]",
        "definition" : "A.1.2.3-Contact person/ legal guardian [Required]",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.subjectContact.contactPoint.person.role",
        "path" : "HospitalDischargeReportSK.header.subjectContact.contactPoint.person.role",
        "short" : "A.1.2.3.1-Role of that person [Required]",
        "definition" : "Role of the contact person: legal guardian, next of kin, other person to contact.",
        "comment" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
        "min" : 0,
        "max" : "0",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.subjectContact.contactPoint.person.relationship",
        "path" : "HospitalDischargeReportSK.header.subjectContact.contactPoint.person.relationship",
        "short" : "A.1.2.3.2-Relationship level [Required]",
        "definition" : "Relationship type with the patient (e.g. father, wife, daughter)",
        "comment" : "eHDSIPersonalRelationship",
        "min" : 0,
        "max" : "0",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.subjectContact.contactPoint.person.identifier",
        "path" : "HospitalDischargeReportSK.header.subjectContact.contactPoint.person.identifier",
        "short" : "A.1.2.3.3-Identifier [Optional]",
        "definition" : "An identifier of the healthcare professional that is unique within a defined scope. Example: National personal ID, passport number etc. Multiple identifiers could be provided.  ",
        "min" : 0,
        "max" : "0",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.subjectContact.contactPoint.person.given",
        "path" : "HospitalDischargeReportSK.header.subjectContact.contactPoint.person.given",
        "short" : "A.1.2.3.4-Given name [Mandatory]",
        "definition" : "The first name of the contact person/guardian (example: Peter). This field can contain more than one element.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.subjectContact.contactPoint.person.name",
        "path" : "HospitalDischargeReportSK.header.subjectContact.contactPoint.person.name",
        "short" : "A.1.2.3.5-Family name/surname [Mandatory]",
        "definition" : "This field can contain more than one element. Example: Espa�ol Smith",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.subjectContact.contactPoint.person.address",
        "path" : "HospitalDischargeReportSK.header.subjectContact.contactPoint.person.address",
        "short" : "A.1.2.3.6-Address [Optional]",
        "definition" : "Mailing, home or office addresses. The addresses are always sequences of address parts (e.g. street address line, country, ZIP code, city) even if postal address formats may vary depending on the country. An address may or may not include a specific use code; if this attribute is not present it is assumed to be the default address useful for any purpose.",
        "min" : 0,
        "max" : "0",
        "type" : [
          {
            "code" : "Address"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.subjectContact.contactPoint.person.telecom",
        "path" : "HospitalDischargeReportSK.header.subjectContact.contactPoint.person.telecom",
        "short" : "A.1.2.3.7-Telecom [Required]",
        "definition" : "Telecommunication contact information (addresses) associated to a person. Multiple telecommunication addresses might be provided.",
        "min" : 0,
        "max" : "0",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.payer",
        "path" : "HospitalDischargeReportSK.header.payer",
        "short" : "A.1.3-Health insurance and payment information [Required]",
        "definition" : "Health insurance information is not always required, however, in some jurisdictions, the insurance number is also used as the patient identifier. It is necessary not just for identification but also forms access to funding for care. ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.payer.insuranceCode",
        "path" : "HospitalDischargeReportSK.header.payer.insuranceCode",
        "short" : "A.1.3.1-Health insurance code [Mandatory]",
        "definition" : "Unique health insurance company identification code.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.payer.insuranceName",
        "path" : "HospitalDischargeReportSK.header.payer.insuranceName",
        "short" : "A.1.3.2-Health insurance name [Required]",
        "definition" : "Full, official name of the healthcare insurance provider.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.payer.insuranceNumber",
        "path" : "HospitalDischargeReportSK.header.payer.insuranceNumber",
        "short" : "A.1.3.3-Health insurance number [Mandatory]",
        "definition" : "Number or code under which the insured person is registered at the insurance provider.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.informationRecipient",
        "path" : "HospitalDischargeReportSK.header.informationRecipient",
        "short" : "A.1.4-Information recipient [Required]",
        "definition" : "intended recipient or recipients of the report, additional recipients might be identified by the ordering party, e.g. GP, other specialist",
        "min" : 0,
        "max" : "0",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.informationRecipient.identifier",
        "path" : "HospitalDischargeReportSK.header.informationRecipient.identifier",
        "short" : "A.1.4.1-Recipient identifier [Required]",
        "definition" : "The health professional identification number. Either an internal identifier assigned by a healthcare provider institution or (preferably) a national health professional ID such as the license or registration number. In case when recipient is not a health professional, e.g. patient, appropriate personal identifier should be used. ",
        "min" : 0,
        "max" : "0",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.informationRecipient.name",
        "path" : "HospitalDischargeReportSK.header.informationRecipient.name",
        "short" : "A.1.4.2-Recipient name [Required]",
        "definition" : "Person name.",
        "min" : 0,
        "max" : "0",
        "type" : [
          {
            "code" : "HumanName"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.informationRecipient.organizationID",
        "path" : "HospitalDischargeReportSK.header.informationRecipient.organizationID",
        "short" : "A.1.4.3-Recipient organization ID [Required]",
        "definition" : "The healthcare provider organization identifier if known. Identifier that is unique within a defined scope. Example: National healthcare provider ID. Multiple identifiers could be provided.  ",
        "min" : 0,
        "max" : "0",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.informationRecipient.organization",
        "path" : "HospitalDischargeReportSK.header.informationRecipient.organization",
        "short" : "A.1.4.4-Recipient organization [Required]",
        "definition" : "The healthcare provider organization information.",
        "min" : 0,
        "max" : "0",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.author",
        "path" : "HospitalDischargeReportSK.header.author",
        "short" : "A.1.5-Author (by whom the Hospital discharge report was authored) [Mandatory]",
        "definition" : "Author (by whom the Hospital discharge report was authored)",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.author.identifier",
        "path" : "HospitalDischargeReportSK.header.author.identifier",
        "short" : "A.1.5.1-Author identifier [Mandatory]",
        "definition" : "The health professional identification number. Either an internal identifier assigned by a healthcare provider institution or (preferably) a national health professional ID such as the license or registration number. ",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.author.name",
        "path" : "HospitalDischargeReportSK.header.author.name",
        "short" : "A.1.5.2-Author name [Mandatory]",
        "definition" : "Person name.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.author.organizationID",
        "path" : "HospitalDischargeReportSK.header.author.organizationID",
        "short" : "A.1.5.3-Author organization ID [Required]",
        "definition" : "The healthcare provider organization information.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.author.organization",
        "path" : "HospitalDischargeReportSK.header.author.organization",
        "short" : "A.1.5.4-Author organization [Mandatory]",
        "definition" : "The healthcare provider organization identifier if known. Identifier that is unique within a defined scope. Example: National healthcare provider ID. Multiple identifiers could be provided.  ",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.author.dateTime",
        "path" : "HospitalDischargeReportSK.header.author.dateTime",
        "short" : "A.1.5.5-DateTime [Mandatory]",
        "definition" : "Date and time of the last modification of the document by its Author.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.attester",
        "path" : "HospitalDischargeReportSK.header.attester",
        "short" : "A.1.6-Attester [Required]",
        "definition" : "A.1.6-Attester [Required]",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.attester.identifier",
        "path" : "HospitalDischargeReportSK.header.attester.identifier",
        "short" : "A.1.6.1-Attester identifier [Mandatory]",
        "definition" : "The health professional identification number. Either an internal identifier assigned by a healthcare provider institution or (preferably) a national health professional ID such as the license or registration number. ",
        "min" : 0,
        "max" : "0",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.attester.name",
        "path" : "HospitalDischargeReportSK.header.attester.name",
        "short" : "A.1.6.2-Attester name [Mandatory]",
        "definition" : "Person name.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.attester.organizationID",
        "path" : "HospitalDischargeReportSK.header.attester.organizationID",
        "short" : "A.1.6.3-Attester organization ID [Required]",
        "definition" : "The healthcare provider organization identifier if known. Identifier that is unique within a defined scope. Example: National healthcare provider ID. Multiple identifiers could be provided.  ",
        "min" : 0,
        "max" : "0",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.attester.organization",
        "path" : "HospitalDischargeReportSK.header.attester.organization",
        "short" : "A.1.6.4-Attester organization [Mandatory]",
        "definition" : "The healthcare provider organization information.",
        "min" : 0,
        "max" : "0",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.attester.dateTime",
        "path" : "HospitalDischargeReportSK.header.attester.dateTime",
        "short" : "A.1.6.5-Approval date and time [Mandatory]",
        "definition" : "Date and time of the approval of the document by Attester.",
        "min" : 0,
        "max" : "0",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.legalAuthenticator",
        "path" : "HospitalDischargeReportSK.header.legalAuthenticator",
        "short" : "A.1.7-Legal authenticator [Required]",
        "definition" : "The person taking responsibility for the medical content of the document",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.legalAuthenticator.identifier",
        "path" : "HospitalDischargeReportSK.header.legalAuthenticator.identifier",
        "short" : "A.1.7.1-Legal authenticator identifier [Mandatory]",
        "definition" : "The health professional identification number. Either an internal identifier assigned by a healthcare provider institution or (preferably) a national health professional ID such as the license or registration number. ",
        "min" : 0,
        "max" : "0",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.legalAuthenticator.name",
        "path" : "HospitalDischargeReportSK.header.legalAuthenticator.name",
        "short" : "A.1.7.2-Legal authenticator name [Mandatory]",
        "definition" : "Person name.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.legalAuthenticator.organizationID",
        "path" : "HospitalDischargeReportSK.header.legalAuthenticator.organizationID",
        "short" : "-Legal authenticator organization�ID [Required]",
        "definition" : "The healthcare provider organization identifier if known. Identifier that is unique within a defined scope.�Example: National healthcare provider ID. Multiple identifiers could be provided.��",
        "min" : 0,
        "max" : "0",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.legalAuthenticator.organization",
        "path" : "HospitalDischargeReportSK.header.legalAuthenticator.organization",
        "short" : "A.1.7.3-Legal authenticator organization [Mandatory]",
        "definition" : "The healthcare provider organization information.",
        "min" : 0,
        "max" : "0",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.legalAuthenticator.dateTime",
        "path" : "HospitalDischargeReportSK.header.legalAuthenticator.dateTime",
        "short" : "A.1.7.4-Authentication date and time [Mandatory]",
        "definition" : "Date and time when the document was authorized.",
        "min" : 0,
        "max" : "0",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.documentMetadata",
        "path" : "HospitalDischargeReportSK.header.documentMetadata",
        "short" : "A.1.8-Document metadata [Mandatory]",
        "definition" : "A.1.8-Document metadata [Mandatory]",
        "min" : 0,
        "max" : "0",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.documentMetadata.identifier",
        "path" : "HospitalDischargeReportSK.header.documentMetadata.identifier",
        "short" : "A.1.8.1-Document ID [Mandatory]",
        "definition" : "Unique identifier of the document",
        "min" : 0,
        "max" : "0",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.documentMetadata.type",
        "path" : "HospitalDischargeReportSK.header.documentMetadata.type",
        "short" : "A.1.8.2-Document type [Mandatory]",
        "definition" : "A coded type of the document. Fixed value 'Hospital dicharge summary'",
        "comment" : "LOINC",
        "min" : 0,
        "max" : "0",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.documentMetadata.status",
        "path" : "HospitalDischargeReportSK.header.documentMetadata.status",
        "short" : "A.1.8.3-Document status [Mandatory]",
        "definition" : "The status of the Hospital discharge report. E.g., preliminary, final.",
        "comment" : "hl7:CompositionStatus ",
        "min" : 0,
        "max" : "0",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.documentMetadata.dateTime",
        "path" : "HospitalDischargeReportSK.header.documentMetadata.dateTime",
        "short" : "A.1.8.4-Report date and time [Mandatory]",
        "definition" : "Date and time of the result report creation.",
        "min" : 0,
        "max" : "0",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.documentMetadata.title",
        "path" : "HospitalDischargeReportSK.header.documentMetadata.title",
        "short" : "A.1.8.5-Document title [Mandatory]",
        "definition" : "Document title, e.g. 'Hospital discharge report'",
        "min" : 0,
        "max" : "0",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.documentMetadata.custodian",
        "path" : "HospitalDischargeReportSK.header.documentMetadata.custodian",
        "short" : "A.1.8.6-Report custodian [Optional]",
        "definition" : "Organisation that is in charge of maintaining the report",
        "min" : 0,
        "max" : "0",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.documentMetadata.confidentiality",
        "path" : "HospitalDischargeReportSK.header.documentMetadata.confidentiality",
        "short" : "A.1.8.7-Confidentiality [Mandatory]",
        "definition" : "Level of confidentiality of the document. Implicit value is normal.",
        "comment" : "hl7:confidentiality",
        "min" : 0,
        "max" : "0",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.documentMetadata.language",
        "path" : "HospitalDischargeReportSK.header.documentMetadata.language",
        "short" : "A.1.8.8-Language [Required]",
        "definition" : "Language in which the document is written. Language is expressed by the ISO language code.",
        "comment" : "BCP 47",
        "min" : 0,
        "max" : "0",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.documentMetadata.version",
        "path" : "HospitalDischargeReportSK.header.documentMetadata.version",
        "short" : "A.1.8.9-Version [Required]",
        "definition" : "Version of the document",
        "min" : 0,
        "max" : "0",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.digitalSignature",
        "path" : "HospitalDischargeReportSK.header.digitalSignature",
        "short" : "A.1.9-Digital signatures [Required]",
        "definition" : "A.1.9-Digital signatures [Required]",
        "min" : 0,
        "max" : "0",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.digitalSignature.signature",
        "path" : "HospitalDischargeReportSK.header.digitalSignature.signature",
        "short" : "A.1.9.1-Digital signature [Required]",
        "definition" : "Digital signature of the document",
        "min" : 0,
        "max" : "0",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.header.digitalSignature.timeStamp",
        "path" : "HospitalDischargeReportSK.header.digitalSignature.timeStamp",
        "short" : "A.1.9.2-Time stamp [Required]",
        "definition" : "An electronic time stamp",
        "min" : 0,
        "max" : "0",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.body",
        "path" : "HospitalDischargeReportSK.body",
        "short" : "A.2-Body (missing elementy ?) [Mandatory]",
        "definition" : "Missing element ?",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.body.advanceDirectives",
        "path" : "HospitalDischargeReportSK.body.advanceDirectives",
        "short" : "A.2.1-Advance directives [Required]",
        "definition" : "A.2.1-Advance directives [Required]",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.body.emergencyInfos",
        "path" : "HospitalDischargeReportSK.body.emergencyInfos",
        "short" : "A.2.2-Emergency information [Mandatory]",
        "definition" : "A.2.2-Emergency information [Mandatory]",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.body.encounter",
        "path" : "HospitalDischargeReportSK.body.encounter",
        "short" : "A.2.3-Encounter [Mandatory]",
        "definition" : "A.2.3-Encounter [Mandatory]",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.body.admissionEvaluation",
        "path" : "HospitalDischargeReportSK.body.admissionEvaluation",
        "short" : "A.2.4-Admission evaluation - Admission status should be reported exceptionally only if it is relevant to ensure continuity of care. [Optional]",
        "definition" : "A.2.4-Admission evaluation - Admission status should be reported exceptionally only if it is relevant to ensure continuity of care. [Optional]",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.body.patientHistory",
        "path" : "HospitalDischargeReportSK.body.patientHistory",
        "short" : "A.2.6-Patient history [Optional]",
        "definition" : "A.2.6-Patient history [Optional]",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.body.hospitalStay",
        "path" : "HospitalDischargeReportSK.body.hospitalStay",
        "short" : "A.2.7-Hospital stay [Mandatory]",
        "definition" : "A.2.7-Hospital stay [Mandatory]",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.body.dischargeDetails",
        "path" : "HospitalDischargeReportSK.body.dischargeDetails",
        "short" : "A.2.8-Discharge details [Mandatory]",
        "definition" : "structured information should be provided, however if not available, at least a summary note should be present",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportSK.body.recommendations",
        "path" : "HospitalDischargeReportSK.body.recommendations",
        "short" : "A.2.9-Recommendations [Required]",
        "definition" : "A.2.9-Recommendations [Required]",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      }
    ]
  }
}

```
