# A.2.3 - Encounter (eHN) - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.2.3 - Encounter (eHN)**

## Logical Model: A.2.3 - Encounter (eHN) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HDREncounter | *Version*:0.1.0 |
| Draft as of 2025-10-10 | *Computable Name*:HdrEHNEncounter |
| **Copyright/Legal**: Used by permission of the XpanDH project, all rights reserved Creative Commons License | |

 
Hospital Discharge Report - Encounter - A.2.3 eHN Maturity Level: 0 Draft 

**Usages:**

* Use this Logical Model: [A - Hospital Discharge Report (eHN)](StructureDefinition-HospitalDischargeReport.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.xpandh.hdr|current/StructureDefinition/HDREncounter)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-HDREncounter.csv), [Excel](StructureDefinition-HDREncounter.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "HDREncounter",
  "url" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HDREncounter",
  "version" : "0.1.0",
  "name" : "HdrEHNEncounter",
  "title" : "A.2.3 - Encounter (eHN)",
  "status" : "draft",
  "date" : "2025-10-10T16:32:47+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "Hospital Discharge Report - Encounter - A.2.3 eHN\nMaturity Level: 0 Draft",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of the XpanDH project, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "fhir",
      "uri" : "hl7.org/fhir/r4",
      "name" : "Hospital Discharge Report model to FHIR R4 Map"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HDREncounter",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "HDREncounter",
        "path" : "HDREncounter",
        "short" : "A.2.3 - Encounter (eHN)",
        "definition" : "Hospital Discharge Report - Encounter - A.2.3 eHN\nMaturity Level: 0 Draft",
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HDREncounter.type",
        "path" : "HDREncounter.type",
        "short" : "A.2.3.1 - Encounter type",
        "definition" : "The type of the encounter whether inpatient or short stay encounter.",
        "comment" : "hl7v3:ActEncounterCode",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HDREncounter.note",
        "path" : "HDREncounter.note",
        "short" : "A.2.3.2 - Encounter note",
        "definition" : "A narrative description of the encounter course.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HDREncounter.admission",
        "path" : "HDREncounter.admission",
        "short" : "A.2.3.3 - Admission",
        "definition" : "Admission",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HDREncounter.admission.urgency",
        "path" : "HDREncounter.admission.urgency",
        "short" : "A.2.3.3.1 - Admission urgency",
        "definition" : "Admission type, either emergency or planned",
        "comment" : "hl7:v3-xEncounterAdmissionUrgency",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HDREncounter.admission.date",
        "path" : "HDREncounter.admission.date",
        "short" : "A.2.3.3.2 - Admission date",
        "definition" : "Admission date and time.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HDREncounter.admission.admitter",
        "path" : "HDREncounter.admission.admitter",
        "short" : "Admitting professional",
        "definition" : "Admitting Healthcare Professional",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HDREncounter.admission.admitter.identifier",
        "path" : "HDREncounter.admission.admitter.identifier",
        "short" : "A.2.3.3.3 - Admitting professional ID",
        "definition" : "The health professional identification number. Either an internal identifier assigned by a healthcare provider institution or (preferably) a national health professional ID such as the licence or registration number. ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HDREncounter.admission.admitter.name",
        "path" : "HDREncounter.admission.admitter.name",
        "short" : "A.2.3.3.4 - Admitting professional name",
        "definition" : "Person name [the structure of the name will be the same as for the patient (given name, family name / surname)].",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HDREncounter.admission.admitter.organizationID",
        "path" : "HDREncounter.admission.admitter.organizationID",
        "short" : "A.2.3.3.5 - Admitting organisation ID",
        "definition" : "The healthcare provider organisation identifier.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HDREncounter.admission.admitter.organization",
        "path" : "HDREncounter.admission.admitter.organization",
        "short" : "A.2.3.3.6 - Admitting organisation",
        "definition" : "The healthcare provider organisation information.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HDREncounter.admission.source",
        "path" : "HDREncounter.admission.source",
        "short" : "A.2.3.3.7 - Admit Source",
        "definition" : "From where the patient was admitted (e.g. physician referral, transfer).",
        "comment" : "Hl7:admit-source",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HDREncounter.admission.referringHP",
        "path" : "HDREncounter.admission.referringHP",
        "short" : "Referring professional",
        "definition" : "Referring Healthcare Professional",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HDREncounter.admission.referringHP.identifier",
        "path" : "HDREncounter.admission.referringHP.identifier",
        "short" : "A.2.3.3.8 - Referring professional ID",
        "definition" : "The health professional identification number. Either an internal identifier assigned by a healthcare provider institution or (preferably) a national health professional ID such as the licence or registration number. ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HDREncounter.admission.referringHP.name",
        "path" : "HDREncounter.admission.referringHP.name",
        "short" : "A.2.3.3.9 - Referring professional name",
        "definition" : "Person name [the structure of the name will be the same as for the patient (given name, family name / surname)].",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HDREncounter.admission.referringHP.organizationID",
        "path" : "HDREncounter.admission.referringHP.organizationID",
        "short" : "A.2.3.3.10 - Referring organisation ID",
        "definition" : "The healthcare provider organisation identifier.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HDREncounter.admission.referringHP.organization",
        "path" : "HDREncounter.admission.referringHP.organization",
        "short" : "A.2.3.3.11 - Referring organisation",
        "definition" : "The healthcare provider organisation information.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HDREncounter.admissionReason",
        "path" : "HDREncounter.admissionReason",
        "short" : "A.2.3.4 - Admission reason",
        "definition" : "Admission reason",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HDREncounter.admissionReason.code",
        "path" : "HDREncounter.admissionReason.code",
        "short" : "A.2.3.4.1 - Admission reason",
        "definition" : "Reason or reasons for admission, e.g. Problem, procedure or finding.",
        "comment" : "ICD-10*\nSNOMED CT\nOrphacode if rare disease is diagnosed",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HDREncounter.admissionReason.comment",
        "path" : "HDREncounter.admissionReason.comment",
        "short" : "A.2.3.4.2 - Admission reason comment",
        "definition" : "Explanation of the reason for the encounter.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HDREncounter.admissionReason.legalStatus",
        "path" : "HDREncounter.admissionReason.legalStatus",
        "short" : "A.2.3.4.3 - Admission legal status",
        "definition" : "Legal status/situation at admission. The legal status indicates the basis on which the patient is staying in a healthcare organisation. This can be either voluntary or involuntary, however the legal status is always determined by a court. A patient can also receive healthcare based on a forensic status. (voluntary, involuntary, admission by legal authority).",
        "comment" : "SNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HDREncounter.discharge",
        "path" : "HDREncounter.discharge",
        "short" : "A.2.3.5 - Discharge",
        "definition" : "Discharge",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HDREncounter.discharge.date",
        "path" : "HDREncounter.discharge.date",
        "short" : "A.2.3.5.1 - Discharge date",
        "definition" : "Discharge date and time",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HDREncounter.discharge.destinationType",
        "path" : "HDREncounter.discharge.destinationType",
        "short" : "A.2.3.5.2 - Discharge destination type",
        "definition" : "Type of location to which the patient will go after the encounter. E.g. home, hospital, nursing home, left against medical advice etc.  ",
        "comment" : "hl7.discharge-disposition",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HDREncounter.discharge.destinationLocation",
        "path" : "HDREncounter.discharge.destinationLocation",
        "short" : "A.2.3.5.3 - Destination location",
        "definition" : "The location/organisation to which the patient will go after the encounter. Name, address and telecommunication contact.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HDREncounter.location",
        "path" : "HDREncounter.location",
        "short" : "A.2.3.6 - Location - All locations/departments where the patient stayed (was boarded) within the hospital.",
        "definition" : "Location - All locations/departments where the patient stayed (was boarded) within the hospital.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HDREncounter.location.period",
        "path" : "HDREncounter.location.period",
        "short" : "A.2.3.6.1 - Period",
        "definition" : "Time period during which the patient was present at the location",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Period"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HDREncounter.location.organization",
        "path" : "HDREncounter.location.organization",
        "short" : "Organization",
        "definition" : "Organization or organization part (hospital department) where the patient was present.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HDREncounter.location.organization.identifier",
        "path" : "HDREncounter.location.organization.identifier",
        "short" : "A.2.3.6.2 - Organisation Part ID",
        "definition" : "The organisation’s part identifier.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HDREncounter.location.organization.name",
        "path" : "HDREncounter.location.organization.name",
        "short" : "A.2.3.6.3 - Organisation Part Name",
        "definition" : "Full name of the organisation part, e.g. Name of the department",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      },
      {
        "id" : "HDREncounter.location.organization.details",
        "path" : "HDREncounter.location.organization.details",
        "short" : "A.2.3.6.4 - Organisation Part Details",
        "definition" : "Address, contact names and contact details, specialty of the organisation part.",
        "comment" : "SNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "TBD"
          }
        ]
      }
    ]
  }
}

```
