# A.2.2 - Alerts (eHN) - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.2.2 - Alerts (eHN)**

## Logical Model: A.2.2 - Alerts (eHN) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HDRAlerts | *Version*:0.1.0 |
| Draft as of 2025-10-10 | *Computable Name*:HdrEHNAlerts |
| **Copyright/Legal**: Used by permission of the XpanDH project, all rights reserved Creative Commons License | |

 
Hospital Discharge Report - Alerts - A.2.2 eHN Maturity Level: 0 Draft 

**Usages:**

* Use this Logical Model: [A - Hospital Discharge Report (eHN)](StructureDefinition-HospitalDischargeReport.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.xpandh.hdr|current/StructureDefinition/HDRAlerts)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-HDRAlerts.csv), [Excel](StructureDefinition-HDRAlerts.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "HDRAlerts",
  "url" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HDRAlerts",
  "version" : "0.1.0",
  "name" : "HdrEHNAlerts",
  "title" : "A.2.2 - Alerts (eHN)",
  "status" : "draft",
  "date" : "2025-10-10T16:32:47+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "Hospital Discharge Report - Alerts - A.2.2 eHN\nMaturity Level: 0 Draft",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of the XpanDH project, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HDRAlerts",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "HDRAlerts",
        "path" : "HDRAlerts",
        "short" : "A.2.2 - Alerts (eHN)",
        "definition" : "Hospital Discharge Report - Alerts - A.2.2 eHN\nMaturity Level: 0 Draft"
      },
      {
        "id" : "HDRAlerts.allergy",
        "path" : "HDRAlerts.allergy",
        "short" : "A.2.2.1 - Allergy and Intolerance",
        "definition" : "A record of allergies and intolerances (primarily to be used for new allergies or intolerances that occurred during the hospital stay).",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRAlerts.allergy.description",
        "path" : "HDRAlerts.allergy.description",
        "short" : "A.2.2.1.1 - Allergy description",
        "definition" : "Textual description of the allergy or intolerance",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HDRAlerts.allergy.typeOfPropensity",
        "path" : "HDRAlerts.allergy.typeOfPropensity",
        "short" : "A.2.2.1.2 - Type of propensity",
        "definition" : "This element describes whether this condition refers to an allergy, non-allergy intolerance, or unknown class of intolerance (not known to be allergy or intolerance)",
        "comment" : "SNOMED CT ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRAlerts.allergy.manifestation",
        "path" : "HDRAlerts.allergy.manifestation",
        "short" : "A.2.2.1.3 - Allergy manifestation",
        "definition" : "Description of the clinical manifestation of the allergic reaction including date of manifestation and severity. Example: anaphylactic shock, angioedema (the clinical manifestation also gives information about the severity of the observed reaction). Multiple manifestations could be provided.",
        "comment" : "SNOMED CT",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRAlerts.allergy.severity",
        "path" : "HDRAlerts.allergy.severity",
        "short" : "A.2.2.1.4 - Severity ",
        "definition" : "Severity of the clinical manifestation of the allergic reaction. ",
        "comment" : "SNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRAlerts.allergy.criticality",
        "path" : "HDRAlerts.allergy.criticality",
        "short" : "A.2.2.1.5 - Criticality",
        "definition" : "Potential risk for future life-threatening adverse reactions when exposed to a substance known to cause an adverse reaction.",
        "comment" : "SNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRAlerts.allergy.onsetDate",
        "path" : "HDRAlerts.allergy.onsetDate",
        "short" : "A.2.2.1.6 - Onset date",
        "definition" : "Date of onset of allergy, e.g., date of the first observation of the reaction. Could be also expressed using a date, partial date or life period (childhood, adolescence).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRAlerts.allergy.onsetDate.date",
        "path" : "HDRAlerts.allergy.onsetDate.date",
        "short" : "Onset date",
        "definition" : "Date of onset of allergy, e.g., date of the first observation of the reaction. Could be also expressed using a date or partial date.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "HDRAlerts.allergy.onsetDate.code",
        "path" : "HDRAlerts.allergy.onsetDate.code",
        "short" : "Onset date",
        "definition" : "Date of onset of allergy, e.g., date of the first observation of the reaction expressed using code for life period (childhood, adolescence).",
        "comment" : "SNOMED CT ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRAlerts.allergy.endDate",
        "path" : "HDRAlerts.allergy.endDate",
        "short" : "A.2.2.1.7 - End date",
        "definition" : "Date of resolution of the allergy (e.g. when the clinician deemed there is no longer any need to track the underlying condition)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "HDRAlerts.allergy.endDate.date",
        "path" : "HDRAlerts.allergy.endDate.date",
        "short" : "End date",
        "definition" : "Date of resolution of the allergy (e.g. when the clinician deemed there is no longer any need to track the underlying condition)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "HDRAlerts.allergy.endDate.code",
        "path" : "HDRAlerts.allergy.endDate.code",
        "short" : "End date",
        "definition" : "Date of resolution of the allergy expressed by code (e.g. age group)",
        "comment" : "SNOMED CT ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRAlerts.allergy.status",
        "path" : "HDRAlerts.allergy.status",
        "short" : "A.2.2.1.8 - Status",
        "definition" : "Current status of the allergy or intolerance, for example, whether it is active, in remission, resolved, and so on …",
        "comment" : "Active, resolved, …",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRAlerts.allergy.certainty",
        "path" : "HDRAlerts.allergy.certainty",
        "short" : "A.2.2.1.9 - Certainty",
        "definition" : "Assertion about the certainty associated with a propensity, or potential risk, of a reaction to the identified substance. Diagnostic and/or clinical evidence of condition.",
        "comment" : "SNOMED CT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRAlerts.allergy.agent",
        "path" : "HDRAlerts.allergy.agent",
        "short" : "A.2.2.1.10 - Agent or Allergen",
        "definition" : "A specific allergen or other agent/substance (drug, food, chemical agent, etc.) to which the patient has an adverse reaction propensity.",
        "comment" : "SNOMED CT\nATC\n(IDMP / EMA SPOR SMS)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRAlerts.medicalAlerts",
        "path" : "HDRAlerts.medicalAlerts",
        "short" : "A.2.2.2 - Medical alerts (relevant for the respective hospital stay)",
        "definition" : "Medical alerts (relevant for the respective hospital stay)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRAlerts.medicalAlerts.description",
        "path" : "HDRAlerts.medicalAlerts.description",
        "short" : "A.2.2.2.1 - Healthcare alert description ",
        "definition" : "A warning, other than included in allergies.\nThe warning can be entered in code (there are codes for frequently used alerts) but seeing the dynamic nature of the warnings, these alerts will often be entered as free text.\nAny clinical information that is imperative to know so that the life or health of the patient does not come under threat.\nExample 1: the patient has a rare disease that requires special treatment\nExample 2: Airway Alert / Difficult Intubation\nExample 3: Diagnoses such as malignant hyperthermia, porphyria, and bleeding disorders; special treatments like anticoagulants or immunosuppressants; implanted devices.\nExample 4: transplanted organs illustrate other information that has to be taken into account in a healthcare contact.\nExample 5: participation in a clinical trial that has to be taken into account in a healthcare contact. ",
        "comment" : "SNOMED CT\nLOINC",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      }
    ]
  }
}

```
