# A.2.1 - Advance Directives (eHN) - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.2.1 - Advance Directives (eHN)**

## Logical Model: A.2.1 - Advance Directives (eHN) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HDRAdvanceDirectives | *Version*:0.1.0 |
| Draft as of 2025-10-10 | *Computable Name*:HdrEHNAdvanceDirectives |
| **Copyright/Legal**: Used by permission of the XpanDH project, all rights reserved Creative Commons License | |

 
Hospital Discharge Report - Advance Directives - A.2.1 eHN Maturity Level: 0 Draft 

**Usages:**

* Use this Logical Model: [A - Hospital Discharge Report (eHN)](StructureDefinition-HospitalDischargeReport.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.xpandh.hdr|current/StructureDefinition/HDRAdvanceDirectives)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-HDRAdvanceDirectives.csv), [Excel](StructureDefinition-HDRAdvanceDirectives.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "HDRAdvanceDirectives",
  "url" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HDRAdvanceDirectives",
  "version" : "0.1.0",
  "name" : "HdrEHNAdvanceDirectives",
  "title" : "A.2.1 - Advance Directives (eHN)",
  "status" : "draft",
  "date" : "2025-10-10T16:32:47+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "Hospital Discharge Report - Advance Directives - A.2.1 eHN\nMaturity Level: 0 Draft",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of the XpanDH project, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HDRAdvanceDirectives",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "HDRAdvanceDirectives",
        "path" : "HDRAdvanceDirectives",
        "short" : "A.2.1 - Advance Directives (eHN)",
        "definition" : "Hospital Discharge Report - Advance Directives - A.2.1 eHN\nMaturity Level: 0 Draft"
      },
      {
        "id" : "HDRAdvanceDirectives.livingWill",
        "path" : "HDRAdvanceDirectives.livingWill",
        "short" : "A.2.1.1 - Living will",
        "definition" : "Only directives being expressed during current inpatient stay. Multiple records of living wills could be provided.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRAdvanceDirectives.livingWill.date",
        "path" : "HDRAdvanceDirectives.livingWill.date",
        "short" : "A.2.1.1.1 - Date and time",
        "definition" : "The date and time on which the living will was recorded.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "HDRAdvanceDirectives.livingWill.type",
        "path" : "HDRAdvanceDirectives.livingWill.type",
        "short" : "A.2.1.1.2 - Type",
        "definition" : "Type of a living will, e.g. Do not resuscitate, donorship statement, power of attorney etc.",
        "comment" : "SNOMED CT",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRAdvanceDirectives.livingWill.comment",
        "path" : "HDRAdvanceDirectives.livingWill.comment",
        "short" : "A.2.1.1.3 - Comment",
        "definition" : "Comment on the living will.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HDRAdvanceDirectives.livingWill.conditions",
        "path" : "HDRAdvanceDirectives.livingWill.conditions",
        "short" : "A.2.1.1.4 - Related conditions",
        "definition" : "The problem or disorder to which the living will applies. Multiple fields could be provided.",
        "comment" : "ICD-10*\nSNOMED CT\nOrphacode if rare disease is diagnosed",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRAdvanceDirectives.livingWill.document",
        "path" : "HDRAdvanceDirectives.livingWill.document",
        "short" : "A.2.1.1.5 - Living will document",
        "definition" : "Scanned source document with the living will and the patient's signature, such as a PDF.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      }
    ]
  }
}

```
