# Composition: Hospital Discharge Report - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Composition: Hospital Discharge Report**

## Resource Profile: Composition: Hospital Discharge Report 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Composition-hdr-eu-xpandh | *Version*:0.1.0 |
| Draft as of 2025-10-10 | *Computable Name*:CompositionHdrXpandh |
| **Copyright/Legal**: XpanDH Project | |

 
Clinical document used to represent a Hospital Discharge Report (HDR) for the scope of the XpanDH project. 

**Usages:**

* Use this Profile: [Bundle: EU Hospital Discharge Report](StructureDefinition-Bundle-hdr-xpandh.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.xpandh.hdr|current/StructureDefinition/Composition-hdr-eu-xpandh)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Composition-hdr-eu-xpandh.csv), [Excel](StructureDefinition-Composition-hdr-eu-xpandh.xlsx), [Schematron](StructureDefinition-Composition-hdr-eu-xpandh.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Composition-hdr-eu-xpandh",
  "url" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Composition-hdr-eu-xpandh",
  "version" : "0.1.0",
  "name" : "CompositionHdrXpandh",
  "title" : "Composition: Hospital Discharge Report",
  "status" : "draft",
  "date" : "2025-10-10T16:32:47+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "Clinical document used to represent a Hospital Discharge Report (HDR) for the scope of the XpanDH project.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "XpanDH Project",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "fhirdocumentreference",
      "uri" : "http://hl7.org/fhir/documentreference",
      "name" : "FHIR DocumentReference"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Composition",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/clinicaldocument",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Composition",
        "path" : "Composition",
        "short" : "Hospital Discharge Report composition",
        "definition" : "Hospital Discharge Report composition. \r\nA composition is a set of healthcare-related information that is assembled together into a single logical document that provides a single coherent statement of meaning, establishes its own context and that has clinical attestation with regard to who is making the statement. \r\nWhile a Composition defines the structure, it does not actually contain the content: rather the full content of a document is contained in a Bundle, of which the Composition is the first resource contained."
      },
      {
        "id" : "Composition.extension:information-recipient",
        "path" : "Composition.extension",
        "sliceName" : "information-recipient",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.eu/fhir/StructureDefinition/information-recipient"
            ]
          }
        ]
      },
      {
        "id" : "Composition.extension:information-recipient/practictionerRole",
        "path" : "Composition.extension",
        "sliceName" : "information-recipient/practictionerRole",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Composition.extension:information-recipient/practictionerRole.value[x]",
        "path" : "Composition.extension.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/PractitionerRole-eu-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "Composition.identifier",
        "path" : "Composition.identifier",
        "short" : "HDR business identifier"
      },
      {
        "id" : "Composition.status",
        "path" : "Composition.status",
        "short" : "HDR status"
      },
      {
        "id" : "Composition.type",
        "path" : "Composition.type",
        "short" : "Kind of composition (\"Hospital Discharge Report\")",
        "definition" : "Specifies that this composition refer to a Hospital Discharge Report",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "34105-7"
            }
          ]
        }
      },
      {
        "id" : "Composition.subject",
        "path" : "Composition.subject",
        "definition" : "Who or what the composition is about. \r\nIn general a composition can be about a person, (patient or healthcare practitioner), a device (e.g. a machine) or even a group of subjects (such as a document about a herd of livestock, or a set of patients that share a common exposure).\r\nFor the hdr the subject is always the patient.",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Patient-eu-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "Composition.encounter",
        "path" : "Composition.encounter",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Encounter",
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/inpatient-encounter-hdr-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "Composition.date",
        "path" : "Composition.date",
        "short" : "HDR date"
      },
      {
        "id" : "Composition.author",
        "path" : "Composition.author",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Sliced per type of author",
        "definition" : "Sliced per type of author"
      },
      {
        "id" : "Composition.author:practictionerRole",
        "path" : "Composition.author",
        "sliceName" : "practictionerRole",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/PractitionerRole-eu-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "Composition.title",
        "path" : "Composition.title",
        "short" : "Hospital Discharge Report",
        "definition" : "Official human-readable label for the composition.\r\n\r\nFor this document should be \"Hospital Discharge Report\" or any equivalent translation"
      },
      {
        "id" : "Composition.attester.mode",
        "path" : "Composition.attester.mode",
        "short" : "The type of attestation"
      },
      {
        "id" : "Composition.section",
        "path" : "Composition.section",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Sections composing the Hospital Discharge Report",
        "definition" : "The root of the sections that make up the Hospital Discharge Report composition.",
        "min" : 2
      },
      {
        "id" : "Composition.section:admissionEvaluationSection",
        "path" : "Composition.section",
        "sliceName" : "admissionEvaluationSection",
        "short" : "Hospital Admission evaluation",
        "definition" : "Hospital Admission evaluation",
        "comment" : "Admission evaluation should be reported only exceptionally, if it is relevant to ensure continuity of care.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:admissionEvaluationSection.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:admissionEvaluationSection.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "fixedCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "67852-4"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:admissionEvaluationSection.text",
        "path" : "Composition.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:admissionEvaluationSection.emptyReason",
        "path" : "Composition.section.emptyReason",
        "max" : "0",
        "mustSupport" : false
      },
      {
        "id" : "Composition.section:admissionEvaluationSection.section",
        "path" : "Composition.section.section",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Objective findings",
        "definition" : "Findings made by healthcare practitioner"
      },
      {
        "id" : "Composition.section:admissionEvaluationSection.section:anthropometry",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "anthropometry",
        "short" : "Anthropometric observations",
        "definition" : "Anthropometric Observations sub-section",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:admissionEvaluationSection.section:anthropometry.title",
        "path" : "Composition.section.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:admissionEvaluationSection.section:anthropometry.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "fixedCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "248326004"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:admissionEvaluationSection.section:anthropometry.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:admissionEvaluationSection.section:anthropometry.entry",
        "path" : "Composition.section.section.entry",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/body-height-xpandh",
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/body-weight-xpandh",
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/bmi-xpandh",
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/skinfold-thickness-xpandh",
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/circumference-measurement-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:admissionEvaluationSection.section:anthropometry.emptyReason",
        "path" : "Composition.section.section.emptyReason",
        "max" : "0",
        "mustSupport" : false
      },
      {
        "id" : "Composition.section:admissionEvaluationSection.section:anthropometry.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:admissionEvaluationSection.section:vitalSigns",
        "path" : "Composition.section.section",
        "sliceName" : "vitalSigns",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:admissionEvaluationSection.section:vitalSigns.title",
        "path" : "Composition.section.section.title",
        "patternString" : "Vital signs"
      },
      {
        "id" : "Composition.section:admissionEvaluationSection.section:vitalSigns.code",
        "path" : "Composition.section.section.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "1184593002",
              "display" : "Vital sign document section (record artifact)"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:admissionEvaluationSection.section:vitalSigns.entry",
        "path" : "Composition.section.section.entry",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/blood-pressure-xpandh",
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/heart-rate-xpandh",
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/respiratory-rate-xpandh",
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/body-temperature-xpandh",
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/oxygen-saturation-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:admissionEvaluationSection.section:vitalSigns.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:admissionEvaluationSection.section:physicalExamination",
        "path" : "Composition.section.section",
        "sliceName" : "physicalExamination",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:admissionEvaluationSection.section:physicalExamination.title",
        "path" : "Composition.section.section.title",
        "patternString" : "Physical examination"
      },
      {
        "id" : "Composition.section:admissionEvaluationSection.section:physicalExamination.code",
        "path" : "Composition.section.section.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "425044008",
              "display" : "Physical exam section (record artifact)"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:admissionEvaluationSection.section:physicalExamination.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:admissionEvaluationSection.section:physicalExamination.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:admissionEvaluationSection.section:functionalStatus",
        "path" : "Composition.section.section",
        "sliceName" : "functionalStatus",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:admissionEvaluationSection.section:functionalStatus.title",
        "path" : "Composition.section.section.title",
        "patternString" : "Functional status assessment"
      },
      {
        "id" : "Composition.section:admissionEvaluationSection.section:functionalStatus.code",
        "path" : "Composition.section.section.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "1184588000",
              "display" : "Functional status document section (record artifact)"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:admissionEvaluationSection.section:functionalStatus.entry",
        "path" : "Composition.section.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/functional-status-assessment-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:admissionEvaluationSection.section:functionalStatus.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionHospitalCourse",
        "path" : "Composition.section",
        "sliceName" : "sectionHospitalCourse",
        "short" : "Significant information about course of hospital stay",
        "definition" : "This section includes basic information about hospital stay (encounter), diagnostic summary in narrative form, pharmacotherapy, major procedures, medical devices, significant findings during hospital stay and clinical synthesis.",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "fixedCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "8648-8"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.text",
        "path" : "Composition.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.entry",
        "path" : "Composition.section.entry",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/inpatient-encounter-hdr-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.emptyReason",
        "path" : "Composition.section.emptyReason",
        "max" : "0",
        "mustSupport" : false
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section",
        "path" : "Composition.section.section",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 3
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:diagnosticSummaryDescription",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "diagnosticSummaryDescription",
        "short" : "Diagnostic summary section",
        "definition" : "All problems/diagnoses that affect care during the inpatient case or are important to be recorded to ensure continuity of care. The diagnostic summary differentiates, in accordance with the international recommendation, between problems treated during hospital stay and other (untreated) problems. Treated problems are problems that were the subject of diagnostics, therapy, nursing, or (continuous) monitoring during the hospitalisation. Furthermore problems could be divided into three categories: problems present on admission (POA), conditions acquired during hospital stay (HAC) and problems that cannot be classified as being of any of the two (N/A). The diagnostic summary contains all conditions as they were recognised at the end of hospitalisation, after all examinations. This section contains concise, well specified, codeable, summary of problems. Problems are ordered by importance (main problems first) during hospital stay. Description of the problem might be completed with additional details in the medical history section and/or in the Synthesis section.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:diagnosticSummaryDescription.title",
        "path" : "Composition.section.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:diagnosticSummaryDescription.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "fixedCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "721981007"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:diagnosticSummaryDescription.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:diagnosticSummaryDescription.entry",
        "path" : "Composition.section.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/condition-encounter-hdr-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:diagnosticSummaryDescription.emptyReason",
        "path" : "Composition.section.section.emptyReason",
        "max" : "0",
        "mustSupport" : false
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:diagnosticSummaryDescription.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:significantProcedures",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "significantProcedures",
        "short" : "Significant procedures",
        "definition" : "Significant surgical and non-surgical procedures performed during hospitalisation which are significant for continuity of care, e.g. surgeries and other \"instrumental\"interventions (endoscopic, intravascular), chemotherapy, radiotherapy, purification methods (dialysis, hemoperfusion), circulation support methods (counterpulsation, etc.), administration of blood derivatives or others.\r\nThis section does not include purely diagnostic procedures (MRI, CT, etc.). If no significant performance has been performed, this fact must be explicitly stated using the IPS Absent and Unknown Data.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:significantProcedures.title",
        "path" : "Composition.section.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:significantProcedures.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "fixedCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "1269501001"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:significantProcedures.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:significantProcedures.entry",
        "path" : "Composition.section.section.entry",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Procedure-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:significantProcedures.emptyReason",
        "path" : "Composition.section.section.emptyReason",
        "max" : "0",
        "mustSupport" : false
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:significantProcedures.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:medicalDevices",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "medicalDevices",
        "short" : "Medical devices and implants",
        "definition" : "Implants and used medical devices that affected or may affect the provision of health services (diagnosis and treatment). Also medical devices explanted, or its use was stopped during hospitalisation. If the section is blank, the reason must be explicitly stated using the IPS Absent and Unknown Data coding system.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:medicalDevices.title",
        "path" : "Composition.section.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:medicalDevices.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "fixedCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "1184586001"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:medicalDevices.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:medicalDevices.entry",
        "path" : "Composition.section.section.entry",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/device-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:medicalDevices.emptyReason",
        "path" : "Composition.section.section.emptyReason",
        "max" : "0",
        "mustSupport" : false
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:medicalDevices.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:medications",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "medications",
        "short" : "Pharmacotherapy",
        "definition" : "Selected drug treatment during hospitalisation. Medicinal products that were administered during hospitalisation and whose administration has already been discontinued before discharge. Only products which are important for continuity of care (antibiotics other than completely routine, corticosteroids in high doses, etc.) will be listed. Products which administration will continue after discharge will be also recorder in the Medication summary section.\nMedicinal products, the administration of which was started during hospitalisation but is also recommended after discharge, will be listed in the summary table in the recommendation section.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:medications.title",
        "path" : "Composition.section.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:medications.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "fixedCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "761931002"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:medications.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:medications.entry",
        "path" : "Composition.section.section.entry",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/MedicationStatement-eu-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:medications.emptyReason",
        "path" : "Composition.section.section.emptyReason",
        "max" : "0",
        "mustSupport" : false
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:medications.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:significantResults",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "significantResults",
        "short" : "Significant Observation Results",
        "definition" : "Results of significant functional, diagnostic, and imaging examinations to ensure continuity of care, performed during hospitalisation. Results of examinations ordered but not yet delivered should be presented separately from results already delivered.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:significantResults.title",
        "path" : "Composition.section.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:significantResults.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "fixedCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "423100009"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:significantResults.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:significantResults.entry",
        "path" : "Composition.section.section.entry",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Observation",
              "http://hl7.org/fhir/uv/ips/StructureDefinition/Observation-results-radiology-uv-ips",
              "http://hl7.eu/fhir/laboratory/StructureDefinition/Observation-resultslab-eu-lab"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:significantResults.emptyReason",
        "path" : "Composition.section.section.emptyReason",
        "max" : "0",
        "mustSupport" : false
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:significantResults.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:synthesis",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "synthesis",
        "short" : "Synthesis",
        "definition" : "This section provides clinical synthesis (e.g. description of reasons and course of hospital stay) clustered by managed conditions. Clinical synthesis may include clinical reasoning (differential diagnostics, explanation of clinical context) in clinically complex conditions.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:synthesis.title",
        "path" : "Composition.section.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:synthesis.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "fixedCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "866144008"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:synthesis.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:synthesis.entry",
        "path" : "Composition.section.section.entry",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:synthesis.emptyReason",
        "path" : "Composition.section.section.emptyReason",
        "max" : "0",
        "mustSupport" : false
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:synthesis.section",
        "path" : "Composition.section.section.section",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Subsections of the Hospital Discharge Report Synthesis"
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:synthesis.section:problemSynthesis",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section.section",
        "sliceName" : "problemSynthesis",
        "short" : "Problem synthesis",
        "definition" : "Summary description of the reason and course of hospitalisation for a specific problem.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:synthesis.section:problemSynthesis.title",
        "path" : "Composition.section.section.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:synthesis.section:problemSynthesis.code",
        "path" : "Composition.section.section.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "fixedCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "423016009"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:synthesis.section:problemSynthesis.text",
        "path" : "Composition.section.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:synthesis.section:problemSynthesis.entry",
        "path" : "Composition.section.section.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/clinical-impression-hdr-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:synthesis.section:problemSynthesis.emptyReason",
        "path" : "Composition.section.section.section.emptyReason",
        "max" : "0",
        "mustSupport" : false
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:synthesis.section:clinicalReasoning",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section.section",
        "sliceName" : "clinicalReasoning",
        "short" : "Clinical reasoning",
        "definition" : "The clinical summary can be concluded with a clinical consideration (diff. diagnosis, explanation of context, etc.) for clinically complex conditions.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:synthesis.section:clinicalReasoning.title",
        "path" : "Composition.section.section.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:synthesis.section:clinicalReasoning.code",
        "path" : "Composition.section.section.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "fixedCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "1331904007"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:synthesis.section:clinicalReasoning.text",
        "path" : "Composition.section.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:synthesis.section:clinicalReasoning.entry",
        "path" : "Composition.section.section.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/clinical-impression-hdr-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionHospitalCourse.section:synthesis.section:clinicalReasoning.emptyReason",
        "path" : "Composition.section.section.section.emptyReason",
        "max" : "0",
        "mustSupport" : false
      },
      {
        "id" : "Composition.section:dischargeDetails",
        "path" : "Composition.section",
        "sliceName" : "dischargeDetails",
        "short" : "Discharge details",
        "definition" : "The hospital discharge status or disposition of the patient having a hospitalization.",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Composition.section:dischargeDetails.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:dischargeDetails.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "fixedCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "8650-4"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:dischargeDetails.text",
        "path" : "Composition.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:dischargeDetails.emptyReason",
        "path" : "Composition.section.emptyReason",
        "max" : "0",
        "mustSupport" : false
      },
      {
        "id" : "Composition.section:dischargeDetails.section",
        "path" : "Composition.section.section",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Objective findings",
        "definition" : "Findings made by healthcare practitioner"
      },
      {
        "id" : "Composition.section:dischargeDetails.section:anthropometry",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "anthropometry",
        "short" : "Anthropometric observations",
        "definition" : "Anthropometric Observations sub-section",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:dischargeDetails.section:anthropometry.title",
        "path" : "Composition.section.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:dischargeDetails.section:anthropometry.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "fixedCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "248326004"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:dischargeDetails.section:anthropometry.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:dischargeDetails.section:anthropometry.entry",
        "path" : "Composition.section.section.entry",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/body-height-xpandh",
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/body-weight-xpandh",
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/bmi-xpandh",
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/skinfold-thickness-xpandh",
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/circumference-measurement-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:dischargeDetails.section:anthropometry.emptyReason",
        "path" : "Composition.section.section.emptyReason",
        "max" : "0",
        "mustSupport" : false
      },
      {
        "id" : "Composition.section:dischargeDetails.section:anthropometry.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:dischargeDetails.section:vitalSigns",
        "path" : "Composition.section.section",
        "sliceName" : "vitalSigns",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:dischargeDetails.section:vitalSigns.title",
        "path" : "Composition.section.section.title",
        "patternString" : "Vital signs"
      },
      {
        "id" : "Composition.section:dischargeDetails.section:vitalSigns.code",
        "path" : "Composition.section.section.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "1184593002",
              "display" : "Vital sign document section (record artifact)"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:dischargeDetails.section:vitalSigns.entry",
        "path" : "Composition.section.section.entry",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/blood-pressure-xpandh",
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/heart-rate-xpandh",
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/respiratory-rate-xpandh",
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/body-temperature-xpandh",
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/oxygen-saturation-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:dischargeDetails.section:vitalSigns.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:dischargeDetails.section:physicalExamination",
        "path" : "Composition.section.section",
        "sliceName" : "physicalExamination",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:dischargeDetails.section:physicalExamination.title",
        "path" : "Composition.section.section.title",
        "patternString" : "Physical examination"
      },
      {
        "id" : "Composition.section:dischargeDetails.section:physicalExamination.code",
        "path" : "Composition.section.section.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "425044008",
              "display" : "Physical exam section (record artifact)"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:dischargeDetails.section:physicalExamination.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:dischargeDetails.section:physicalExamination.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:dischargeDetails.section:functionalStatus",
        "path" : "Composition.section.section",
        "sliceName" : "functionalStatus",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:dischargeDetails.section:functionalStatus.title",
        "path" : "Composition.section.section.title",
        "patternString" : "Functional status assessment"
      },
      {
        "id" : "Composition.section:dischargeDetails.section:functionalStatus.code",
        "path" : "Composition.section.section.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "1184588000",
              "display" : "Functional status document section (record artifact)"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:dischargeDetails.section:functionalStatus.entry",
        "path" : "Composition.section.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/functional-status-assessment-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:dischargeDetails.section:functionalStatus.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionPlanOfCare",
        "path" : "Composition.section",
        "sliceName" : "sectionPlanOfCare",
        "short" : "Care plan and other recommendations after discharge.",
        "definition" : "This section includes summary information on the medication recommended for the period after discharge, formal care plans and other recommendations (advice) after discharge.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionPlanOfCare.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionPlanOfCare.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "fixedCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "18776-5"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionPlanOfCare.text",
        "path" : "Composition.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionPlanOfCare.entry",
        "path" : "Composition.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/CarePlan",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPlanOfCare.emptyReason",
        "path" : "Composition.section.emptyReason",
        "max" : "0",
        "mustSupport" : false
      },
      {
        "id" : "Composition.section:sectionPlanOfCare.section",
        "path" : "Composition.section.section",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionPlanOfCare.section:medicationSummary",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "medicationSummary",
        "short" : "Medication summary",
        "definition" : "Summary information on the medication recommended for the period after discharge, indicating whether the medication is changed or newly started. Compared to previous practices, the overview is supplemented with medication that has been discontinued.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPlanOfCare.section:medicationSummary.title",
        "path" : "Composition.section.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionPlanOfCare.section:medicationSummary.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "fixedCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "721912009"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionPlanOfCare.section:medicationSummary.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionPlanOfCare.section:medicationSummary.entry",
        "path" : "Composition.section.section.entry",
        "short" : "Medication statement, Medication request/recommendation or Medications dispensation.",
        "definition" : "Medication statement on drug that has been or is taken, Medication request/recommendation for medication or Information about medication dispensed/provided to the patient on discharge.",
        "comment" : "Each medication statement should reflect status of the medication - indicating whether the medication is changed/unchanged or newly started.",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/MedicationStatement-eu-xpandh",
              "http://hl7.org/fhir/StructureDefinition/MedicationRequest",
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/MedicationDispense-hdr-eu-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPlanOfCare.section:medicationSummary.emptyReason",
        "path" : "Composition.section.section.emptyReason",
        "max" : "0",
        "mustSupport" : false
      },
      {
        "id" : "Composition.section:sectionPlanOfCare.section:medicationSummary.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionHealthInsurance",
        "path" : "Composition.section",
        "sliceName" : "sectionHealthInsurance",
        "short" : "Health insurance and payment information.",
        "definition" : "This section includes heath insurance and payment information.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionHealthInsurance.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionHealthInsurance.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "fixedCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "48768-6"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionHealthInsurance.text",
        "path" : "Composition.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionHealthInsurance.entry",
        "path" : "Composition.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/coverage-hdr-eu-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionHealthInsurance.emptyReason",
        "path" : "Composition.section.emptyReason",
        "max" : "0",
        "mustSupport" : false
      },
      {
        "id" : "Composition.section:patientHxSection",
        "path" : "Composition.section",
        "sliceName" : "patientHxSection",
        "short" : "Patient History Section",
        "definition" : "This Section describes all aspects of the medical history of the patient even if not pertinent to the current procedure, and may include chief complaint, past medical history, social history, family history, surgical or procedure history, medication history, and other history information. The history may be limited to information pertinent to the current procedure or may be more comprehensive. The history may be reported as a collection of random clinical statements or it may be reported categorically. Categorical report formats may be divided into multiple subsections including Past Medical History, Social History, Family member History.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:patientHxSection.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:patientHxSection.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "fixedCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "11329-0"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:patientHxSection.text",
        "path" : "Composition.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:patientHxSection.emptyReason",
        "path" : "Composition.section.emptyReason",
        "max" : "0",
        "mustSupport" : false
      },
      {
        "id" : "Composition.section:patientHxSection.section",
        "path" : "Composition.section.section",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Composition.section:patientHxSection.section:pastProblems",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "pastProblems",
        "short" : "History of Past Illness",
        "definition" : "A list of conditions of a patient that the patient suffered in the past or still suffers. Unlike diagnostic summary, medical history is not only a list of problems, but could contain broader description of the condition and its progress, details about treatment including medication and patient response to treatment. Past problem section (unlike the same section of the patient summary) should include only conditions that are important for continuity of care. This section, if provided, complements the diagnostic summary section of the discharge report.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:patientHxSection.section:pastProblems.title",
        "path" : "Composition.section.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:patientHxSection.section:pastProblems.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "fixedCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "1003642006"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:patientHxSection.section:pastProblems.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:patientHxSection.section:pastProblems.entry",
        "path" : "Composition.section.section.entry",
        "short" : "Condition details.",
        "definition" : "Conditions of a patient that the patient suffered in the past or still suffers.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/condition-hdr-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:patientHxSection.section:pastProblems.emptyReason",
        "path" : "Composition.section.section.emptyReason",
        "max" : "0",
        "mustSupport" : false
      },
      {
        "id" : "Composition.section:patientHxSection.section:pastProblems.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:patientHxSection.section:medicalDevicesHx",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "medicalDevicesHx",
        "short" : "Devices and Implants",
        "definition" : "A list of patient implanted and external medical devices and equipment upon which their health status depends. Includes devices such as cardiac pacemakers, implantable fibrillator, prosthesis, ferromagnetic bone implants, etc., of which the Health professional needs to be aware.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:patientHxSection.section:medicalDevicesHx.title",
        "path" : "Composition.section.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:patientHxSection.section:medicalDevicesHx.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "fixedCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "1184586001"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:patientHxSection.section:medicalDevicesHx.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:patientHxSection.section:medicalDevicesHx.entry",
        "path" : "Composition.section.section.entry",
        "short" : "Devices and Implants.",
        "definition" : "The patient implanted and external medical devices and equipment upon which their health status depends. Includes devices such as cardiac pacemakers, implantable fibrillator, prosthesis, ferromagnetic bone implants, etc., of which the Health professional needs to be aware.",
        "comment" : "This entry shall be also used to document that no information about medical device use is available, or that no relevant medical device use is known using the IPS Absent and Unknown Data.",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/DeviceUseStatement"]
          }
        ]
      },
      {
        "id" : "Composition.section:patientHxSection.section:medicalDevicesHx.emptyReason",
        "path" : "Composition.section.section.emptyReason",
        "max" : "0",
        "mustSupport" : false
      },
      {
        "id" : "Composition.section:patientHxSection.section:medicalDevicesHx.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:patientHxSection.section:proceduresHx",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "proceduresHx",
        "short" : "History of procedures",
        "definition" : "Historical procedures performed on or for a patient, relevant for the current encounter.\r\n\n    Examples include surgical procedures, diagnostic procedures, endoscopic procedures, biopsies, counselling, physiotherapy, personal support services, adult day care services, etc.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:patientHxSection.section:proceduresHx.title",
        "path" : "Composition.section.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:patientHxSection.section:proceduresHx.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "fixedCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "1269501001"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:patientHxSection.section:proceduresHx.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:patientHxSection.section:proceduresHx.entry",
        "path" : "Composition.section.section.entry",
        "short" : "Procedures",
        "definition" : "Historical procedures performed on or for a patient, relevant for the current encounter.",
        "comment" : "This entry shall be also used to document that no information about procedures is available, or that no relevant procedures is known using the IPS Absent and Unknown Data.",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Procedure-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:patientHxSection.section:proceduresHx.emptyReason",
        "path" : "Composition.section.section.emptyReason",
        "max" : "0",
        "mustSupport" : false
      },
      {
        "id" : "Composition.section:patientHxSection.section:proceduresHx.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:patientHxSection.section:vaccination",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "vaccination",
        "short" : "Vaccination history",
        "definition" : "Vaccination history of the patient",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:patientHxSection.section:vaccination.title",
        "path" : "Composition.section.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:patientHxSection.section:vaccination.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "fixedCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "41000179103"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:patientHxSection.section:vaccination.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:patientHxSection.section:vaccination.entry",
        "path" : "Composition.section.section.entry",
        "short" : "Patient's immunization status and pertinent history.",
        "definition" : "It defines the patient's current immunization status and pertinent immunization history.\r\nThe primary use case for the Immunization Section is to enable communication of a patient's immunization status.\r\n It may contain the entire immunization history that is relevant to the period of time being summarized. This entry shall be used to document that no information about immunizations is available, or that no immunizations are known.",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/immunization-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:patientHxSection.section:vaccination.emptyReason",
        "path" : "Composition.section.section.emptyReason",
        "max" : "0",
        "mustSupport" : false
      },
      {
        "id" : "Composition.section:patientHxSection.section:vaccination.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:patientHxSection.section:infectiousContacts",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "infectiousContacts",
        "short" : "Infectious contacts",
        "definition" : "Infectious contacts of the patient",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:patientHxSection.section:infectiousContacts.title",
        "path" : "Composition.section.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:patientHxSection.section:infectiousContacts.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "fixedCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "444071008"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:patientHxSection.section:infectiousContacts.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:patientHxSection.section:infectiousContacts.entry",
        "path" : "Composition.section.section.entry",
        "short" : "Exposure to an infectious agent.",
        "definition" : "Information about a suspected infectious agent or agents the person was exposed to.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/infectious-contact-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:patientHxSection.section:infectiousContacts.emptyReason",
        "path" : "Composition.section.section.emptyReason",
        "max" : "0",
        "mustSupport" : false
      },
      {
        "id" : "Composition.section:patientHxSection.section:infectiousContacts.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:patientHxSection.section:travelHx",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "travelHx",
        "short" : "Travel history",
        "definition" : "Travel history",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:patientHxSection.section:travelHx.title",
        "path" : "Composition.section.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:patientHxSection.section:travelHx.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "fixedCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "443846001"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:patientHxSection.section:travelHx.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:patientHxSection.section:travelHx.entry",
        "path" : "Composition.section.section.entry",
        "short" : "Travel history of the patient.",
        "definition" : "Travel history as reported by the patient or other informant.",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/travel-history-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:patientHxSection.section:travelHx.emptyReason",
        "path" : "Composition.section.section.emptyReason",
        "max" : "0",
        "mustSupport" : false
      },
      {
        "id" : "Composition.section:patientHxSection.section:travelHx.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:patientHxSection.section:familyHx",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "familyHx",
        "short" : "Family history",
        "definition" : "Information about serious illnesses in close blood relatives with known or suspected genetic potential or with possible impact on patient care.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:patientHxSection.section:familyHx.title",
        "path" : "Composition.section.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:patientHxSection.section:familyHx.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "fixedCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "422432008"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:patientHxSection.section:familyHx.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:patientHxSection.section:familyHx.entry",
        "path" : "Composition.section.section.entry",
        "short" : "Family history",
        "definition" : "Family history",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/FamilyMemberHistory"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:patientHxSection.section:familyHx.emptyReason",
        "path" : "Composition.section.section.emptyReason",
        "max" : "0",
        "mustSupport" : false
      },
      {
        "id" : "Composition.section:patientHxSection.section:familyHx.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:patientHxSection.section:socialHx",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section.section",
        "sliceName" : "socialHx",
        "short" : "Social history",
        "definition" : "Information about social determinants of health.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:patientHxSection.section:socialHx.title",
        "path" : "Composition.section.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:patientHxSection.section:socialHx.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "fixedCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "1184589008"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:patientHxSection.section:socialHx.text",
        "path" : "Composition.section.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:patientHxSection.section:socialHx.entry",
        "path" : "Composition.section.section.entry",
        "short" : "Social history",
        "definition" : "Social determinants of health",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/social-history-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:patientHxSection.section:socialHx.emptyReason",
        "path" : "Composition.section.section.emptyReason",
        "max" : "0",
        "mustSupport" : false
      },
      {
        "id" : "Composition.section:patientHxSection.section:socialHx.section",
        "path" : "Composition.section.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionAllergies",
        "path" : "Composition.section",
        "sliceName" : "sectionAllergies",
        "short" : "HDR Allergies and Intolerances Section",
        "definition" : "This section documents the relevant allergies or intolerances (conditions) for that patient, describing the kind of reaction (e.g. rash, anaphylaxis,..); preferably the agents that cause it; and optionally the criticality and the certainty of the allergy.\r\nAt a minimum, it should list currently active and any relevant historical allergies and adverse reactions.\r\nIf no information about allergies is available, or if no allergies are known this should be clearly documented in the section.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionAllergies.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionAllergies.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "fixedCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "48765-2"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionAllergies.text",
        "path" : "Composition.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionAllergies.entry",
        "path" : "Composition.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Relevant allergies or intolerances (conditions) for that patient.",
        "definition" : "It lists the relevant allergies or intolerances (conditions) for that patient, describing the kind of reaction (e.g. rash, anaphylaxis,..); preferably the agents that cause it; and optionally the criticality and the certainty of the allergy.\r\nAt a minimum, it should list currently active and any relevant historical allergies and adverse reactions.\r\n This entry shall be used to document that no information about allergies is available, or that no allergies are known .",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/AllergyIntolerance",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAllergies.entry:allergyIntolerance",
        "path" : "Composition.section.entry",
        "sliceName" : "allergyIntolerance",
        "short" : "HDR Allergy entry",
        "definition" : "HDR Allergy entry",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/AllergyIntolerance-uv-ips"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:sectionAllergies.emptyReason",
        "path" : "Composition.section.emptyReason",
        "max" : "0",
        "mustSupport" : false
      },
      {
        "id" : "Composition.section:alertSection",
        "path" : "Composition.section",
        "sliceName" : "alertSection",
        "short" : "Health Concern Section",
        "definition" : "// SHORT\n      This section contains data describing an interest or worry about a health state or process that could possibly require attention, intervention, or management. A Health Concern is a health related matter that is of interest, importance or worry to someone, who may be the patient, patient's family or patient's health care provider. Health concerns are derived from a variety of sources within an EHR, such as Problem List, Family History, Social Histor, Social Worker Note, etc. Health concerns can be medical, surgical, nursing, allied health or patient-reported concerns. Problem Concerns are a subset of Health Concerns that have risen to the level of importance that they typically would belong on a classic “Problem List”, such as “Diabetes Mellitus” or “Family History of Melanoma” or “Tobacco abuse”. These are of broad interest to multiple members of the care team. Examples of other Health Concerns that might not typically be considered a Problem Concern include “Risk of Hyperkalemia” for a patient taking an ACE-inhibitor medication, or “Transportation difficulties” for someone who doesn't drive and has trouble getting to appointments, or “Under-insured” for someone who doesn't have sufficient insurance to properly cover their medical needs such as medications. These are typically most important to just a limited number of care team members",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:alertSection.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:alertSection.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "fixedCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "104605-1"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:alertSection.text",
        "path" : "Composition.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:alertSection.entry",
        "path" : "Composition.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Alerts",
        "definition" : "Alerts"
      },
      {
        "id" : "Composition.section:alertSection.entry:flag",
        "path" : "Composition.section.entry",
        "sliceName" : "flag",
        "short" : "Flags",
        "definition" : "Flags",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Flag-eu-xpandh"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:alertSection.entry:detectedIssue",
        "path" : "Composition.section.entry",
        "sliceName" : "detectedIssue",
        "short" : "Detected Issue",
        "definition" : "Indicates an actual or potential clinical issue with or between one or more active or proposed clinical actions for a patient; e.g. Drug-drug interaction, Ineffective treatment frequency, Procedure-condition conflict, etc.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/DetectedIssue"]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:alertSection.entry:riskAssessment",
        "path" : "Composition.section.entry",
        "sliceName" : "riskAssessment",
        "short" : "Risk Assessment",
        "definition" : "An assessment of the likely outcomes for a patient or other subject as well as the likelihood of each outcome.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/RiskAssessment"]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:alertSection.emptyReason",
        "path" : "Composition.section.emptyReason",
        "max" : "0",
        "mustSupport" : false
      },
      {
        "id" : "Composition.section:CareTeamSection",
        "path" : "Composition.section",
        "sliceName" : "CareTeamSection",
        "short" : "Care Team Section",
        "definition" : "// SHORT\n      The Care Team Section is used to share historical and current Care Team information.",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:CareTeamSection.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:CareTeamSection.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "fixedCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "85847-2"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:CareTeamSection.text",
        "path" : "Composition.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:CareTeamSection.entry",
        "path" : "Composition.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Care Teams",
        "definition" : "Care Teams"
      },
      {
        "id" : "Composition.section:CareTeamSection.entry:cteam",
        "path" : "Composition.section.entry",
        "sliceName" : "cteam",
        "short" : "Care Team",
        "definition" : "Care Team",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/CareTeam-eu-xpandh"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:CareTeamSection.emptyReason",
        "path" : "Composition.section.emptyReason",
        "max" : "0",
        "mustSupport" : false
      },
      {
        "id" : "Composition.section:CareTeamSection.section",
        "path" : "Composition.section.section",
        "max" : "0",
        "mustSupport" : false
      },
      {
        "id" : "Composition.section:sectionAdvanceDirectives",
        "path" : "Composition.section",
        "sliceName" : "sectionAdvanceDirectives",
        "short" : "Advance Directives Section",
        "definition" : "The advance directives section contains a narrative description of patient's advance directive.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionAdvanceDirectives.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionAdvanceDirectives.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "fixedCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "42348-3"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionAdvanceDirectives.text",
        "path" : "Composition.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section:sectionAdvanceDirectives.entry",
        "path" : "Composition.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Consent",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAdvanceDirectives.emptyReason",
        "path" : "Composition.section.emptyReason",
        "max" : "0",
        "mustSupport" : false
      }
    ]
  }
}

```
