# CareTeam - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CareTeam**

## Resource Profile: CareTeam 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/CareTeam-eu-xpandh | *Version*:0.1.0 |
| Draft as of 2025-10-10 | *Computable Name*:CareTeamXpandh |
| **Copyright/Legal**: Used by permission of the XpanDH project, all rights reserved Creative Commons License | |

 
This profile constrains the CareTeam resource for the purpose of the XpanDH project. 

**Usages:**

* Refer to this Profile: [CareTeam](StructureDefinition-CareTeam-eu-xpandh.md), [Composition: Hospital Discharge Report](StructureDefinition-Composition-hdr-eu-xpandh.md) and [Xpandh Assessment Observation Profile](StructureDefinition-assessment-observation-xpandh.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.xpandh.hdr|current/StructureDefinition/CareTeam-eu-xpandh)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-CareTeam-eu-xpandh.csv), [Excel](StructureDefinition-CareTeam-eu-xpandh.xlsx), [Schematron](StructureDefinition-CareTeam-eu-xpandh.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "CareTeam-eu-xpandh",
  "url" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/CareTeam-eu-xpandh",
  "version" : "0.1.0",
  "name" : "CareTeamXpandh",
  "title" : "CareTeam",
  "status" : "draft",
  "date" : "2025-10-10T16:32:47+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "This profile constrains the CareTeam resource for the purpose of the XpanDH project.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of the XpanDH project, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "CareTeam",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/CareTeam",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "CareTeam",
        "path" : "CareTeam"
      },
      {
        "id" : "CareTeam.subject",
        "path" : "CareTeam.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Patient-eu-xpandh"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "CareTeam.participant",
        "path" : "CareTeam.participant",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "CareTeam.participant.role",
        "path" : "CareTeam.participant.role",
        "mustSupport" : true
      },
      {
        "id" : "CareTeam.participant.member",
        "path" : "CareTeam.participant.member",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Practitioner-eu-xpandh",
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/PractitionerRole-eu-xpandh",
              "http://hl7.org/fhir/StructureDefinition/RelatedPerson",
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/organization-expandh",
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/CareTeam-eu-xpandh"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "CareTeam.reasonCode",
        "path" : "CareTeam.reasonCode",
        "short" : "Problem this team is in charge of"
      },
      {
        "id" : "CareTeam.reasonReference",
        "path" : "CareTeam.reasonReference",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/condition-hdr-xpandh"
            ]
          }
        ]
      }
    ]
  }
}

```
