# eHN Recipient to this guide Map - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **eHN Recipient to this guide Map**

## ConceptMap: eHN Recipient to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/hdr/ConceptMap/ConceptMap-hdrHeader2FHIR-eu-xpandh | *Version*:0.1.0 |
| Draft as of 2025-10-10 | *Computable Name*:HdrHeader2FHIR |
| **Copyright/Legal**: Used by permission of the XpanDH project, all rights reserved Creative Commons License | |

 
eHN HDR Encounter Model to this guide mapping 

 
Proposed relationship between the HDR Encounter data set defined by the EU eHN guidelines and this guide 

Mapping from [A - Hospital Discharge Report (eHN)](StructureDefinition-HospitalDischargeReport.md) to [Patient: HDR](StructureDefinition-Patient-eu-xpandh.md)

**Group 1**Mapping from [A - Hospital Discharge Report (eHN)](StructureDefinition-HospitalDischargeReport.md) to [Patient: HDR](StructureDefinition-Patient-eu-xpandh.md)

* **Source Code**: HospitalDischargeReport.header.subjectIdentification (A.1.1 - Identification of the patient/subject [Mandatory])
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Patient
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.header.subjectIdentification.given (A.1.1.1 - Given name [Mandatory])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.name.given
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.header.subjectIdentification.family (A.1.1.2 - Family name/surname [Mandatory])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.name.family
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.header.subjectIdentification.birthDate (A.1.1.3 - Date of birth [Required])
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: Patient.birthDate
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.header.subjectIdentification.identifier (A.1.1.4 - Personal identifier [Required])
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: Patient.identifier
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.header.subjectIdentification.nationality (A.1.1.5 - Nationality [Required])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.extension[
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.header.subjectIdentification.gender (A.1.1.6 - Gender [Mandatory])
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: Patient.gender
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.header.subjectIdentification.language (A.1.1.7 - Language communication [Optional])
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: Patient.communicaiton.language
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.header.subjectContact (A.1.2 - Patient/subject related contact information [Required])
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Patient
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.header.subjectContact.contactPoint (A.1.2.1 - Patient address [])
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Patient
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.header.subjectContact.contactPoint.address (A.1.2.1.1 - Address [Required])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.address
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.header.subjectContact.contactPoint.telecom (A.1.2.1.2 - Telecom [Required])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.telecom
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.header.subjectContact.contactPoint.preferredHP (A.1.2.2 - Preferred healthcare professional (HP) [Optional])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.generalPractitioner
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.header.subjectContact.contactPoint.preferredHP.identifier (A.1.2.2.1 - Identifier [Required])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.generalPractitioner.identifier
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.header.subjectContact.contactPoint.preferredHP.name (A.1.2.2.2 - Name of the HP [Required])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.generalPractitioner.name
  * **Comment**: if Organization (or Practictioner)
* **Source Code**: HospitalDischargeReport.header.subjectContact.contactPoint.preferredHP.name (A.1.2.2.2 - Name of the HP [Required])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.generalPractitioner.practictioner.name
  * **Comment**: if PractictionerRole
* **Source Code**: HospitalDischargeReport.header.subjectContact.contactPoint.preferredHP.role (A.1.2.2.3 - Role of the HP [Required])
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: Patient.generalPractitioner.code
  * **Comment**: if PractictionerRole
* **Source Code**: HospitalDischargeReport.header.subjectContact.contactPoint.preferredHP.organization (A.1.2.2.4 - HP Organisation [Required])
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Patient.generalPractitioner
  * **Comment**: if Organization
* **Source Code**: HospitalDischargeReport.header.subjectContact.contactPoint.preferredHP.organization (A.1.2.2.4 - HP Organisation [Required])
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Patient.generalPractitioner.organization
  * **Comment**: if PractictionerRole
* **Source Code**: HospitalDischargeReport.header.subjectContact.contactPoint.preferredHP.address (A.1.2.2.5 - Address [Optional])
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Patient.generalPractitioner
  * **Comment**: the path depends on the type
* **Source Code**: HospitalDischargeReport.header.subjectContact.contactPoint.preferredHP.telecom (A.1.2.2.6 - Telecom [Required])
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Patient.generalPractitioner
  * **Comment**: the path depends on the type
* **Source Code**: HospitalDischargeReport.header.subjectContact.contactPoint.person (A.1.2.3 - Contact person/ legal guardian [Required])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.contact
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.header.subjectContact.contactPoint.person.role (A.1.2.3.1 - Role of that person [Required])
  * **Relationship**: (not mapped)
  * **Target Code**: To be clarified?
* **Source Code**: HospitalDischargeReport.header.subjectContact.contactPoint.person.relationship (A.1.2.3.2 - Relationship level [Required])
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Patient.contact.relationship
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.header.subjectContact.contactPoint.person.identifier (A.1.2.3.3 - Identifier [Optional])
  * **Relationship**: (not mapped)
  * **Target Code**: maybe via http://hl7.org/fhir/StructureDefinition/patient-relatedPerson extension ?
* **Source Code**: HospitalDischargeReport.header.subjectContact.contactPoint.person.given (A.1.2.3.4 - Given name [Mandatory])
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: Patient.contact.name.given
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.header.subjectContact.contactPoint.person.name (A.1.2.3.5 - Family name/surname [Mandatory])
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: Patient.contact.name.family
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.header.subjectContact.contactPoint.person.address (A.1.2.3.6 - Address [Optional])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.contact.address
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.header.subjectContact.contactPoint.person.telecom (A.1.2.3.7 - Telecom [Required])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Patient.contact.telecom
  * **Comment**: 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "ConceptMap-hdrHeader2FHIR-eu-xpandh",
  "url" : "http://hl7.eu/fhir/ig/xpandh/hdr/ConceptMap/ConceptMap-hdrHeader2FHIR-eu-xpandh",
  "version" : "0.1.0",
  "name" : "HdrHeader2FHIR",
  "title" : "eHN Recipient to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-10-10T16:32:47+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "eHN HDR Encounter Model to this guide mapping",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "purpose" : "Proposed relationship between the HDR Encounter data set defined by the EU eHN guidelines and this guide",
  "copyright" : "Used by permission of the XpanDH project, all rights reserved Creative Commons License",
  "sourceUri" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HospitalDischargeReport",
  "targetUri" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Patient-eu-xpandh",
  "group" : [
    {
      "source" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HospitalDischargeReport",
      "target" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Patient-eu-xpandh",
      "element" : [
        {
          "code" : "HospitalDischargeReport.header.subjectIdentification",
          "display" : "A.1.1 - Identification of the patient/subject [Mandatory]",
          "target" : [
            {
              "code" : "Patient",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.subjectIdentification.given",
          "display" : "A.1.1.1 - Given name [Mandatory]",
          "target" : [
            {
              "code" : "Patient.name.given",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.subjectIdentification.family",
          "display" : "A.1.1.2 - Family name/surname [Mandatory]",
          "target" : [
            {
              "code" : "Patient.name.family",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.subjectIdentification.birthDate",
          "display" : "A.1.1.3 - Date of birth [Required]",
          "target" : [
            {
              "code" : "Patient.birthDate",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.subjectIdentification.identifier",
          "display" : "A.1.1.4 - Personal identifier [Required]",
          "target" : [
            {
              "code" : "Patient.identifier",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.subjectIdentification.nationality",
          "display" : "A.1.1.5 - Nationality [Required]",
          "target" : [
            {
              "code" : "Patient.extension[",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.subjectIdentification.gender",
          "display" : "A.1.1.6 - Gender [Mandatory]",
          "target" : [
            {
              "code" : "Patient.gender",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.subjectIdentification.language",
          "display" : "A.1.1.7 - Language communication [Optional]",
          "target" : [
            {
              "code" : "Patient.communicaiton.language",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.subjectContact",
          "display" : "A.1.2 - Patient/subject related contact information [Required]",
          "target" : [
            {
              "code" : "Patient",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.subjectContact.contactPoint",
          "display" : "A.1.2.1 - Patient address []",
          "target" : [
            {
              "code" : "Patient",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.subjectContact.contactPoint.address",
          "display" : "A.1.2.1.1 - Address [Required]",
          "target" : [
            {
              "code" : "Patient.address",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.subjectContact.contactPoint.telecom",
          "display" : "A.1.2.1.2 - Telecom [Required]",
          "target" : [
            {
              "code" : "Patient.telecom",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.subjectContact.contactPoint.preferredHP",
          "display" : "A.1.2.2 - Preferred healthcare professional (HP) [Optional]",
          "target" : [
            {
              "code" : "Patient.generalPractitioner",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.subjectContact.contactPoint.preferredHP.identifier",
          "display" : "A.1.2.2.1 - Identifier [Required]",
          "target" : [
            {
              "code" : "Patient.generalPractitioner.identifier",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.subjectContact.contactPoint.preferredHP.name",
          "display" : "A.1.2.2.2 - Name of the HP [Required]",
          "target" : [
            {
              "code" : "Patient.generalPractitioner.name",
              "equivalence" : "equivalent",
              "comment" : "if Organization (or Practictioner)"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.subjectContact.contactPoint.preferredHP.name",
          "display" : "A.1.2.2.2 - Name of the HP [Required]",
          "target" : [
            {
              "code" : "Patient.generalPractitioner.practictioner.name",
              "equivalence" : "equivalent",
              "comment" : "if PractictionerRole"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.subjectContact.contactPoint.preferredHP.role",
          "display" : "A.1.2.2.3 - Role of the HP [Required]",
          "target" : [
            {
              "code" : "Patient.generalPractitioner.code",
              "equivalence" : "equal",
              "comment" : "if PractictionerRole"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.subjectContact.contactPoint.preferredHP.organization",
          "display" : "A.1.2.2.4 - HP Organisation [Required]",
          "target" : [
            {
              "code" : "Patient.generalPractitioner",
              "equivalence" : "relatedto",
              "comment" : "if Organization"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.subjectContact.contactPoint.preferredHP.organization",
          "display" : "A.1.2.2.4 - HP Organisation [Required]",
          "target" : [
            {
              "code" : "Patient.generalPractitioner.organization",
              "equivalence" : "relatedto",
              "comment" : "if PractictionerRole"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.subjectContact.contactPoint.preferredHP.address",
          "display" : "A.1.2.2.5 - Address [Optional]",
          "target" : [
            {
              "code" : "Patient.generalPractitioner",
              "equivalence" : "relatedto",
              "comment" : "the path depends on the type"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.subjectContact.contactPoint.preferredHP.telecom",
          "display" : "A.1.2.2.6 - Telecom [Required]",
          "target" : [
            {
              "code" : "Patient.generalPractitioner",
              "equivalence" : "relatedto",
              "comment" : "the path depends on the type"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.subjectContact.contactPoint.person",
          "display" : "A.1.2.3 - Contact person/ legal guardian [Required]",
          "target" : [
            {
              "code" : "Patient.contact",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.subjectContact.contactPoint.person.role",
          "display" : "A.1.2.3.1 - Role of that person [Required]",
          "target" : [
            {
              "equivalence" : "unmatched",
              "comment" : "To be clarified?"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.subjectContact.contactPoint.person.relationship",
          "display" : "A.1.2.3.2 - Relationship level [Required]",
          "target" : [
            {
              "code" : "Patient.contact.relationship",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.subjectContact.contactPoint.person.identifier",
          "display" : "A.1.2.3.3 - Identifier [Optional]",
          "target" : [
            {
              "equivalence" : "unmatched",
              "comment" : "maybe via http://hl7.org/fhir/StructureDefinition/patient-relatedPerson extension ?"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.subjectContact.contactPoint.person.given",
          "display" : "A.1.2.3.4 - Given name [Mandatory]",
          "target" : [
            {
              "code" : "Patient.contact.name.given",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.subjectContact.contactPoint.person.name",
          "display" : "A.1.2.3.5 - Family name/surname [Mandatory]",
          "target" : [
            {
              "code" : "Patient.contact.name.family",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.subjectContact.contactPoint.person.address",
          "display" : "A.1.2.3.6 - Address [Optional]",
          "target" : [
            {
              "code" : "Patient.contact.address",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.subjectContact.contactPoint.person.telecom",
          "display" : "A.1.2.3.7 - Telecom [Required]",
          "target" : [
            {
              "code" : "Patient.contact.telecom",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    }
  ]
}

```
