# eHN Recipient to this guide Map - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **eHN Recipient to this guide Map**

## ConceptMap: eHN Recipient to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/hdr/ConceptMap/ConceptMap-HeaderParticipants2FHIR-eu-xpandh | *Version*:0.1.0 |
| Draft as of 2025-10-10 | *Computable Name*:HeaderParticipants2FHIR |
| **Copyright/Legal**: Used by permission of the XpanDH project, all rights reserved Creative Commons License | |

 
eHN HDR Encounter Model to this guide mapping 

 
Proposed relationship between the HDR Encounter data set defined by the EU eHN guidelines and this guide 

Mapping from [A - Hospital Discharge Report (eHN)](StructureDefinition-HospitalDischargeReport.md) to http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Composition-eu-xpandh

**Group 1**Mapping from [A - Hospital Discharge Report (eHN)](StructureDefinition-HospitalDischargeReport.md) to `http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Composition-eu-xpandh`

* **Source Code**: HospitalDischargeReport.header.payer (A.1.3 - Health insurance and payment information [Required])
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.extension:basedOn-order-or-requisition.insurance
  * **Comment**: To be disucssed if the payor is conveyed with the request or thorugh other means
* **Source Code**: HospitalDischargeReport.header.payer.insuranceCode (A.1.3.1 - Health insurance code [Mandatory])
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.extension:basedOn-order-or-requisition.insurance.payor.identifier
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.header.payer.insuranceName (A.1.3.2 - Health insurance name [Required])
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.extension:basedOn-order-or-requisition.insurance.payor.name
  * **Comment**: with payor as Organization
* **Source Code**: HospitalDischargeReport.header.payer.insuranceNumber (A.1.3.3 - Health insurance number [Mandatory])
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.extension:basedOn-order-or-requisition.insurance.beneficiary.identifier
  * **Comment**: to be discussed
* **Source Code**: HospitalDischargeReport.header.informationRecipient (A.1.4 - Information recipient [Required])
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.extension:information-recipient
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.header.informationRecipient.identifier (A.1.4.1 - Recipient identifier [Required])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.extension:information-recipient.identifier
  * **Comment**: If PractictionerRole
* **Source Code**: HospitalDischargeReport.header.informationRecipient.name (A.1.4.2 - Recipient name [Required])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.extension:information-recipient.practictioner.name
  * **Comment**: If PractictionerRole
* **Source Code**: HospitalDischargeReport.header.informationRecipient.organizationID (A.1.4.3 - Recipient organization ID [Required])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.extension:information-recipient.organization.identifier
  * **Comment**: If PractictionerRole
* **Source Code**: HospitalDischargeReport.header.informationRecipient.organization (A.1.4.4 - Recipient organization [Required])
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.extension:information-recipient.organization
  * **Comment**: If PractictionerRole
* **Source Code**: HospitalDischargeReport.header.author (A.1.5 - Author (by whom the Hospital discharge report was authored) [Mandatory])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.author
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.header.author.identifier (A.1.5.1 - Author identifier [Mandatory])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.author.identifier
  * **Comment**: If PractictionerRole
* **Source Code**: HospitalDischargeReport.header.author.name (A.1.5.2 - Author name [Mandatory])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.author.practictioner.name
  * **Comment**: If PractictionerRole
* **Source Code**: HospitalDischargeReport.header.author.organizationID (A.1.5.3 - Author organization ID [Required])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.author.organization.identifier
  * **Comment**: If PractictionerRole
* **Source Code**: HospitalDischargeReport.header.author.organization (A.1.5.4 - Author organization [Mandatory])
  * **Relationship**: [is related to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#relatedto)
  * **Target Code**: Composition.author.organization
  * **Comment**: If PractictionerRole
* **Source Code**: HospitalDischargeReport.header.author.dateTime (A.1.5.5 - DateTime [Mandatory])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.date
  * **Comment**: 
* **Source Code**: HospitalDischargeReport.header.attester (A.1.6 - Attester [Required])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.attester.party
  * **Comment**: where attester.mode = 'professional'
* **Source Code**: HospitalDischargeReport.header.attester.identifier (A.1.6.1 - Attester identifier [Mandatory])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.attester.party.identifier
  * **Comment**: where attester.mode = 'professional' AND attester.party is of type PractictionerRole
* **Source Code**: HospitalDischargeReport.header.attester.name (A.1.6.2 - Attester name [Mandatory])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.attester.party.practitioner.name
  * **Comment**: where attester.mode = 'professional' AND attester.party is of type PractictionerRole
* **Source Code**: HospitalDischargeReport.header.attester.organizationID (A.1.6.3 - Attester organization ID [Required])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.attester.party.organization.name
  * **Comment**: where attester.mode = 'professional' AND attester.party is of type PractictionerRole
* **Source Code**: HospitalDischargeReport.header.attester.organization (A.1.6.4 - Attester organization [Mandatory])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.attester.party.organization.name
  * **Comment**: where attester.mode = 'professional' AND attester.party is of type PractictionerRole
* **Source Code**: HospitalDischargeReport.header.attester.dateTime (A.1.6.5 - Approval date and time [Mandatory])
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: Composition.attester.time
  * **Comment**: where attester.mode = 'professional'
* **Source Code**: HospitalDischargeReport.header.legalAuthenticator (A.1.7 - Legal authenticator [Required])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.attester.party
  * **Comment**: where attester.mode = 'legal'
* **Source Code**: HospitalDischargeReport.header.legalAuthenticator.identifier (A.1.7.1 - Legal authenticator identifier [Mandatory])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.attester.party.identifier
  * **Comment**: where attester.mode = 'legal' AND attester.party is of type PractictionerRole
* **Source Code**: HospitalDischargeReport.header.legalAuthenticator.name (A.1.7.2 - Legal authenticator name [Mandatory])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.attester.party.practitioner.name
  * **Comment**: where attester.mode = 'legal' AND attester.party is of type PractictionerRole
* **Source Code**: HospitalDischargeReport.header.legalAuthenticator.organizationID (A.1.7.2 - Legal authenticator organization ID [Required])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.attester.party.organization.name
  * **Comment**: where attester.mode = 'legal' AND attester.party is of type PractictionerRole
* **Source Code**: HospitalDischargeReport.header.legalAuthenticator.organization (A.1.7.3 - Legal authenticator organization [Mandatory])
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: Composition.attester.party.organization.name
  * **Comment**: where attester.mode = 'legal' AND attester.party is of type PractictionerRole
* **Source Code**: HospitalDischargeReport.header.legalAuthenticator.dateTime (A.1.7.4 - Authentication date and time [Mandatory])
  * **Relationship**: [is equal to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equal)
  * **Target Code**: Composition.attester.time
  * **Comment**: where attester.mode = 'legal'



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "ConceptMap-HeaderParticipants2FHIR-eu-xpandh",
  "url" : "http://hl7.eu/fhir/ig/xpandh/hdr/ConceptMap/ConceptMap-HeaderParticipants2FHIR-eu-xpandh",
  "version" : "0.1.0",
  "name" : "HeaderParticipants2FHIR",
  "title" : "eHN Recipient to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-10-10T16:32:47+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "eHN HDR Encounter Model to this guide mapping",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "purpose" : "Proposed relationship between the HDR Encounter data set defined by the EU eHN guidelines and this guide",
  "copyright" : "Used by permission of the XpanDH project, all rights reserved Creative Commons License",
  "sourceUri" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HospitalDischargeReport",
  "targetUri" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Composition-eu-xpandh",
  "group" : [
    {
      "source" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HospitalDischargeReport",
      "target" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Composition-eu-xpandh",
      "element" : [
        {
          "code" : "HospitalDischargeReport.header.payer",
          "display" : "A.1.3 - Health insurance and payment information [Required]",
          "target" : [
            {
              "code" : "Composition.extension:basedOn-order-or-requisition.insurance",
              "equivalence" : "relatedto",
              "comment" : "To be disucssed if the payor is conveyed with the request or thorugh other means"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.payer.insuranceCode",
          "display" : "A.1.3.1 - Health insurance code [Mandatory]",
          "target" : [
            {
              "code" : "Composition.extension:basedOn-order-or-requisition.insurance.payor.identifier",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.payer.insuranceName",
          "display" : "A.1.3.2 - Health insurance name [Required]",
          "target" : [
            {
              "code" : "Composition.extension:basedOn-order-or-requisition.insurance.payor.name",
              "equivalence" : "relatedto",
              "comment" : "with payor as Organization"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.payer.insuranceNumber",
          "display" : "A.1.3.3 - Health insurance number [Mandatory]",
          "target" : [
            {
              "code" : "Composition.extension:basedOn-order-or-requisition.insurance.beneficiary.identifier",
              "equivalence" : "relatedto",
              "comment" : "to be discussed"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.informationRecipient",
          "display" : "A.1.4 - Information recipient [Required]",
          "target" : [
            {
              "code" : "Composition.extension:information-recipient",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.informationRecipient.identifier",
          "display" : "A.1.4.1 - Recipient identifier [Required]",
          "target" : [
            {
              "code" : "Composition.extension:information-recipient.identifier",
              "equivalence" : "equivalent",
              "comment" : "If PractictionerRole"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.informationRecipient.name",
          "display" : "A.1.4.2 - Recipient name [Required]",
          "target" : [
            {
              "code" : "Composition.extension:information-recipient.practictioner.name",
              "equivalence" : "equivalent",
              "comment" : "If PractictionerRole"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.informationRecipient.organizationID",
          "display" : "A.1.4.3 - Recipient organization ID [Required]",
          "target" : [
            {
              "code" : "Composition.extension:information-recipient.organization.identifier",
              "equivalence" : "equivalent",
              "comment" : "If PractictionerRole"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.informationRecipient.organization",
          "display" : "A.1.4.4 - Recipient organization [Required]",
          "target" : [
            {
              "code" : "Composition.extension:information-recipient.organization",
              "equivalence" : "relatedto",
              "comment" : "If PractictionerRole"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.author",
          "display" : "A.1.5 - Author (by whom the Hospital discharge report was authored) [Mandatory]",
          "target" : [
            {
              "code" : "Composition.author",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.author.identifier",
          "display" : "A.1.5.1 - Author identifier [Mandatory]",
          "target" : [
            {
              "code" : "Composition.author.identifier",
              "equivalence" : "equivalent",
              "comment" : "If PractictionerRole"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.author.name",
          "display" : "A.1.5.2 - Author name [Mandatory]",
          "target" : [
            {
              "code" : "Composition.author.practictioner.name",
              "equivalence" : "equivalent",
              "comment" : "If PractictionerRole"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.author.organizationID",
          "display" : "A.1.5.3 - Author organization ID [Required]",
          "target" : [
            {
              "code" : "Composition.author.organization.identifier",
              "equivalence" : "equivalent",
              "comment" : "If PractictionerRole"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.author.organization",
          "display" : "A.1.5.4 - Author organization [Mandatory]",
          "target" : [
            {
              "code" : "Composition.author.organization",
              "equivalence" : "relatedto",
              "comment" : "If PractictionerRole"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.author.dateTime",
          "display" : "A.1.5.5 - DateTime [Mandatory]",
          "target" : [
            {
              "code" : "Composition.date",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.attester",
          "display" : "A.1.6 - Attester [Required]",
          "target" : [
            {
              "code" : "Composition.attester.party",
              "equivalence" : "equivalent",
              "comment" : "where attester.mode = 'professional'"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.attester.identifier",
          "display" : "A.1.6.1 - Attester identifier [Mandatory]",
          "target" : [
            {
              "code" : "Composition.attester.party.identifier",
              "equivalence" : "equivalent",
              "comment" : "where attester.mode = 'professional' AND attester.party is of type PractictionerRole"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.attester.name",
          "display" : "A.1.6.2 - Attester name [Mandatory]",
          "target" : [
            {
              "code" : "Composition.attester.party.practitioner.name",
              "equivalence" : "equivalent",
              "comment" : "where attester.mode = 'professional' AND attester.party is of type PractictionerRole"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.attester.organizationID",
          "display" : "A.1.6.3 - Attester organization ID [Required]",
          "target" : [
            {
              "code" : "Composition.attester.party.organization.name",
              "equivalence" : "equivalent",
              "comment" : "where attester.mode = 'professional' AND attester.party is of type PractictionerRole"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.attester.organization",
          "display" : "A.1.6.4 - Attester organization [Mandatory]",
          "target" : [
            {
              "code" : "Composition.attester.party.organization.name",
              "equivalence" : "equivalent",
              "comment" : "where attester.mode = 'professional' AND attester.party is of type PractictionerRole"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.attester.dateTime",
          "display" : "A.1.6.5 - Approval date and time [Mandatory]",
          "target" : [
            {
              "code" : "Composition.attester.time",
              "equivalence" : "equal",
              "comment" : "where attester.mode = 'professional'"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.legalAuthenticator",
          "display" : "A.1.7 - Legal authenticator [Required]",
          "target" : [
            {
              "code" : "Composition.attester.party",
              "equivalence" : "equivalent",
              "comment" : "where attester.mode = 'legal'"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.legalAuthenticator.identifier",
          "display" : "A.1.7.1 - Legal authenticator identifier [Mandatory]",
          "target" : [
            {
              "code" : "Composition.attester.party.identifier",
              "equivalence" : "equivalent",
              "comment" : "where attester.mode = 'legal' AND attester.party is of type PractictionerRole"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.legalAuthenticator.name",
          "display" : "A.1.7.2 - Legal authenticator name [Mandatory]",
          "target" : [
            {
              "code" : "Composition.attester.party.practitioner.name",
              "equivalence" : "equivalent",
              "comment" : "where attester.mode = 'legal' AND attester.party is of type PractictionerRole"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.legalAuthenticator.organizationID",
          "display" : "A.1.7.2 - Legal authenticator organization ID [Required]",
          "target" : [
            {
              "code" : "Composition.attester.party.organization.name",
              "equivalence" : "equivalent",
              "comment" : "where attester.mode = 'legal' AND attester.party is of type PractictionerRole"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.legalAuthenticator.organization",
          "display" : "A.1.7.3 - Legal authenticator organization [Mandatory]",
          "target" : [
            {
              "code" : "Composition.attester.party.organization.name",
              "equivalence" : "equivalent",
              "comment" : "where attester.mode = 'legal' AND attester.party is of type PractictionerRole"
            }
          ]
        },
        {
          "code" : "HospitalDischargeReport.header.legalAuthenticator.dateTime",
          "display" : "A.1.7.4 - Authentication date and time [Mandatory]",
          "target" : [
            {
              "code" : "Composition.attester.time",
              "equivalence" : "equal",
              "comment" : "where attester.mode = 'legal'"
            }
          ]
        }
      ]
    }
  ]
}

```
