# Home - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/hdr/ImplementationGuide/hl7.eu.fhir.xpandh.hdr | *Version*:0.1.0 |
| Draft as of 2025-10-10 | *Computable Name*:XpandhHospitalDischargeReportIg |
| **Copyright/Legal**: Used by permission of the XpanDH project, all rights reserved Creative Commons License | |

> The specification herewith documented is for the time being a working specification, and may not be used for any implementation purposes. No liability can be inferred from the use or misuse of this specification, or its consequences.

### Scope

 This is the Hospital Dischareg Report HL7 FHIR Implementation Guide for the XpanDH project, created to assist the work of the pilots for the [XpanDH exprimentation bubbles](#adoption-domains). 

> This guide is kept only for documentation purposes, representing an official deliverable of the XpanDH project.**This guide is not intended to replace or override any other Implementation Guide specified by Standard Development Organizations, MyHealth@Eu and/or JA-09.**Please refer to the**the[HL7 Europe Hospital Discharge Report FHIR IG](https://hl7.eu/fhir/hdr/)**for the specifications related to this domain

### The project

#### The mission

Help individuals and organizations successfully adopt the European Electronic Health Record Exchange Format (EEHRxF) in a way that is empowering and supportive.

#### How to:

Mobilizing and building capacity to ensure the widespread adoption of the European Electronic Health Records Exchange Format (EEHRxF) across Europe. 

More details in [XpanDH Web Site](https://xpandh-project.iscte-iul.pt/) 

### XpanDH Adoption Domains/X-Bubbles

#### What is:

An EEHRxF adoption domain could be considered as an instantiation of a use case, with a specific case application, that has meaning from a health system or clinical perspective, with defined implementable requirements (simple if only one EEHRxF priority category is uses or composite if data from more than one is required), that satisfies all the conditions for users to be ready to implement data exchange in conformity to EEHRxF guidelines and specifications 

XpanDH will exercise a set of adoption domains, involving Hospitals, Regional/National organziation, vendors,.., thorugh experimentaion bubbles (in the Hpandh jargon called X-Bubbles)

#### Adoption domains / X-Bubbles covered by this guide:

* X-Bubble 3: NCZI; organisation to organisation (national). Exchange of discharge reports between different organisations, such as a hospital and a GP or between a hospital local to the patient and a specialist centre treating a disease such as a cancer, in order to enable each clinical actor to be well informed and contribute accurately to the same patient care pathway.
* X-Bubble 4: CHUP; organisation to patient (national. Communicate discharge reports from a hospital to the patient (within the same country) so that they can be informed, raise questions if needed, share this information with other caregivers and take any self-care actions indicated in the report.
* X-Bubble 5: KETEKNY; organisation to national authority.Communicate discharge reports from a hospital to a national authority to support reimbursement decisions or to contribute content to a national registry.
* X-Bubble 6: KETEKNY; national authority to organisation. The national authority communicates discharge reports to a hospital treating a patient, that it has previously received from other hospitals treating that patient, to enable a smooth transfer and continuity of care (e.g. if a patient moves home).

More details on X-Bubbles and Adoption Doamin in XpanDH deliverable D1.4 and D4.1 [XpanDH Web Site](https://xpandh-project.iscte-iul.pt/) 

### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.eu.fhir.xpandh.hdr.r4)](package.r4.tgz) and [R4B (hl7.eu.fhir.xpandh.hdr.r4b)](package.r4b.tgz) are available.

### Global Profiles

*There are no Global profiles defined*

### IP Statements

This publication includes IP covered under the following statements.

* Copyright HL7. Licensed under creative commons public domain

* [contactRole2](http://terminology.hl7.org/5.3.0/CodeSystem-v2-0131.html): [Patient/Mracena](Patient-Mracena.md)


* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.5.0/CodeSystem-ISO3166Part1.html): [TravelHistoryXpandh](StructureDefinition-travel-history-xpandh.md)


* Produced by HL7 under the terms of HL7® Governance and Operations Manual relating to Intellectual Property (Section 16), specifically its copyright, trademark and patent provisions. This document is licensed under Creative Commons "No Rights Reserved" (CC0).

* [Absent and Unknown Data - IPS](http://hl7.org/fhir/uv/ips/STU1.1/CodeSystem-absent-unknown-uv-ips.html): [HdrConditionMandatoryXpandhVS](ValueSet-hdr-condition-mandatory-xpandh-vs.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ucum.html): [BMIObservationUnitVS](ValueSet-bmi-observation-unit-vs.md), [BMIProfileXpandh](StructureDefinition-bmi-xpandh.md)...Show 4 more,[BodyWeightUnitsVS](ValueSet-body-weight-units-vs.md),[ObservationVitalSignsXpandh](StructureDefinition-observation-vital-signs-xpandh.md),[SkinfoldThicknessUnitsVS](ValueSet-skinfold-thickness-units-vs.md)and[SkinfoldThicknessXpandh](StructureDefinition-skinfold-thickness-xpandh.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.5.0/CodeSystem-v3-loinc.html): [AssessmentObservationXpandh](StructureDefinition-assessment-observation-xpandh.md), [CompositionHdrXpandh](StructureDefinition-Composition-hdr-eu-xpandh.md)...Show 7 more,[ObservationCodesDistantMetastasesVS](ValueSet-mcode-observation-codes-distant-metastases-vs.md),[ObservationCodesPrimaryTumorVS](ValueSet-mcode-observation-codes-primary-tumor-vs.md),[ObservationCodesRegionalNodesVS](ValueSet-mcode-observation-codes-regional-nodes-vs.md),[ObservationVitalSignsXpandh](StructureDefinition-observation-vital-signs-xpandh.md),[TNMDistantMetastasesCategory](StructureDefinition-mcode-tnm-distant-metastases-category.md),[TNMPrimaryTumorCategory](StructureDefinition-mcode-tnm-primary-tumor-category.md)and[TNMRegionalNodesCategory](StructureDefinition-mcode-tnm-regional-nodes-category.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://hl7.org/fhir/R4/codesystem-snomedct.html): [AdmissionVoluntaryStatusVS](ValueSet-admission-voluntary-status-vs.md), [AllVitalSignsObservationVS](ValueSet-vital-signs-observation-vs.md)...Show 48 more,[AllergyIntoleranceSubstancesXpandhVS](ValueSet-allergy-intolerance-substances-xpandh-vs.md),[AnthropometricObservationVS](ValueSet-anthropometric-observation-vs.md),[BMIObservationVS](ValueSet-bmi-observation-vs.md),[BMIProfileXpandh](StructureDefinition-bmi-xpandh.md),[BloodPressureXpandh](StructureDefinition-blood-pressure-xpandh.md),[BodyHeightObservationVS](ValueSet-body-height-observation-vs.md),[BodyHeightXpandh](StructureDefinition-body-height-xpandh.md),[BodyTemperatureXpandh](StructureDefinition-body-temperature-xpandh.md),[BodyWeightObservationVS](ValueSet-body-weight-observation-vs.md),[BodyWeightXpandh](StructureDefinition-body-weight-xpandh.md),[CancerStageGradingVS](ValueSet-cancer-stage-grading-vs.md),[CancerStageGroupHdrXpandh](StructureDefinition-cancer-stage-group-hdr-xpandh.md),[CancerStageGroupVS](ValueSet-cancer-stageGroup-vs.md),[CircumferenceMeasurementXpandh](StructureDefinition-circumference-measurement-xpandh.md),[CircumferenceObservationVS](ValueSet-circumference-observation-vs.md),[CompositionHdrXpandh](StructureDefinition-Composition-hdr-eu-xpandh.md),[ConditionEncounterHdrXpandh](StructureDefinition-condition-encounter-hdr-xpandh.md),[ConditionHdrXpandh](StructureDefinition-condition-hdr-xpandh.md),[EncounterVoluntaryStatus](StructureDefinition-encounter-voluntary-status.md),[ExposureAgentXpandhVS](ValueSet-exposure-agent-xpandh-vs.md),[FunctionalAssessmentScalesVS](ValueSet-functional-assessment-scales-vs.md),[FunctionalStatusAssessmentXpandh](StructureDefinition-functional-status-assessment-xpandh.md),[HdrConditionMandatoryXpandhVS](ValueSet-hdr-condition-mandatory-xpandh-vs.md),[HdrConditionXpandhVS](ValueSet-hdr-condition-xpandh-vs.md),[HdrEncounterTypeXpandhVS](ValueSet-hdr-encounter-type-xpandh-vs.md),[HdrTreatedXpandhVS](ValueSet-hdr-treated-xpandh-vs.md),[HeartRateXpandh](StructureDefinition-heart-rate-xpandh.md),[ImmunicationTargetVS](ValueSet-immunization-target-vs.md),[Immunization/example-it-1-1](Immunization-example-it-1-1.md),[Immunization/example-it-1-2](Immunization-example-it-1-2.md),[ImmunizationXpandh](StructureDefinition-immunization-xpandh.md),[InfectiousContactXpandh](StructureDefinition-infectious-contact-xpandh.md),[InpatientEncounterHDRXpandh](StructureDefinition-inpatient-encounter-hdr-xpandh.md),[MedicalDevicesSnomedCtXpandhVS](ValueSet-medical-devices-xpandh-vs.md),[ObservationVitalSignsXpandh](StructureDefinition-observation-vital-signs-xpandh.md),[OxygenSaturationXpandh](StructureDefinition-oxygen-saturation-xpandh.md),[PediatricHeadOccipitalFrontalCircumferencePercentileXpandh](StructureDefinition-pediatric-head-occ-front-circumfer-percent-xpandh.md),[ProcedureSnomedXpandhVS](ValueSet-procedure-snomed-xpandh-vs.md),[RespiratoryRateXpandh](StructureDefinition-respiratory-rate-xpandh.md),[SkinfoldThicknessVS](ValueSet-skinfold-thickness-vs.md),[SkinfoldThicknessXpandh](StructureDefinition-skinfold-thickness-xpandh.md),[TNM_M_ClinicalCategoryVS](ValueSet-TNM-M-clinical-category-vs.md),[TNM_M_PathologicalCategoryVS](ValueSet-TNM-M-pathologycal-category-vs.md),[TNM_N_ClinicalCategoryVS](ValueSet-TNM-N-clinical-category-vs.md),[TNM_N_PathologicalCategoryVS](ValueSet-TNM-N-pathological-category-vs.md),[TNM_T_ClinicalCategoryVS](ValueSet-TNM-T-clinical-category-vs.md),[TNM_T_PathologicalCategoryVS](ValueSet-TNM-T-pathological-category-vs.md)and[TravelHistoryXpandh](StructureDefinition-travel-history-xpandh.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Admit source](http://terminology.hl7.org/6.5.0/CodeSystem-admit-source.html): [Encounter/SK-Hospital-Encounter](Encounter-SK-Hospital-Encounter.md)
* [Condition Category Codes](http://terminology.hl7.org/6.5.0/CodeSystem-condition-category.html): [ConditionEncounterHdrXpandh](StructureDefinition-condition-encounter-hdr-xpandh.md) and [ConditionProblemsHdrXpandh](StructureDefinition-condition-problems-hdr-xpandh.md)
* [Condition Clinical Status Codes](http://terminology.hl7.org/6.5.0/CodeSystem-condition-clinical.html): [ConditionHdrXpandh](StructureDefinition-condition-hdr-xpandh.md)
* [ConditionVerificationStatus](http://terminology.hl7.org/6.5.0/CodeSystem-condition-ver-status.html): [ConditionHdrXpandh](StructureDefinition-condition-hdr-xpandh.md)
* [Observation Category Codes](http://terminology.hl7.org/6.5.0/CodeSystem-observation-category.html): [BMIProfileXpandh](StructureDefinition-bmi-xpandh.md), [BloodPressureXpandh](StructureDefinition-blood-pressure-xpandh.md)...Show 13 more,[BodyHeightXpandh](StructureDefinition-body-height-xpandh.md),[BodyTemperatureXpandh](StructureDefinition-body-temperature-xpandh.md),[BodyWeightXpandh](StructureDefinition-body-weight-xpandh.md),[CircumferenceMeasurementXpandh](StructureDefinition-circumference-measurement-xpandh.md),[HeartRateXpandh](StructureDefinition-heart-rate-xpandh.md),[ObservationResultsPathologyXpandh](StructureDefinition-Observation-results-pathology-eu-xpandh.md),[ObservationResultsRadiologyXpandh](StructureDefinition-Observation-results-radiology-eu-xpandh.md),[ObservationVitalSignsXpandh](StructureDefinition-observation-vital-signs-xpandh.md),[OxygenSaturationXpandh](StructureDefinition-oxygen-saturation-xpandh.md),[PediatricHeadOccipitalFrontalCircumferencePercentileXpandh](StructureDefinition-pediatric-head-occ-front-circumfer-percent-xpandh.md),[RespiratoryRateXpandh](StructureDefinition-respiratory-rate-xpandh.md),[SkinfoldThicknessXpandh](StructureDefinition-skinfold-thickness-xpandh.md)and[SocialHistoryXpandh](StructureDefinition-social-history-xpandh.md)
* [Organization type](http://terminology.hl7.org/6.5.0/CodeSystem-organization-type.html): [MUDr. Pes Filipes, praktický lékař](Organization-SK-Organization-GP.md), [Mestská Nemocnica Kubín](Organization-SK-Organization-Hospital.md) and [Nemocnica - oddělení chirurgie](Organization-SK-Organization-Hospital-Department-1.md)
* [ActClass](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActClass.html): [InfectiousContactXpandh](StructureDefinition-infectious-contact-xpandh.md)
* [ActCode](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActCode.html): [Encounter/SK-Hospital-Encounter](Encounter-SK-Hospital-Encounter.md), [HdrEncounterClassXpandhVS](ValueSet-hdr-encounterClass-xpandh-vs.md) and [InpatientEncounterHDRXpandh](StructureDefinition-inpatient-encounter-hdr-xpandh.md)
* [ActPriority](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActPriority.html): [Encounter/SK-Hospital-Encounter](Encounter-SK-Hospital-Encounter.md), [HdrAdmissionUrgencyXpandhVS](ValueSet-hdr-admission-urgency-xpandh-vs.md) and [InpatientEncounterHDRXpandh](StructureDefinition-inpatient-encounter-hdr-xpandh.md)
* [ParticipationType](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ParticipationType.html): [InfectiousContactXpandh](StructureDefinition-infectious-contact-xpandh.md) and [InpatientEncounterHDRXpandh](StructureDefinition-inpatient-encounter-hdr-xpandh.md)
* [RoleCode](http://terminology.hl7.org/6.5.0/CodeSystem-v3-RoleCode.html): [Patient/Mracena](Patient-Mracena.md)


* Used by permission of the XpanDH project, all rights reserved Creative Commons License

* [Xpandh Assessment Category](CodeSystem-assessment-category-xpandh-cs.md): [AssessmentObservationCategoryVS](ValueSet-assessment-observation-category-vs.md), [AssessmentObservationXpandh](StructureDefinition-assessment-observation-xpandh.md), [FunctionalStatusAssessmentXpandh](StructureDefinition-functional-status-assessment-xpandh.md) and [WHODASAssessmentXpandh](StructureDefinition-whodas-assessment-xpandh.md)
* [Present on Admission (POA) Indicator](CodeSystem-poa-indicator-xpandh-cs.md): [ConditionEncounterHdrXpandh](StructureDefinition-condition-encounter-hdr-xpandh.md) and [HdrPOAIndicatorXpandhVS](ValueSet-hdr-poa-indicator-xpandh-vs.md)




## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "hl7.eu.fhir.xpandh.hdr",
  "url" : "http://hl7.eu/fhir/ig/xpandh/hdr/ImplementationGuide/hl7.eu.fhir.xpandh.hdr",
  "version" : "0.1.0",
  "name" : "XpandhHospitalDischargeReportIg",
  "title" : "XpanDH Hospital Discharge Report",
  "status" : "draft",
  "date" : "2025-10-10T16:32:47+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "This guide describes how the Hospital Discharge Report can be represented for the purpose of the XpanDH project experimantions.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of the XpanDH project, all rights reserved Creative Commons License",
  "packageId" : "hl7.eu.fhir.xpandh.hdr",
  "license" : "CC0-1.0",
  "fhirVersion" : ["4.0.1"],
  "dependsOn" : [
    {
      "id" : "hl7tx",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on HL7 Terminology"
        }
      ],
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r4",
      "version" : "6.5.0"
    },
    {
      "id" : "hl7ext",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on the HL7 Extension Pack"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r4",
      "version" : "5.2.0"
    },
    {
      "id" : "hl7_fhir_eu_laboratory",
      "uri" : "http://hl7.eu/fhir/laboratory/ImplementationGuide/hl7.fhir.eu.laboratory",
      "packageId" : "hl7.fhir.eu.laboratory",
      "version" : "0.1.0"
    },
    {
      "id" : "hl7_fhir_uv_ips",
      "uri" : "http://hl7.org/fhir/uv/ips/ImplementationGuide/hl7.fhir.uv.ips",
      "packageId" : "hl7.fhir.uv.ips",
      "version" : "1.1.0"
    },
    {
      "id" : "hl7_eu_fhir_xpandh",
      "uri" : "http://hl7.eu/fhir/ig/xpandh/ImplementationGuide/hl7.eu.fhir.xpandh",
      "packageId" : "hl7.eu.fhir.xpandh",
      "version" : "dev"
    },
    {
      "id" : "hl7_fhir_eu_extensions",
      "uri" : "http://hl7.eu/fhir/extensions/ImplementationGuide/hl7.fhir.eu.extensions",
      "packageId" : "hl7.fhir.eu.extensions",
      "version" : "0.1.0"
    },
    {
      "id" : "hl7_fhir_us_mcode",
      "uri" : "http://hl7.org/fhir/us/mcode/ImplementationGuide/hl7.fhir.us.mcode",
      "packageId" : "hl7.fhir.us.mcode",
      "version" : "current"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2023+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "ci-build"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "show-inherited-invariants"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "usage-stats-opt-out"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.eu/fhir/ig/xpandh/hdr/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r4#0.8.0"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2023+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "ci-build"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "show-inherited-invariants"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "usage-stats-opt-out"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.eu/fhir/ig/xpandh/hdr/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      }
    ],
    "grouping" : [
      {
        "id" : "eHNGuidelines",
        "name" : "eHN HDR Guidelines",
        "description" : "Logical models representing the eHN HDR Guidelines"
      },
      {
        "id" : "Slovakia",
        "name" : "Slovakia HDR",
        "description" : "Logical models representing the Slovakia Data set"
      },
      {
        "id" : "logicalModelsMaps",
        "name" : "Logical Model mappings",
        "description" : "Concept Maps describing how the eHN Guidelines are supposed to be implemented by using this guide"
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/HospitalDischargeReport"
        },
        "name" : "A - Hospital Discharge Report (eHN)",
        "description" : "Hospital Discharge Report\nMaturity Level: 0 Draft",
        "exampleBoolean" : false,
        "groupingId" : "eHNGuidelines"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/HDRAdvanceDirectives"
        },
        "name" : "A.2.1 - Advance Directives (eHN)",
        "description" : "Hospital Discharge Report - Advance Directives - A.2.1 eHN\nMaturity Level: 0 Draft",
        "exampleBoolean" : false,
        "groupingId" : "eHNGuidelines"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/HDRAlerts"
        },
        "name" : "A.2.2 - Alerts (eHN)",
        "description" : "Hospital Discharge Report - Alerts - A.2.2 eHN\nMaturity Level: 0 Draft",
        "exampleBoolean" : false,
        "groupingId" : "eHNGuidelines"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/HDREncounter"
        },
        "name" : "A.2.3 - Encounter (eHN)",
        "description" : "Hospital Discharge Report - Encounter - A.2.3 eHN\nMaturity Level: 0 Draft",
        "exampleBoolean" : false,
        "groupingId" : "eHNGuidelines"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/HDRAdmissionEvaluation"
        },
        "name" : "A.2.4 - Admission evaluation (eHN)",
        "description" : "Hospital Discharge Report - Admission evaluation - A.2.4 eHN\nMaturity Level: 0 Draft",
        "exampleBoolean" : false,
        "groupingId" : "eHNGuidelines"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/HDRPatientHistory"
        },
        "name" : "A.2.6 - Patient history (eHN)",
        "description" : "Hospital Discharge Report - Patient history - A.2.6 eHN\nMaturity Level: 0 Draft",
        "exampleBoolean" : false,
        "groupingId" : "eHNGuidelines"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/HDRHospitalStay"
        },
        "name" : "A.2.7 - Hospital stay (eHN)",
        "description" : "Hospital Discharge Report - Hospital stay - A.2.7 eHN\nMaturity Level: 0 Draft",
        "exampleBoolean" : false,
        "groupingId" : "eHNGuidelines"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/HDRDischargeDetails"
        },
        "name" : "A.2.8 - Discharge details (eHN)",
        "description" : "Hospital Discharge Report - Discharge details - A.2.8 eHN\nMaturity Level: 0 Draft",
        "exampleBoolean" : false,
        "groupingId" : "eHNGuidelines"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/HDRRecommendations"
        },
        "name" : "A.2.9 - Care plan and other recommendations after discharge (eHN)",
        "description" : "Hospital Discharge Report - Care plan and other recommendations after discharge - A.2.9 eHN\nMaturity Level: 0 Draft",
        "exampleBoolean" : false,
        "groupingId" : "eHNGuidelines"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hdr-admission-urgency-xpandh-vs"
        },
        "name" : "Admission Urgency Value Set",
        "description" : "Hospital Discharge Report Admission Urgency value set includes selected codes from HL7 v3-ActPriority code system.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/allergy-intolerance-xpandh-vs"
        },
        "name" : "Allergy Intolerance - Xpandh",
        "description" : "Xpandh allergy intolerance codes value set. This value set includes codes from SNOMED Clinical Terms®: all descendants of 373873005 \\|Pharmaceutical / biologic product (product)\\|; all descendants of 105590001 \\|Substance (substance)\\|; all descendants of 418038007 \\|Propensity to adverse reactions to substance (finding)\\| plus codes for absent and unknown allergies.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/allergy-intolerance-substances-xpandh-vs"
        },
        "name" : "Allergy Intolerance Substances - Xpandh",
        "description" : "Xpandh allergy intolerance codes value set. This value set includes codes from SNOMED Clinical Terms®: all descendants of 373873005 \\|Pharmaceutical / biologic product (product)\\|; all descendants of 105590001 \\|Substance (substance)\\|; all descendants of 418038007 \\|Propensity to adverse reactions to substance (finding)\\|.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/anthropometric-observation-vs"
        },
        "name" : "Anthropometric Observation Value Set",
        "description" : "Anthropometric observation codes from the XpanDH anthropometric observations.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/bmi-observation-unit-vs"
        },
        "name" : "BMI Observation Unit Value Set",
        "description" : "Body mass index observation units for the XpanDH BMI observations.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/bmi-observation-vs"
        },
        "name" : "BMI Observation Value Set",
        "description" : "Body mass index observation codes from the XpanDH BMI observation.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/body-height-observation-vs"
        },
        "name" : "Body Height Observation Value Set",
        "description" : "Body height observation codes from the XpanDH body height observations.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/body-weight-observation-vs"
        },
        "name" : "Body Weight Observation Value Set",
        "description" : "Body weight observation codes from the XpanDH body weight observations.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/body-weight-units-vs"
        },
        "name" : "Body Weight Observation Value Set",
        "description" : "Body weight observation codes from the XpanDH body weight observations.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Bundle-hdr-xpandh"
        },
        "name" : "Bundle: EU Hospital Discharge Report",
        "description" : "Clinical document used to represent a Hospital Discharge Report for the scope of the XpanDH project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cancer-stage-grading-vs"
        },
        "name" : "Cancer Stage Grading: Snomed CT",
        "description" : "Identifying codes based on the timing of classification for stage group observations.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cancer-stageGroup-vs"
        },
        "name" : "Cancer Stage Group: SNOMED CT",
        "description" : "Identifying codes based on the timing of classification for stage group observations.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/CareTeam-eu-xpandh"
        },
        "name" : "CareTeam",
        "description" : "This profile constrains the CareTeam resource for the purpose of the XpanDH project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/circumference-observation-vs"
        },
        "name" : "Circumference Observation Value Set",
        "description" : "Circumference observation codes from the XpanDH Circumference observations.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/TNM-M-clinical-category-vs"
        },
        "name" : "Clinical M",
        "description" : "Distant metastazis (M) clinical category",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/TNM-N-clinical-category-vs"
        },
        "name" : "Clinical N",
        "description" : "Regional lymph nodes (N) clinical category",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/TNM-T-clinical-category-vs"
        },
        "name" : "Clinical T",
        "description" : "Primary tumor (T) clinical category",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Composition-hdr-eu-xpandh"
        },
        "name" : "Composition: Hospital Discharge Report",
        "description" : "Clinical document used to represent a Hospital Discharge Report (HDR) for the scope of the XpanDH project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hdr-poa-indicator-xpandh-vs"
        },
        "name" : "Condition Present on Admission (POA) Value Set",
        "description" : "Hospital Discharge Report Condition Present on Admission value set includes codes from Present on Admission code system.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hdr-condition-xpandh-vs"
        },
        "name" : "Condition Value Set",
        "description" : "Hospital Discharge Report Condition value set includes selected codes from recommended EU code systems for health conditions (WHO-ICD-10, SNOMED CT and Orphacodes).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/condition-encounter-hdr-xpandh"
        },
        "name" : "Condition Xpandh Hospital Dischage Encounter",
        "description" : "This profile represents the constraint applied to the Condition in the scope of Xpandh hospital discharge encounter resource. Encounter conditions implements Diagnostic summary part of the eHN data model adding two additional categories: First category distingueshes conditions present at admission and acquired during hospital stay (POA, HAC, NA - Not applicable or unknown) while second category is used to indicate impact of the condition to the treatement during hospital stay (treated, untreated).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/condition-hdr-xpandh"
        },
        "name" : "Condition Xpandh Profile",
        "description" : "This profile represents the constraint applied to the Condition in the scope of Xpandh hospital discharge report.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/coverage-hdr-eu-xpandh"
        },
        "name" : "Coverage: Encounter Payer",
        "description" : "Coverage used to represent the payer for this Encounter for the scope of the XpanDH project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/device-xpandh"
        },
        "name" : "Device (Xpandh)",
        "description" : "This profile represents the constraints applied to the Device resource by the Xpandh FHIR Implementation Guide, based on FHIR R4. A device used by or implanted on the patient is described in the hospital discharge report as an instance of a Device resource constrained by this profile.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/ConceptMap-HeaderMeta2FHIR-eu-xpandh"
        },
        "name" : "eHN HDR header metadata to this guide Map",
        "description" : "eHN eHN HDR header metadata Model to this guide mapping",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/ConceptMap-HeaderParticipants2FHIR-eu-xpandh"
        },
        "name" : "eHN Recipient to this guide Map",
        "description" : "eHN HDR Encounter Model to this guide mapping",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/ConceptMap-hdrHeader2FHIR-eu-xpandh"
        },
        "name" : "eHN Recipient to this guide Map",
        "description" : "eHN HDR Encounter Model to this guide mapping",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hdr-encounterClass-xpandh-vs"
        },
        "name" : "Encounter Class Value Set",
        "description" : "Hospital Discharge Report Encounter Class specifies a general class of inpatient encounter as being accute, nonaccute, emergency, short stay ...",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/ConceptMap-hdrEncounter2FHIR-eu-xpandh"
        },
        "name" : "Encounter to this guide",
        "description" : "Proposed relationship between the HDR Encounter data set defined by the EU eHN guidelines and this guide",
        "exampleBoolean" : false,
        "groupingId" : "logicalModelsMaps"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/encounter-voluntary-status"
        },
        "name" : "Encounter Voluntary Status",
        "description" : "This extension provides information about voluntary or involuntary nature of the encounter.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/admission-voluntary-status-vs"
        },
        "name" : "Encounter Voluntary Status Value Set",
        "description" : "Value set of voluntary nature of the encounter.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/example-it-1"
        },
        "name" : "example-it-1",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Immunization"
          }
        ],
        "reference" : {
          "reference" : "Immunization/example-it-1-1"
        },
        "name" : "example-it-1-1",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Immunization"
          }
        ],
        "reference" : {
          "reference" : "Immunization/example-it-1-2"
        },
        "name" : "example-it-1-2",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/exposure-agent-xpandh-vs"
        },
        "name" : "Exposure of transmissible agents - Xpandh",
        "description" : "Xpandh exposure agent value set. This value set includes codes from SNOMED Clinical Terms®: all descendants of 40733004 \"Infectious disease (disorder)\" and ICD-10 all descendants of chapter I: \"Certain infectious and parasitic diseases\"",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Flag-eu-xpandh"
        },
        "name" : "Flag",
        "description" : "This profile constrains the Flag resource to represent alerts or warnings in FHIR for the purpose of the XpanDH project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/HospitalDischargeReportSK"
        },
        "name" : "Hospital Discharge Report (SK)",
        "description" : "Hospital Discharge Report SK\nMaturity Level: 0 Draft",
        "exampleBoolean" : false,
        "groupingId" : "Slovakia"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/encounter-status-vs-eu-hdr"
        },
        "name" : "In-patient Encounter Type Value Set",
        "description" : "Hospital Discharge Report Encounter Type allows to classify encounter using general type of care provision regimen during the inpatient encounter. Value set includes concepts from the SNOMED CT descendants of 225351009 (Care provision regime) but needs to be further dicsussed",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hdr-encounter-type-xpandh-vs"
        },
        "name" : "In-patient Encounter Type Value Set",
        "description" : "Hospital Discharge Report Encounter Type allows to classify encounter using general type of care provision regimen during the inpatient encounter. Value set includes concepts from the SNOMED CT descendants of 225351009 (Care provision regime) but needs to be further dicsussed",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/inpatient-encounter-hdr-xpandh"
        },
        "name" : "Inpatient Encounter Xpandh",
        "description" : "This profile defines how to represent Inpatient Encounter in FHIR for the purpose of the XpanDH Hospital Discharge Report.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hdr-condition-mandatory-xpandh-vs"
        },
        "name" : "Mandatory Condition Value Set",
        "description" : "Hospital Discharge Report Mandatory Condition value set includes selected codes from recommended EU code systems for health conditions (WHO-ICD-10, SNOMED CT and Orphacodes) and IPS Absent and Unknown Data.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/medical-devices-xpandh-vs"
        },
        "name" : "Medical Devices (SNOMED CT) - Xpandh",
        "description" : "This value set includes codes from SNOMED Clinical Terms®: all descendants of 49062001 \\|Device (physical object)\\|.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/medical-devices-snomed-absent-unknown-xpandh-vs"
        },
        "name" : "Medical Devices - SNOMED CT + Absent/Unknown - IPS",
        "description" : "This value set includes codes from SNOMED Clinical Terms (SNOMED CT®) that are included in: all descendants of 49062001 \\|Device (physical object)\\|, plus IPS codes for absent/unknown devices.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/medication-xpandh"
        },
        "name" : "Medication (Xpandh)",
        "description" : "This profile represents the constraints applied to the Medication resource by the Xpandh project FHIR Implementation Guide, based on FHIR R4.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/MedicationDispense-hdr-eu-xpandh"
        },
        "name" : "MedicationDispense Xpandh",
        "description" : "This profile constrains the MedicationDispense FHIR profile for the purpose of the XpanDH project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/MedicationRequest-eu-xpandh"
        },
        "name" : "MedicationRequest",
        "description" : "This profile constrains the MedicationRequest IPS FHIR profile for the purpose of the XpanDH project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/medication-snomed-absent-unknown-uv-ips"
        },
        "name" : "Medications - SNOMED CT + Absent/Unknown (IPS)",
        "description" : "This value set includes the codes from SNOMED CT that are included in: descendants of 373873005 \\|Pharmaceutical / biologic product (product)\\|, excluding the descendants of 787859002 \\|Vaccine product (medicinal product)\\|, plus IPS codes for absent/unknown medications.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/MedicationStatement-eu-xpandh"
        },
        "name" : "MedicationStatement",
        "description" : "This profile constrains the MedicationStatement IPS FHIR profile for the purpose of the XpanDH project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/Mracena"
        },
        "name" : "Mracena",
        "description" : "Example of Slovak patient",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Patient-eu-xpandh"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/mcode-observation-codes-distant-metastases-vs"
        },
        "name" : "Observation Codes for Distant Metastases Category",
        "description" : "Identifying codes based on the timing of classification for distant metastases (M) staging observations.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/mcode-observation-codes-primary-tumor-vs"
        },
        "name" : "Observation Codes for Primary Tumor Category",
        "description" : "Identifying codes based on the timing of classification for primary tumor (T) staging observations.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/mcode-observation-codes-regional-nodes-vs"
        },
        "name" : "Observation Codes for Regional Node Category",
        "description" : "Identifying codes based on the timing of classification for regional node (N) staging observations.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Observation-results-xpandh"
        },
        "name" : "Observation Results",
        "description" : "This profile constrains the Observation resource to represent various types of results and associated observations in a HDR. This is the base profile from which the other results profiles are derived.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Observation-results-pathology-eu-xpandh"
        },
        "name" : "Observation Results: pathology",
        "description" : "This profile constrains the Observation resource to represent results produced by pathology studies for the XpanDH project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Observation-results-radiology-eu-xpandh"
        },
        "name" : "Observation Results: radiology",
        "description" : "This profile constrains the Observation resource to represent results produced by pathology studies for the XpanDH project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cancer-stage-group-hdr-xpandh"
        },
        "name" : "Observation: Cancer Stage Group",
        "description" : "The extent of the cancer in the body, according to a given cancer staging classification system, based on evidence such as physical examination, imaging, and/or biopsy or based on pathologic analysis of a specimen.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/mcode-tnm-distant-metastases-category"
        },
        "name" : "Observation: TNM Distant Metastases Category",
        "description" : "Category describing the extent of a tumor metastasis in remote anatomical locations, based on evidence such as physical examination, imaging, and/or biopsy.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/mcode-tnm-primary-tumor-category"
        },
        "name" : "Observation: TNM Primary Tumor Category",
        "description" : "Category of the primary tumor, based on its size and extent, based on evidence such as physical examination, imaging, and/or biopsy.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/mcode-tnm-regional-nodes-category"
        },
        "name" : "Observation: TNM Regional Nodes Category",
        "description" : "Category of the presence or absence of metastases in regional lymph nodes, based on evidence such as physical examination, imaging, and/or biopsy.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/org-example-it"
        },
        "name" : "org-example-it",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/TNM-M-pathologycal-category-vs"
        },
        "name" : "Pathological M",
        "description" : "Distant metastazis (M) pathological category",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/TNM-N-pathological-category-vs"
        },
        "name" : "Pathological N",
        "description" : "Regional lymph nodes (N) pathological category",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/TNM-T-pathological-category-vs"
        },
        "name" : "Pathological T",
        "description" : "Primary tumor (T) pathological category",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Patient-eu-xpandh"
        },
        "name" : "Patient: HDR",
        "description" : "This profile defines how to represent Patient in FHIR for the purpose of the XpanDH project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Practitioner-eu-xpandh"
        },
        "name" : "Practitioner",
        "description" : "This profile defines how to represent Practitioners in FHIR for the purpose of the XpanDH project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PractitionerRole-eu-xpandh"
        },
        "name" : "PractitionerRole",
        "description" : "This profile defines how to represent Practitioners (with thier roles) in FHIR for the purpose of the XpanDH project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/poa-indicator-xpandh-cs"
        },
        "name" : "Present on Admission (POA) Indicator",
        "description" : "Present on Admission (POA) indicators",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/TNM-T-category-vs"
        },
        "name" : "Primary tumor T",
        "description" : "Primary tumor (T) category",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Procedure-xpandh"
        },
        "name" : "Procedure (Xpandh)",
        "description" : "This profile represents the constraints applied to the Procedure resource by the Xpandh project. This profile is based on International patient Summary (IPS) procedure profile.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/procedure-snomed-xpandh-vs"
        },
        "name" : "Procedure codes: Snomed CT",
        "description" : "This value set includes codes from SNOMED Clinical Terms®: descendants of 71388002 \\|Procedure (procedure)\\|, excluding [all subtypes of 14734007 \\|Administrative procedure (procedure)\\|, all subtypes of 59524001 \\|Blood bank procedure (procedure)\\|, all subtypes of 389067005 \\|Community health procedure (procedure)\\|, all subtypes of 442006003 \\|Determination of information related to transfusion (procedure)\\|, all subtypes of 225288009 \\|Environmental care procedure (procedure)\\|, all subtypes of 308335008 \\|Patient encounter procedure (procedure)\\|, all subtypes of 710135002 \\|Promotion (procedure)\\|, all subtypes of 389084004 \\|Staff related procedure (procedure)\\|].",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/procedures-snomed-absent-unknown-xpandh-vs"
        },
        "name" : "Procedures - SNOMED CT + Absent/Unknown - IPS",
        "description" : "This value set includes codes from SNOMED Clinical Terms®: descendants of 71388002 \\|Procedure (procedure)\\|, excluding [all subtypes of 14734007 \\|Administrative procedure (procedure)\\|, all subtypes of 59524001 \\|Blood bank procedure (procedure)\\|, all subtypes of 389067005 \\|Community health procedure (procedure)\\|, all subtypes of 442006003 \\|Determination of information related to transfusion (procedure)\\|, all subtypes of 225288009 \\|Environmental care procedure (procedure)\\|, all subtypes of 308335008 \\|Patient encounter procedure (procedure)\\|, all subtypes of 710135002 \\|Promotion (procedure)\\|, all subtypes of 389084004 \\|Staff related procedure (procedure)\\|], plus IPS codes for absent/unknown procedures.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/serviceRequest-hdr-eu-xpandh"
        },
        "name" : "ServiceRequest: Encounter Request",
        "description" : "ServiceRequest used to represent a the request that triggered this HDR for the scope of the XpanDH project. Thsi is also used to link the HDR witht the payer",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/SK-Hospital-Encounter"
        },
        "name" : "SK-Hospital-Encounter",
        "description" : "Slovak hospital - example of a health provider organization",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/inpatient-encounter-hdr-xpandh"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/SK-Organization-GP"
        },
        "name" : "SK-Organization-GP",
        "description" : "Slovak general practitioner example",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/organization-expandh"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/SK-Organization-Hospital"
        },
        "name" : "SK-Organization-Hospital",
        "description" : "Slovak hospital - example of a health provider organization",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/organization-expandh"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/SK-Organization-Hospital-Department-1"
        },
        "name" : "SK-Organization-Hospital-Department-1",
        "description" : "Example of Slovak hospital department",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/organization-expandh"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/SK-Practitioner-1"
        },
        "name" : "SK-Practitioner-1",
        "description" : "Zdravotnický pracovník id(NRZP)=123456789",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Practitioner-eu-xpandh"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/SK-Practitioner-2"
        },
        "name" : "SK-Practitioner-2",
        "description" : "SK Practitioner id=987654321",
        "exampleCanonical" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Practitioner-eu-xpandh"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/skinfold-thickness-units-vs"
        },
        "name" : "Skinfold Thickness Units Value Set",
        "description" : "Skinfold Thickness observation units for the XpanDH Skinfold Thickness observations.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/skinfold-thickness-vs"
        },
        "name" : "Skinfold Thickness Value Set",
        "description" : "Skinfold Thickness observation codes from the XpanDH Skinfold Thickness observations.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/socail-history-observations-xpandh-vs"
        },
        "name" : "Social history observation codes: Snomed CT",
        "description" : "This value set includes selected codes from SNOMED Clinical Terms®",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/TNM-M-category-vs"
        },
        "name" : "TNM M Category",
        "description" : "Distant metastazis (M) category",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/TNM-N-category-vs"
        },
        "name" : "TNM N Category",
        "description" : "Regional lymph nodes (N) category",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hdr-treated-xpandh-vs"
        },
        "name" : "Treatment Class Value Set",
        "description" : "Value set for category of treatement of the conditoin during encounter.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/observation-vital-signs-xpandh"
        },
        "name" : "Vital Signs Observation",
        "description" : "This profile constrains the Observation resource to represent various types of vital signs observations. This is the base profile from which the other specific vital sign profiles are derived.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vital-signs-observation-vs"
        },
        "name" : "Vital Signs Observation Value Set",
        "description" : "The vital sign obsevrvation codes from the XpanDH Vital Signs.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/whodas-20-cs"
        },
        "name" : "WHO Disability Assessment Schedule 2.0",
        "description" : "WHODAS 2.0 provides a common metric of the impact of any health condition in terms of functioning. HODAS 2.0 produces domain-specific scores for six different functioning domains – cognition, mobility,\nself-care, getting along, life activities (household and work) and participation.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/allergy-intolerance-xpandh"
        },
        "name" : "Xpandh Alergy Intolerance Profile",
        "description" : "This profile represents the constraints applied to the AllergyIntolerance resource by the Xpandh Hospital Discharge Report FHIR Implementation Guide.\r\n\nIt documents the relevant allergies or intolerances (conditions) for a patient, describing the kind of reaction (e.g. rash, anaphylaxis,..); preferably the agents that cause it; and optionally the criticality and the certainty of the allergy.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/assessment-category-xpandh-cs"
        },
        "name" : "Xpandh Assessment Category",
        "description" : "Category codes used in Xpandh Profiles such as the Xpandh Assessment Observation Profile. The are typically used when there is a need for categorization for searching and finding resources or workflow hints.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/assessment-observation-category-vs"
        },
        "name" : "Xpandh Assessment Observation Category",
        "description" : "Used to classify the context of a survey, screening or assessment for assessment observations and may be used to assist with indexing and searching for appropriate instances.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/assessment-observation-xpandh"
        },
        "name" : "Xpandh Assessment Observation Profile",
        "description" : "This profile promotes interoperability and adoption through common implementation by setting minimum expectations for the Observation resource to record, search, and retrieve observations representing a practitioner's clinical observation or assertion about a patient's health status.\nThese observations may or may not be associated with a formal survey, screening, or assessment tool. For example, a social history status such as education or food insecurity or an assessment of the patient's cognitive, functional, or disability status.\nThis profile identifies which core elements, extensions, vocabularies, and value sets **SHALL** be present in the resource when using this profile. It provides the floor for standards development for specific use cases.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/blood-pressure-xpandh"
        },
        "name" : "Xpandh Blood Pressure Profile",
        "description" : "This profile sets minimum expectations for the Observation resource to record, search, and fetch diastolic and systolic blood pressure observations with standard SNOMED CT codes and UCUM units of measure. It is based on the Observation Vital Signs Xpandh profile and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets which **SHALL** be present in the Observation resource when using this profile.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/bmi-xpandh"
        },
        "name" : "Xpandh BMI Profile",
        "description" : "This profile sets minimum expectations for the Observation resource to record, search, and fetch Body Mass Index (BMI) observations with a standard SNOMED CT code and UCUM units of measure. It is based on the Observation Vital Signs Xpandh profile and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets which **SHALL** be present in the Observation resource when using this profile.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/body-height-xpandh"
        },
        "name" : "Xpandh Body Height Profile",
        "description" : "This profile sets minimum expectations for the Observation resource to record, search, and fetch body height observations with a standard SNOMED CT code and UCUM units of measure. It is based on the Observation Vital Signs Xpandh profile and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets which **SHALL** be present in the Observation resource when using this profile.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/body-temperature-xpandh"
        },
        "name" : "Xpandh Body Temperature Profile",
        "description" : "This profile sets minimum expectations for the Observation resource to record, search, and fetch body height observations with a standard SNOMED CT code and UCUM units of measure. It is based on the Observation Vital Signs Xpandh profile and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets which **SHALL** be present in the Observation resource when using this profile.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/body-weight-xpandh"
        },
        "name" : "Xpandh Body Weight Profile",
        "description" : "This profile sets minimum expectations for the Observation resource to record, search, and fetch body height observations with a standard SNOMED CT code and UCUM units of measure. It is based on the Observation Vital Signs Xpandh profile and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets which **SHALL** be present in the Observation resource when using this profile.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/circumference-measurement-xpandh"
        },
        "name" : "Xpandh Circumference Measurement Profile",
        "description" : "This profile sets minimum expectations for the Observation resource to record, search, and fetch body height observations with a standard SNOMED CT code and UCUM units of measure. It is based on the Observation Vital Signs Xpandh profile and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets which **SHALL** be present in the Observation resource when using this profile.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/clinical-impression-hdr-xpandh"
        },
        "name" : "Xpandh Clinical Impression Profile",
        "description" : "This profile represents the constraints applied to the ClinicalImpression resource by the Xpandh FHIR Implementation Guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/condition-problems-hdr-xpandh"
        },
        "name" : "Xpandh Condition Problems Profile",
        "description" : "Xpandh Condition Problems Profile is based upon the core FHIR Condition Resource and meets the  Xpandh project requirements.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/functional-assessment-scales-vs"
        },
        "name" : "Xpandh Functional Assessment Scales",
        "description" : "Used to specify type of functional assessment scale. May be used to assist with indexing and searching for appropriate instances.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/functional-status-assessment-xpandh"
        },
        "name" : "Xpandh Functional Status Observation Profile",
        "description" : "This profile promotes interoperability and adoption through common implementation by setting minimum expectations for the Functional Status Observation resource to record, search, and retrieve observations representing a practitioner's assertion about a patient's functional status.\nThese observations may or may not be associated with a formal survey, screening, or assessment tool. For example, an assessment of the patient's cognitive, functional, or disability status.\nThis profile identifies which core elements, extensions, vocabularies, and value sets **SHALL** be present in the resource when using this profile. It provides the floor for standards development for specific use cases.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/heart-rate-xpandh"
        },
        "name" : "Xpandh Heart Rate Profile",
        "description" : "This profile sets minimum expectations for the Observation resource to record, search, and fetch body height observations with a standard SNOMED CT code and UCUM units of measure. It is based on the Observation Vital Signs Xpandh profile and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets which **SHALL** be present in the Observation resource when using this profile.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/immunization-xpandh"
        },
        "name" : "Xpandh Immunization Profile",
        "description" : "This profile sets minimum expectations for the Immunization resource to record, search, and fetch immunization details. It is based on the Immunization profile and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets which **SHALL** be present in the Immunization resource when using this profile.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/immunization-target-vs"
        },
        "name" : "Xpandh Immunization Target Disease or Agent",
        "description" : "Vaccine preventable disease being targeted. Value set includes selected codes from recommended EU code systems for disease or agent that the vaccination provides protection against (WHO-ICD-10, SNOMED CT). All WHO-ICD-10 and SNOMED CT codes from disease hierarchy are included.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/infectious-contact-xpandh"
        },
        "name" : "Xpandh Infectious Contact Profile",
        "description" : "Infectious Contact profile represents potential patient exposure to an agent (exposure source).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/organization-expandh"
        },
        "name" : "Xpandh Organization Profile",
        "description" : "This profile sets minimum expectations for the Organization resource to searching for and fetching an Organization associated with a patient or provider to promote interoperability and adoption through common implementation.  It identifies which core elements, extensions, vocabularies, and value sets **SHALL** be present in the resource when using this profile.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/oxygen-saturation-xpandh"
        },
        "name" : "Xpandh Oxygen Saturation Profile",
        "description" : "This profile sets minimum expectations for the Observation resource to record, search, and fetch body height observations with a standard SNOMED CT code and UCUM units of measure. It is based on the Observation Vital Signs Xpandh profile and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets which **SHALL** be present in the Observation resource when using this profile.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/pediatric-head-occ-front-circumfer-percent-xpandh"
        },
        "name" : "Xpandh Pediatric Head Occipital Frontal Circumference Profile",
        "description" : "This profile sets minimum expectations for the Observation resource to record, search, and fetch body height observations with a standard SNOMED CT code and UCUM units of measure. It is based on the Observation Vital Signs Xpandh profile and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets which **SHALL** be present in the Observation resource when using this profile.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/respiratory-rate-xpandh"
        },
        "name" : "Xpandh Respiratory Rate Profile",
        "description" : "This profile sets minimum expectations for the Observation resource to record, search, and fetch body height observations with a standard SNOMED CT code and UCUM units of measure. It is based on the Observation Vital Signs Xpandh profile and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets which **SHALL** be present in the Observation resource when using this profile.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/skinfold-thickness-xpandh"
        },
        "name" : "Xpandh Skinfold Thickness Profile",
        "description" : "This profile sets minimum expectations for the Observation resource to record, search, and fetch body height observations with a standard SNOMED CT code and UCUM units of measure. It is based on the Observation Vital Signs Xpandh profile and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets which **SHALL** be present in the Observation resource when using this profile.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/social-history-xpandh"
        },
        "name" : "Xpandh social history Profile",
        "description" : "This profile sets minimum expectations for the Observation resource to record, search, and fetch social history. It is based on the ObservationResultsXpandh profile and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets which **SHALL** be present in the Observation resource when using this profile.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/travel-history-xpandh"
        },
        "name" : "Xpandh travel history Profile",
        "description" : "This profile sets minimum expectations for the Observation resource to record, search, and fetch travel history. It is based on the ObservationResultsXpandh profile and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets which **SHALL** be present in the Observation resource when using this profile.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/whodas-assessment-xpandh"
        },
        "name" : "Xpandh WHO Disability Assessment Schedule (WHODAS 2.0) Profile",
        "description" : "This profile is an Xpandh implementation of World Health Organization Disability Assessment Schedule (WHODAS 2.0) resource to record, search, and retrieve observations representing a practitioner's assertion about a patient's functional status.\nThis profile identifies which core elements, extensions, vocabularies, and value sets **SHALL** be present in the resource when using this profile. It provides the floor for standards development for specific use cases.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/whodas-code-vs"
        },
        "name" : "Xpandh WHODAS Codes Valueset",
        "description" : "Used to specify WHODAS Disability Assessment Schedule 2.0 assessment codes.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/whodas-domain-vs"
        },
        "name" : "Xpandh WHODAS Domain Valueset",
        "description" : "Used to specify WHODAS Disability Assessment Schedule 2.0 assessment domains.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/whodas-result-vs"
        },
        "name" : "Xpandh WHODAS Result Valueset",
        "description" : "Used to specify WHODAS Disability Assessment Schedule 2.0 functional assessment result codes.",
        "exampleBoolean" : false
      }
    ],
    "page" : {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
          "valueUrl" : "toc.html"
        }
      ],
      "nameUrl" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index.html"
            }
          ],
          "nameUrl" : "index.html",
          "title" : "Home",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "hospital-discharge-report.html"
            }
          ],
          "nameUrl" : "hospital-discharge-report.html",
          "title" : "Hospital Discharge Report",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "examples.html"
            }
          ],
          "nameUrl" : "examples.html",
          "title" : "Examples",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "downloads.html"
            }
          ],
          "nameUrl" : "downloads.html",
          "title" : "Downloads",
          "generation" : "markdown"
        }
      ]
    },
    "parameter" : [
      {
        "code" : "path-resource",
        "value" : "input/capabilities"
      },
      {
        "code" : "path-resource",
        "value" : "input/examples"
      },
      {
        "code" : "path-resource",
        "value" : "input/extensions"
      },
      {
        "code" : "path-resource",
        "value" : "input/models"
      },
      {
        "code" : "path-resource",
        "value" : "input/operations"
      },
      {
        "code" : "path-resource",
        "value" : "input/profiles"
      },
      {
        "code" : "path-resource",
        "value" : "input/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/vocabulary"
      },
      {
        "code" : "path-resource",
        "value" : "input/maps"
      },
      {
        "code" : "path-resource",
        "value" : "input/testing"
      },
      {
        "code" : "path-resource",
        "value" : "input/history"
      },
      {
        "code" : "path-resource",
        "value" : "fsh-generated/resources"
      },
      {
        "code" : "path-pages",
        "value" : "template/config"
      },
      {
        "code" : "path-pages",
        "value" : "input/images"
      },
      {
        "code" : "path-tx-cache",
        "value" : "input-cache/txcache"
      }
    ]
  }
}

```
