# Hospital Discharge Report - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* **Hospital Discharge Report**

## Hospital Discharge Report

### Hospital care overview

An inpatient is a patient who is formally admitted (i.e., hospitalised) to an institution for treatment and/or care and stays for a minimum of one night or more than 24 hours in the hospital or other institution providing inpatient care.

An inpatient care involves examination and treatment of a patient in one healthcare provider organisation from hospitalisation to discharge. A hospital discharge occurs whenever a patient leaves the hospital after e.g., the finalisation of a treatment, a transfer to another health care institution or upon the death of the patient. Therefore, a hospital discharge report is a summary of a patient's medical case during hospital treatment, which reflects the dynamics of a given treatment episode. As such, the hospital discharge report of a hospital encounter is compiled at the end of an inpatient stay for the patient.

A hospital discharge is the formal release of a patient from a hospital (in-patient) stay after a procedure or course of treatment.

### Hospital Discharge Report

Hospital discharge reports serve as the primary documents communicating a patient's episode of care related to hospitalisation. Often, the hospital discharge report is the only form of communication that accompanies the patient to the next setting of care.

High-quality discharge reports are generally thought to be essential for promoting patient safety during transitions between care settings, particularly during the initial post-hospital period. Additionally, hospital discharge reports also provide information intended for the patients themselves, informing them about their health status and the following steps related to care (e.g., recommendations from the medical specialist).

#### Hospital Discharge Report Logical Building Blocks

Below are the individual building-blocks or modules that are contained in a typical hospital discharge report. These modules reflect the business/clinical needs for creating and maintaining a hospital discharge report and use the information module components of a common EU hospital discharge report detailed in the next chapters.

#### Report header

Report header includes the basic formal aspects of the hospital discharge report specified basic administrative data and other important data for the administrative context of the discharge report. This data includes:

* Identification of the patient/subject
* Patient/subject related contact information
* Preferred healthcare providers
* Legal guardians (if applicable)
* Health insurance and payment information
* Identification and contact details of the author(s) of the discharge report
* Identification and contact details of the healthcare provider who provided health services during hospitalization, including the identification of the organizational components (departments) that hosted the patient during hospitalisation
* Identification and contact details of the doctor who verified/validated the content of the discharge report and identification details of the provider that this doctor represents
* Identification and contact details of the doctor who authorized and is responsible for the content of the discharge report, identification details of the provider that this doctor represents
* Recipients (intended addressees) of the discharge report
* Document metadata

#### Emergency information

Emergency information comprises two sets of information:

* Allergies and intolerances
* Medical alerts

##### Allergies and intolerances

This section lists reactions that have manifested and been assessed as allergies and other manifestations of intolerance. In particular, details on allergic reactions to drugs,food, and other substances used in the provision of health care are listed: i.e. the causative agent, the type (nature) of the reaction and its severity.

If an allergy has been ruled out or the patient's allergic disposition is unknown, this should be recorded in this section.

##### Medical alerts

The Alerts section lists medical conditions or situations that may cause an emergency. This may be a contraindication to the use of a particular medicine or treatment. The situation described may pose a risk to the patient, but also to others, for example in the case of infectious diseases. Failure to recognise the warning may lead to errors in good medical practice.

#### Advance directives

This section is used to record information about the patient's previously expressed wishes made while hospitalised according to the applicable legislation.

The structured record of information about previously expressed wishes includes

* Date of wish expressed
* Nature of the wish - verbal or coded
* Document containing the expression of the patient's wishes, with the formalities required by the applicable legislation
* Conditions to which the wish applies

#### Encounter details

The encounter section contains basic information about the patient's admission and discharge, i.e:

* Type of encounter (overnight, standard)
* Admission information
* Reason for admission
* Discharge information
* Information on stay in all wards during hospitalisation

#### Admission evaluation

The purpose of this section is to provide a brief and concise description of the patient's clinical condition at the time of admission, with emphasis on pathological manifestations. It is particularly important if the reason for admission is an acute condition or an exacerbation of a pre-existing condition. The description of the condition on admission should be followed by an equally structured description of the condition on discharge, which should make clear the extent to which the hospitalisation has led to a change in the pathological findings on admission.

What the section contains:

* Date and time of the examination of the patient on admission
* Identification of the physician who performed the initial examination
* Objective findings
* Anthropometric data
* Basic vital signs
* Somatic findings
* Functional status (assessment of the patient's functional status on admission according to the chosen scale)

What does not belong in this section

* Detailed description of physiological findings (clinically irrelevant)
* Test results (they are in another section)
* Admission diagnosis (it is in another section)

#### Patient history

This section consists of data from the patient's medical history:

* Personal history 
* History of health problems (past illnesses) including gynaecological/andrological
* Significant procedures
* Implants and medical devices
* Vaccinations
 
* Substance abuse 
* Smoking
* Alcohol, drugs, addictions
 
* Family history
* Social history 
* Legal status
* Education level
* Occupation
* Housing
* Family and social situation
 
* Epidemiological 
* Travel history
* Infectious contacts
 

#### Hospital stay

This section provides an overview of the diagnostic and therapeutic medical care provided during the hospital stay.

The structured layout allows for easy review of findings (test results) and procedures, especially if a single or clinically predominant health problem was addressed during the inpatient stay.

Unlike the traditional layout, the first section is a diagnostic summary, followed by selected medical treatments, significant procedures and implants. Investigation results are not a mandatory part, but those most relevant to continuity of care or diagnosis are of course included.

The final and most important part of this section is the clinical synthesis, the 'story', including the traditional sections 'present illness', 'course of hospitalisation' and 'epicrisis'. The clinical synthesis must show why and how the patient was admitted to the bed and how his condition developed in response to treatment. The therapeutic procedures used are placed in a diagnostic context, i.e. the results of clinically relevant investigations. The clinical synthesis may conclude with a prognostic reasoning and an outline of further management.

This section includes the following parts:

* Diagnostic summary
* Significant procedures (surgery, major therapeutic interventions)
* Implants
* Other significant treatments (including administration of drugs and blood derivatives)
* Results of investigations: 
* Laboratory 
* Haematology
* Biochemistry
* Histopathology
* Genetics
* Other
 
* Functional 
* Electrophysiological (ECG, EEG, EMG…)
* Other (spirometry, muscle strength tests, 6MWT…)
 
* Imaging tests 
* Ultrasound
* Radiographic methods (X-ray, CT, densitometry)
* Magnetic resonance imaging
* Radioisotope methods
 
* Consiliary examination
 
* Expected test results (not yet delivered)
* Clinical synthesis (free text)

##### Diagnostic summary

The diagnostic summary **INCLUDES** all conditions (problems/diagnoses) that affected care during the hospitalization, as well as others that are important for continuity of care. The diagnostic summary presents all reported conditions as they were recognized at the end of the hospitalization, i.e. after all examinations. The diagnostic summary, in line with international recommendations, specifies for each condition its characteristics in relation to the hospital case, from two perspectives:

1. The presence of the condition on admission
1. The impact of the condition on care during hospitalisation

In terms of presence at admission, they are classified as:

1. POA - conditions/diagnoses present on admission, or problems existing on admission or prior to admission - (definition corresponds to the category POA = Present on Admission in English terminology)
1. HAC - conditions/diagnoses not present on admission, arising during hospitalisation (definition corresponds to the HAC = Hospital Acquired Conditions category in English terminology)
1. OTH - conditions/diagnoses for which it is not possible to decide whether they were present on admission (before admission) or whether they arose after admission and diagnoses for which this information is irrelevant.

In terms of the impact on care during hospitalisation, the following conditions are distinguished:

1. treated - with an impact on care during hospitalisation
1. other - no impact on care during hospitalisation

Conditions for which treatment or diagnosis or nursing care or monitoring was provided during the hospitalisation are considered as 'treated' conditions. The specification of the category of treated conditions may vary slightly between European countries depending on the specific requirements of their reimbursement system.

Diagnosis summary **DOES NOT INCLUDE**:

* Anamnestic data - these are listed in other sections (if there is a reason to do so)
* Detailed history of individual problems - these are given in other sections (if there is a reason to do so)
* Treatment - this is given in other sections (if there is a need)
* Individual findings on which the diagnosis is based - this is given in other sections (if there is a reason to do so)
* Anomalies in examinations (e.g., "mild enlargement of the aortic root on echocardiography"), which alone or with other findings are not conclusive.

The Hospital discharge Report standard leaves the author free to choose the order of the items in the diagnostic summary. Possible and already used sorting vectors are:

* impact on care (separate sections for conditions with and without impact on care)
* aetiology (conditions with the same aetiology are grouped together)
* organ system (conditions affecting the same organ system are grouped together)
* importance (conditions that presented more serious problem during the hospitalisation are ranked higher)

When presenting hospital discharge reports in electronic form, it should be possible to select the display according to the original order of conditions chosen by the author or according to the impact on care (treated, other).

> 
*  The language of the diagnostic summary is scientific, the appropriate standard for the used terminology should follow current medical guidelines, best practice or articles in the scientific literature 
*  Abbreviations are strictly avoided in the diagnostic summary
*  Do **NOT** use ICD* code names (e.g.: "Cutaneous abscess, furuncle and carbuncle, unspecified", which is the name belonging to the L02.9 ICD-10 code); except, of course, where the code name corresponds to the clinical terminology used (e.g. acute respiratory failure, hypercapnic type)
*  For conditions that were treated during hospitalisation, do not report 'status after ...'. If the patient was treated for a myocardial infarction, the dg. myocardial infarction (with appropriate clarification) will be given, **NOT** "condition after myocardial infarction"!, even if the discharge report is written by a different department than the one where the patient was treated for the myocardial infarction.
*  For procedures that were performed during hospitalisation, do **NOT** include 'status after ...' (e.g. status after hysterectomy); this information belongs in the [Significant procedures](#significant-procedures) section.
*  The presence of the condition on admission may even be (rightly) assumed (e.g. for structural abnormalities recognised during hospitalisation, such as intestinal diverticula). The condition may therefore not be recognised on admission.
*  If the onset date of the condition is provided, consistency with the entry for the presence of the condition on admission should be ensured.

##### Significant procedures

This section lists surgery and other 'instrumental' procedures (endoscopic, intravascular). Typically, these are all invasive procedures performed in the operating theatre.

This section **DOES NOT INCLUDE** purely diagnostic procedures.

##### Medical devices and implants

A list of implants inserted during the hospital stay, if relevant to the provision of healthcare, including diagnosis. Each implant must have a corresponding procedure record in the 'Significant Procedures' section.

##### Other significant treatment

Treatment that cannot be clearly identified as a major procedure (in the sense of the previous definition) but is significant - typically chemotherapy, radiotherapy, purification procedures (dialysis, haemoperfusion), circulatory support procedures (counterpulsation, etc.), administration of blood derivatives etc.

##### Pharmacotherapy

Medications provided only during hospitalisation or for a short period after discharge, but of which knowledge is important for subsequent health care continuity (antibiotics other than routine ones, high-dose corticosteroids, etc.) should be listed.

This section **DOES NOT INCLUDE** medications started during hospitalisation but recommended after discharge. These are listed in the Medication summary table in the Recommendations section.

##### Significant Observation Results

Results of significant functional, diagnostic and imaging studies performed during hospitalisation.

The section includes synopsis of selected significant results of functional, diagnostic and imaging studies performed during hospitalisation and relevant to continuity of care, broken down by type of study/diagnostic method and type of material examined (e.g. electrophysiological studies, laboratory studies, imaging studies, etc.).

The discharge report also includes the conclusions of consultations carried out for conditions outside the specialty in which the patient was admitted (psychiatric consultation ordered by an internist or surgeon, endocrinological examination ordered by a psychiatrist, etc.). The outcome of such consultations is often reflected in a diagnostic summary, a recommendation or even a clinical synthesis section.

##### Expected Results

Results of examinations ordered but not yet delivered should be presented separately from results already delivered.

Any tests ordered, the results of which are not known at the time of the discharge report, and the manner in which the results and any resulting actions and/or recommendations will be communicated, should be stated.

Knowledge of tests already performed is important for continuity of care, including avoiding unnecessary repetition of diagnostic procedures. In the case of a provisional discharge report, it is **NOT** the investigations that will be known at the time of the final discharge report.

##### Synthesis

Detailed description of the reason for and course of the hospitalisation (for the whole hospitalisation), **structured** according to **individual problems**.

For each problem, a description of the clinical case is given, followed by a history of the illness that was the reason for hospitalisation ('current illness'), including its diagnosis and treatment prior to admission. This is followed by an assessment of the effect of the care provided, prognostic considerations and a proposal for further management.

The clinical summary may conclude with clinical reasoning (differential diagnosis, explanation of causality, etc.) for clinically complex conditions.

It is ** RECOMMENDED** that this section of the discharge report be the sole narrative section (i.e. written entirely in free text and complete sentences). The purpose of this arrangement is to allow a fluent reading of the course of the illness (including comorbidities and complications) before and after admission.

The content is divided into three continuous sections, which should be separated as separate paragraphs.

1. The first section describes the problem (in slightly more detail than in the 'Reason for Admission', but still with an emphasis on overall brevity) that led to admission. This section corresponds to what is traditionally called the "present illness" section.
1. The second section describes the course of the hospitalisation, including any complications that occurred during the hospitalisation (if there were none, it is explicitly stated that the course was free of complications). The information is arranged according to each clinical problem,**NOT chronologically**.
1. In the third (optional) part, a clinical reasoning is given and unresolved problems are mentioned.

#### Discharge details

The description of the condition at discharge documents changes compared to the condition at admission - in particular the regression of pathological changes, but also new deviations, e.g. if complications occurred during the hospitalisation (stroke, trauma, allergic skin reaction).

What the section contains:

* Objective findings
* Anthropometric data
* Basic vital signs
* Somatic findings - changes from admission status
* Functional status - changes from admission status

What **does not belong** in this section:

* Detailed description of physiological findings

#### Recommendations

It is crucial to the continuity of care. In many ways, the referral is the result of the diagnostic and treatment process during hospitalisation and modifies, but usually significantly extends or changes, the previous treatment.

The content of this section is a clear yet sufficiently detailed and, above all, comprehensive guide for the patient himself, for his environment and, of course, for the provision of general and specialised healthcare.

In some cases, depending on the nature of the disease, there may be no need for specific measures or pharmacotherapy.

The content of this section includes all recommendations/care plan relating to health status and health care. In particular:

* Social and health measures after discharge
* Treatment regimen + dietary recommendations
* Summary of medication
* Other recommended actions/Care plan

##### Social and health measures after discharge

Arrangement or proposal of home care, including administration of medication, day care, etc.

##### Treatment regimen and dietary recommendations

Recommended physical and/or mental regimen; recommended diet or gradual dietary regimen. Dietary recommendations must relate to the diet at the time of discharge; instruction by a nutrition therapist should be a matter of course, as should exercise or rehabilitation recommendations.

##### Medication summary

A summary of the recommended medication for the post-discharge period, indicating whether it is a change or a new medication. The summary will be supplemented by the medications that have been discontinued, contrary to previous practice.

All medications must be clearly listed, including the name of the medication, dosage form, strength, dosage/dosing schedule. The patient must be provided with the necessary recommended medication for at least X days after discharge, depending on current applicable legislation.

##### Care plan

Further care depends on the speciality and the patient's condition (dressings, wound checks, dosage adjustments according to the results of the tests).

This section includes

* Dates, times and places of appointments and examinations ordered (or arranged), dates of follow-up hospital admissions arranged.
* Recommended investigations that could not be arranged for the patient (with a clear indication of who should arrange such investigations or where they can be arranged).
* Formalised treatment plans, including goals

What does not belong in this section:

* General considerations about what to do next.
* Abbreviations, unspecified information.

