# Xpandh WHODAS Codes Valueset - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Xpandh WHODAS Codes Valueset**

## ValueSet: Xpandh WHODAS Codes Valueset 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/hdr/ValueSet/whodas-code-vs | *Version*:0.1.0 |
| Active as of 2025-10-10 | *Computable Name*:WHODASCodeVS |
| **Copyright/Legal**: Used by permission of the XpanDH project, all rights reserved Creative Commons License | |

 
Used to specify WHODAS Disability Assessment Schedule 2.0 assessment codes. 

 **References** 

* [Xpandh WHO Disability Assessment Schedule (WHODAS 2.0) Profile](StructureDefinition-whodas-assessment-xpandh.md)

### Logical Definition (CLD)

* Include codes from`https://id.who.int/whodas` version Not Stated (use latest from terminology server) where concept.level = 1

 

### Expansion

No Expansion for this valueset (Unknown Code System)

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "whodas-code-vs",
  "url" : "http://hl7.eu/fhir/ig/xpandh/hdr/ValueSet/whodas-code-vs",
  "version" : "0.1.0",
  "name" : "WHODASCodeVS",
  "title" : "Xpandh WHODAS Codes Valueset",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-10T16:32:47+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "Used to specify WHODAS Disability Assessment Schedule 2.0 assessment codes.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of the XpanDH project, all rights reserved Creative Commons License",
  "compose" : {
    "include" : [
      {
        "system" : "https://id.who.int/whodas",
        "filter" : [
          {
            "property" : "concept.level",
            "op" : "=",
            "value" : "1"
          }
        ]
      }
    ]
  }
}

```
