# Medications - SNOMED CT + Absent/Unknown (IPS) - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Medications - SNOMED CT + Absent/Unknown (IPS)**

## ValueSet: Medications - SNOMED CT + Absent/Unknown (IPS) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/hdr/ValueSet/medication-snomed-absent-unknown-uv-ips | *Version*:0.1.0 |
| Active as of 2025-10-10 | *Computable Name*:MedicationSnomedCodesAbsentUnknown |
| **Copyright/Legal**: The HL7 International IPS implementation guides incorporate SNOMED CT®, used by permission of the International Health Terminology Standards Development Organisation, trading as SNOMED International. SNOMED CT was originally created by the College of American Pathologists. SNOMED CT is a registered trademark of the International Health Terminology Standards Development Organisation, all rights reserved. Implementers of SNOMED CT should review[usage terms](http://www.snomed.org/snomed-ct/get-snomed-ct)or directly contact SNOMED International: info@snomed.org | |

 
This value set includes the codes from SNOMED CT that are included in: descendants of 373873005 |Pharmaceutical / biologic product (product)|, excluding the descendants of 787859002 |Vaccine product (medicinal product)|, plus IPS codes for absent/unknown medications. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

This value set includes codes based on the following rules:

* Import all the codes that are contained in [Medications - SNOMED CT (IPS)](http://hl7.org/fhir/uv/ips/STU1.1/ValueSet-medication-snomed-uv-ips.html)
* Import all the codes that are contained in [Absent or Unknown Medication - IPS](http://hl7.org/fhir/uv/ips/STU1.1/ValueSet-absent-or-unknown-medications-uv-ips.html)

 

### Expansion

This value set cannot be expanded because the terminology server(s) deemed it too costly to do so

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "medication-snomed-absent-unknown-uv-ips",
  "url" : "http://hl7.eu/fhir/ig/xpandh/hdr/ValueSet/medication-snomed-absent-unknown-uv-ips",
  "version" : "0.1.0",
  "name" : "MedicationSnomedCodesAbsentUnknown",
  "title" : "Medications - SNOMED CT + Absent/Unknown (IPS)",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-10T16:32:47+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "This value set includes the codes from SNOMED CT that are included in: descendants of 373873005 \\|Pharmaceutical / biologic product (product)\\|, excluding the descendants of 787859002 \\|Vaccine product (medicinal product)\\|, plus IPS codes for absent/unknown medications.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "immutable" : false,
  "copyright" : "The HL7 International IPS implementation guides incorporate SNOMED CT®, used by permission of the International Health Terminology Standards Development Organisation, trading as SNOMED International. SNOMED CT was originally created by the College of American Pathologists. SNOMED CT is a registered trademark of the International Health Terminology Standards Development Organisation, all rights reserved. Implementers of SNOMED CT should review [usage terms](http://www.snomed.org/snomed-ct/get-snomed-ct) or directly contact SNOMED International: info@snomed.org",
  "compose" : {
    "include" : [
      {
        "valueSet" : [
          "http://hl7.org/fhir/uv/ips/ValueSet/medication-snomed-uv-ips"
        ]
      },
      {
        "valueSet" : [
          "http://hl7.org/fhir/uv/ips/ValueSet/absent-or-unknown-medications-uv-ips"
        ]
      }
    ]
  }
}

```
