# Xpandh Organization Profile - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Xpandh Organization Profile**

## Resource Profile: Xpandh Organization Profile 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/organization-expandh | *Version*:0.1.0 |
| Active as of 2025-10-10 | *Computable Name*:OrganizationXpandh |
| **Copyright/Legal**: Used by permission of the XpanDH project, all rights reserved Creative Commons License | |

 
This profile sets minimum expectations for the Organization resource to searching for and fetching an Organization associated with a patient or provider to promote interoperability and adoption through common implementation. It identifies which core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource when using this profile. 

**Usages:**

* Refer to this Profile: [CareTeam](StructureDefinition-CareTeam-eu-xpandh.md), [Observation Results](StructureDefinition-Observation-results-xpandh.md), [Patient: HDR](StructureDefinition-Patient-eu-xpandh.md), [PractitionerRole](StructureDefinition-PractitionerRole-eu-xpandh.md)...Show 3 more,[Xpandh Assessment Observation Profile](StructureDefinition-assessment-observation-xpandh.md),[Xpandh Immunization Profile](StructureDefinition-immunization-xpandh.md)and[Xpandh Organization Profile](StructureDefinition-organization-expandh.md)
* Examples for this Profile: [MUDr. Pes Filipes, praktický lékař](Organization-SK-Organization-GP.md), [Nemocnica - oddělení chirurgie](Organization-SK-Organization-Hospital-Department-1.md) and [Mestská Nemocnica Kubín](Organization-SK-Organization-Hospital.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.xpandh.hdr|current/StructureDefinition/organization-expandh)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-organization-expandh.csv), [Excel](StructureDefinition-organization-expandh.xlsx), [Schematron](StructureDefinition-organization-expandh.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "organization-expandh",
  "url" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/organization-expandh",
  "version" : "0.1.0",
  "name" : "OrganizationXpandh",
  "title" : "Xpandh Organization Profile",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-10T16:32:47+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "This profile sets minimum expectations for the Organization resource to searching for and fetching an Organization associated with a patient or provider to promote interoperability and adoption through common implementation.  It identifies which core elements, extensions, vocabularies, and value sets **SHALL** be present in the resource when using this profile.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of the XpanDH project, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Organization",
  "baseDefinition" : "http://hl7.org/fhir/uv/ips/StructureDefinition/Organization-uv-ips",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization",
        "path" : "Organization"
      },
      {
        "id" : "Organization.type",
        "path" : "Organization.type",
        "mustSupport" : true
      },
      {
        "id" : "Organization.telecom",
        "path" : "Organization.telecom",
        "mustSupport" : true
      },
      {
        "id" : "Organization.telecom.system",
        "path" : "Organization.telecom.system",
        "mustSupport" : true
      },
      {
        "id" : "Organization.telecom.value",
        "path" : "Organization.telecom.value",
        "mustSupport" : true
      },
      {
        "id" : "Organization.address",
        "path" : "Organization.address",
        "type" : [
          {
            "code" : "Address",
            "profile" : [
              "http://hl7.eu/fhir/laboratory/StructureDefinition/Address-eu"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Organization.partOf",
        "path" : "Organization.partOf",
        "short" : "The organization of which this organization is part of: e.g. an ERN",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-hierarchy",
                "valueBoolean" : true
              }
            ],
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/organization-expandh",
              "http://hl7.org/fhir/StructureDefinition/Organization"
            ]
          }
        ]
      },
      {
        "id" : "Organization.contact",
        "path" : "Organization.contact",
        "mustSupport" : true
      }
    ]
  }
}

```
