# Xpandh Functional Status Observation Profile - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Xpandh Functional Status Observation Profile**

## Resource Profile: Xpandh Functional Status Observation Profile 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/functional-status-assessment-xpandh | *Version*:0.1.0 |
| Draft as of 2025-10-10 | *Computable Name*:FunctionalStatusAssessmentXpandh |
| **Copyright/Legal**: Used by permission of the XpanDH project, all rights reserved Creative Commons License | |

 
This profile promotes interoperability and adoption through common implementation by setting minimum expectations for the Functional Status Observation resource to record, search, and retrieve observations representing a practitioner's assertion about a patient's functional status. These observations may or may not be associated with a formal survey, screening, or assessment tool. For example, an assessment of the patient's cognitive, functional, or disability status. This profile identifies which core elements, extensions, vocabularies, and value sets**SHALL**be present in the resource when using this profile. It provides the floor for standards development for specific use cases. 

**Usages:**

* Derived from this Profile: [Xpandh WHO Disability Assessment Schedule (WHODAS 2.0) Profile](StructureDefinition-whodas-assessment-xpandh.md)
* Refer to this Profile: [Composition: Hospital Discharge Report](StructureDefinition-Composition-hdr-eu-xpandh.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.xpandh.hdr|current/StructureDefinition/functional-status-assessment-xpandh)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-functional-status-assessment-xpandh.csv), [Excel](StructureDefinition-functional-status-assessment-xpandh.xlsx), [Schematron](StructureDefinition-functional-status-assessment-xpandh.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "functional-status-assessment-xpandh",
  "url" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/functional-status-assessment-xpandh",
  "version" : "0.1.0",
  "name" : "FunctionalStatusAssessmentXpandh",
  "title" : "Xpandh Functional Status Observation Profile",
  "status" : "draft",
  "date" : "2025-10-10T16:32:47+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "This profile promotes interoperability and adoption through common implementation by setting minimum expectations for the Functional Status Observation resource to record, search, and retrieve observations representing a practitioner's assertion about a patient's functional status.\nThese observations may or may not be associated with a formal survey, screening, or assessment tool. For example, an assessment of the patient's cognitive, functional, or disability status.\nThis profile identifies which core elements, extensions, vocabularies, and value sets **SHALL** be present in the resource when using this profile. It provides the floor for standards development for specific use cases.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of the XpanDH project, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/assessment-observation-xpandh",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "short" : "Functional assessment observation"
      },
      {
        "id" : "Observation.category:assessment",
        "path" : "Observation.category",
        "sliceName" : "assessment",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.eu/fhir/ig/xpandh/hdr/CodeSystem/assessment-category-xpandh-cs",
              "code" : "functional-status"
            }
          ]
        }
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.eu/fhir/ig/xpandh/hdr/ValueSet/functional-assessment-scales-vs"
        }
      },
      {
        "id" : "Observation.hasMember",
        "path" : "Observation.hasMember",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/whodas-assessment-xpandh",
              "http://hl7.org/fhir/StructureDefinition/Observation",
              "http://hl7.org/fhir/StructureDefinition/QuestionnaireResponse",
              "http://hl7.org/fhir/StructureDefinition/MolecularSequence"
            ]
          }
        ]
      }
    ]
  }
}

```
