# Xpandh Blood Pressure Profile - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Xpandh Blood Pressure Profile**

## Resource Profile: Xpandh Blood Pressure Profile 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/blood-pressure-xpandh | *Version*:0.1.0 |
| Draft as of 2025-10-10 | *Computable Name*:BloodPressureXpandh |
| **Copyright/Legal**: Used by permission of the XpanDH project, all rights reserved Creative Commons License | |

 
This profile sets minimum expectations for the Observation resource to record, search, and fetch diastolic and systolic blood pressure observations with standard SNOMED CT codes and UCUM units of measure. It is based on the Observation Vital Signs Xpandh profile and identifies the**additional**mandatory core elements, extensions, vocabularies and value sets which**SHALL**be present in the Observation resource when using this profile. 

**Usages:**

* Refer to this Profile: [Composition: Hospital Discharge Report](StructureDefinition-Composition-hdr-eu-xpandh.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.xpandh.hdr|current/StructureDefinition/blood-pressure-xpandh)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-blood-pressure-xpandh.csv), [Excel](StructureDefinition-blood-pressure-xpandh.xlsx), [Schematron](StructureDefinition-blood-pressure-xpandh.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "blood-pressure-xpandh",
  "url" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/blood-pressure-xpandh",
  "version" : "0.1.0",
  "name" : "BloodPressureXpandh",
  "title" : "Xpandh Blood Pressure Profile",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-10T16:32:47+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "This profile sets minimum expectations for the Observation resource to record, search, and fetch diastolic and systolic blood pressure observations with standard SNOMED CT codes and UCUM units of measure. It is based on the Observation Vital Signs Xpandh profile and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets which **SHALL** be present in the Observation resource when using this profile.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of the XpanDH project, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/observation-vital-signs-xpandh",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "short" : "Xpandh Blood Pressure Profile"
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "short" : "Blood Pressure",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "75367002"
            }
          ]
        }
      },
      {
        "id" : "Observation.component",
        "path" : "Observation.component",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 2
      },
      {
        "id" : "Observation.component:systolic",
        "path" : "Observation.component",
        "sliceName" : "systolic",
        "short" : "Systolic Blood Pressure",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:systolic.code",
        "path" : "Observation.component.code",
        "short" : "Systolic Blood Pressure Code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "271649006"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:systolic.value[x]",
        "path" : "Observation.component.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.component:systolic.value[x]:valueQuantity",
        "path" : "Observation.component.value[x]",
        "sliceName" : "valueQuantity",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "Quantity"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:systolic.value[x]:valueQuantity.value",
        "path" : "Observation.component.value[x].value",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:systolic.value[x]:valueQuantity.unit",
        "path" : "Observation.component.value[x].unit",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:systolic.value[x]:valueQuantity.system",
        "path" : "Observation.component.value[x].system",
        "min" : 1,
        "fixedUri" : "http://unitsofmeasure.org",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:systolic.value[x]:valueQuantity.code",
        "path" : "Observation.component.value[x].code",
        "min" : 1,
        "fixedCode" : "mm[Hg]",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:diastolic",
        "path" : "Observation.component",
        "sliceName" : "diastolic",
        "short" : "Diastolic Blood Pressure",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:diastolic.code",
        "path" : "Observation.component.code",
        "short" : "Diastolic Blood Pressure Code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "271650006",
              "display" : "Diastolic blood pressure (observable entity)"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:diastolic.value[x]",
        "path" : "Observation.component.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.component:diastolic.value[x]:valueQuantity",
        "path" : "Observation.component.value[x]",
        "sliceName" : "valueQuantity",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "Quantity"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:diastolic.value[x]:valueQuantity.value",
        "path" : "Observation.component.value[x].value",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:diastolic.value[x]:valueQuantity.unit",
        "path" : "Observation.component.value[x].unit",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:diastolic.value[x]:valueQuantity.system",
        "path" : "Observation.component.value[x].system",
        "min" : 1,
        "fixedUri" : "http://unitsofmeasure.org",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:diastolic.value[x]:valueQuantity.code",
        "path" : "Observation.component.value[x].code",
        "min" : 1,
        "fixedCode" : "mm[Hg]",
        "mustSupport" : true
      }
    ]
  }
}

```
