# Observation Results - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Observation Results**

## Resource Profile: Observation Results 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Observation-results-xpandh | *Version*:0.1.0 |
| Draft as of 2025-10-10 | *Computable Name*:ObservationResultsXpandh |
| **Copyright/Legal**: Used by permission of the XpanDH project, all rights reserved Creative Commons License | |

 
This profile constrains the Observation resource to represent various types of results and associated observations in a HDR. This is the base profile from which the other results profiles are derived. 

 
This profile constrains the Observation resource to represent various types of results and associated observations in a hospital discharge report. 

**Usages:**

* Derived from this Profile: [Xpandh Infectious Contact Profile](StructureDefinition-infectious-contact-xpandh.md), [Xpandh social history Profile](StructureDefinition-social-history-xpandh.md) and [Xpandh travel history Profile](StructureDefinition-travel-history-xpandh.md)
* Refer to this Profile: [Observation Results](StructureDefinition-Observation-results-xpandh.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.xpandh.hdr|current/StructureDefinition/Observation-results-xpandh)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Observation-results-xpandh.csv), [Excel](StructureDefinition-Observation-results-xpandh.xlsx), [Schematron](StructureDefinition-Observation-results-xpandh.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Observation-results-xpandh",
  "url" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Observation-results-xpandh",
  "version" : "0.1.0",
  "name" : "ObservationResultsXpandh",
  "title" : "Observation Results",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-10T16:32:47+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "This profile constrains the Observation resource to represent various types of results and associated observations in a HDR. This is the base profile from which the other results profiles are derived.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "purpose" : "This profile constrains the Observation resource to represent various types of results and associated observations in a hospital discharge report.",
  "copyright" : "Used by permission of the XpanDH project, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation"
      },
      {
        "id" : "Observation.status",
        "path" : "Observation.status",
        "fixedCode" : "final"
      },
      {
        "id" : "Observation.category",
        "path" : "Observation.category",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ]
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.subject",
        "path" : "Observation.subject",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Patient-eu-xpandh",
              "http://hl7.org/fhir/StructureDefinition/Group",
              "http://hl7.org/fhir/StructureDefinition/Device",
              "http://hl7.org/fhir/StructureDefinition/Location"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.subject.reference",
        "path" : "Observation.subject.reference",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Observation.effective[x]",
        "path" : "Observation.effective[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "dateTime"
          },
          {
            "code" : "Period"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.effective[x].extension:data-absent-reason",
        "path" : "Observation.effective[x].extension",
        "sliceName" : "data-absent-reason",
        "short" : "effective[x] absence reason",
        "definition" : "Provides a reason why the effectiveTime is missing.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/data-absent-reason"]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.performer",
        "path" : "Observation.performer",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Practitioner-eu-xpandh",
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/PractitionerRole-eu-xpandh",
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/organization-expandh",
              "http://hl7.org/fhir/StructureDefinition/CareTeam",
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Patient-eu-xpandh",
              "http://hl7.org/fhir/StructureDefinition/RelatedPerson"
            ]
          }
        ]
      },
      {
        "id" : "Observation.value[x]",
        "path" : "Observation.value[x]",
        "mustSupport" : true
      },
      {
        "id" : "Observation.hasMember",
        "path" : "Observation.hasMember",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Observation-results-xpandh",
              "http://hl7.org/fhir/StructureDefinition/QuestionnaireResponse",
              "http://hl7.org/fhir/StructureDefinition/MolecularSequence"
            ]
          }
        ]
      },
      {
        "id" : "Observation.component",
        "path" : "Observation.component",
        "mustSupport" : true
      }
    ]
  }
}

```
