# A.2.9 - Care plan and other recommendations after discharge (eHN) - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.2.9 - Care plan and other recommendations after discharge (eHN)**

## Logical Model: A.2.9 - Care plan and other recommendations after discharge (eHN) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HDRRecommendations | *Version*:0.1.0 |
| Draft as of 2025-10-10 | *Computable Name*:HdrEHNRecommendations |
| **Copyright/Legal**: Used by permission of the XpanDH project, all rights reserved Creative Commons License | |

 
Hospital Discharge Report - Care plan and other recommendations after discharge - A.2.9 eHN Maturity Level: 0 Draft 

**Usages:**

* Use this Logical Model: [A - Hospital Discharge Report (eHN)](StructureDefinition-HospitalDischargeReport.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.xpandh.hdr|current/StructureDefinition/HDRRecommendations)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-HDRRecommendations.csv), [Excel](StructureDefinition-HDRRecommendations.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "HDRRecommendations",
  "url" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HDRRecommendations",
  "version" : "0.1.0",
  "name" : "HdrEHNRecommendations",
  "title" : "A.2.9 - Care plan and other recommendations after discharge (eHN)",
  "status" : "draft",
  "date" : "2025-10-10T16:32:47+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "Hospital Discharge Report - Care plan and other recommendations after discharge - A.2.9 eHN\nMaturity Level: 0 Draft",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of the XpanDH project, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HDRRecommendations",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "HDRRecommendations",
        "path" : "HDRRecommendations",
        "short" : "A.2.9 - Care plan and other recommendations after discharge (eHN)",
        "definition" : "Hospital Discharge Report - Care plan and other recommendations after discharge - A.2.9 eHN\nMaturity Level: 0 Draft"
      },
      {
        "id" : "HDRRecommendations.carePlan",
        "path" : "HDRRecommendations.carePlan",
        "short" : "A.2.9.1 - Care plan",
        "definition" : "Care plan after discharge. Multiple care plans could be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRRecommendations.carePlan.title",
        "path" : "HDRRecommendations.carePlan.title",
        "short" : "A.2.9.1.1 - Title",
        "definition" : "Human-friendly name for the care plan (e.g. Hip replacement care plan)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HDRRecommendations.carePlan.addresses",
        "path" : "HDRRecommendations.carePlan.addresses",
        "short" : "A.2.9.1.2 - Addresses",
        "definition" : "Identifies the conditions/problems/concerns/diagnoses/etc. whose management and/or mitigation are handled by this plan. This element provides a linkage to the conditions recorded in the diagnostic summary section.",
        "comment" : "ICD-10*\nSNOMED CT\nOrphacode if rare disease is diagnosed",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRRecommendations.carePlan.description",
        "path" : "HDRRecommendations.carePlan.description",
        "short" : "A.2.9.1.3 - Description",
        "definition" : "A description of the scope and nature of the plan.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HDRRecommendations.carePlan.planPeriod",
        "path" : "HDRRecommendations.carePlan.planPeriod",
        "short" : "A.2.9.1.4 - Plan Period",
        "definition" : "Indicates when the plan did (or is intended to) come into effect and end.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "HDRRecommendations.carePlan.details",
        "path" : "HDRRecommendations.carePlan.details",
        "short" : "A.2.9.1.5 - Other details",
        "definition" : "Other structured and coded details, care team, goals to be achieved.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRRecommendations.carePlan.activity",
        "path" : "HDRRecommendations.carePlan.activity",
        "short" : "A.2.9.1.6 - Activity",
        "definition" : "Actions to occur as part of the plan.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRRecommendations.carePlan.activity.kind",
        "path" : "HDRRecommendations.carePlan.activity.kind",
        "short" : "A.2.9.1.6.1 - Kind",
        "definition" : "A description of the type of care plan activity. For example, a MedicationRequest, a ServiceRequest, or a CommunicationRequest.",
        "comment" : "hl7:resource-types",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRRecommendations.carePlan.activity.description",
        "path" : "HDRRecommendations.carePlan.activity.description",
        "short" : "A.2.9.1.6.2 - Activity description",
        "definition" : "A detailed description of the activity.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HDRRecommendations.carePlan.activity.attribute",
        "path" : "HDRRecommendations.carePlan.activity.attribute",
        "short" : "A.2.9.1.6.3 - Specific attributes",
        "definition" : "Specific structured attributes per each activity type expressed by the Activity kind element, E.g., specific attributes for prescription request, appointment, etc.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRRecommendations.medicationSummary",
        "path" : "HDRRecommendations.medicationSummary",
        "short" : "A.2.9.2 - Medication summary",
        "definition" : "Summary information on the medication recommended for the period after discharge, indicating whether the medication is changed or newly started. Compared to previous practices, the overview is supplemented with medication that has been discontinued.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRRecommendations.medicationSummary.reason",
        "path" : "HDRRecommendations.medicationSummary.reason",
        "short" : "A.2.9.2.1 - Medication reason",
        "definition" : "The reason why the medication is or was prescribed or used. It provides a link to the Past or current health condition(s) or problem(s) that the patient has had or has and for which this medication was prescribed.",
        "comment" : "ICD-10*\nSNOMED CT\nOrphacode if rare disease is diagnosed",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRRecommendations.medicationSummary.changeReason",
        "path" : "HDRRecommendations.medicationSummary.changeReason",
        "short" : "A.2.9.2.2 - Reason for change",
        "definition" : "Reason for change of medication",
        "comment" : "hl7:reason-medication-status-codes",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRRecommendations.medicationSummary.productCode",
        "path" : "HDRRecommendations.medicationSummary.productCode",
        "short" : "A.2.9.2.3 - Code",
        "definition" : "Product code.",
        "comment" : "IDMP",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRRecommendations.medicationSummary.productName",
        "path" : "HDRRecommendations.medicationSummary.productName",
        "short" : "A.2.9.2.4 - Brand name",
        "definition" : "Brand name if biological medicinal product or when justified by the health professional (ref. Commission Directive 2012/52/EU)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HDRRecommendations.medicationSummary.activeIngredient",
        "path" : "HDRRecommendations.medicationSummary.activeIngredient",
        "short" : "A.2.9.2.5 - Active ingredient list",
        "definition" : "Substance that alone or in combination with one or more other ingredients produces the intended activity of a medicinal product. Example: \\\"paracetamol\\\" ",
        "comment" : "ATC (IDMP / EMA SPOR SMS)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRRecommendations.medicationSummary.strength",
        "path" : "HDRRecommendations.medicationSummary.strength",
        "short" : "A.2.9.2.6 - Strength",
        "definition" : "The content of the active ingredient expressed quantifiably per dosage unit, per unit of volume or per unit of weight, according to the pharmaceutical dose form. Example: 500 mg per tablet",
        "comment" : "UCUM\nEDQM Standard terms",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Ratio"
          }
        ]
      },
      {
        "id" : "HDRRecommendations.medicationSummary.doseForm",
        "path" : "HDRRecommendations.medicationSummary.doseForm",
        "short" : "A.2.9.2.7 - Pharmaceutical dose form",
        "definition" : "The form in which a pharmaceutical product is presented in the medicinal product package (e.g. tablet, syrup)",
        "comment" : "EDQM Standard terms",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRRecommendations.medicationSummary.dosageRegimen",
        "path" : "HDRRecommendations.medicationSummary.dosageRegimen",
        "short" : "A.2.9.2.8 - Dosage Regimen",
        "definition" : "Number of units per intake and frequency of intake over a specified duration of time.\nExample: 1 tablet every 24h, for 10 days",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRRecommendations.medicationSummary.route",
        "path" : "HDRRecommendations.medicationSummary.route",
        "short" : "A.2.9.2.9 - Route of administration",
        "definition" : "Path by which the pharmaceutical product is taken into or makes contact with the body.",
        "comment" : "EDQM Standard terms",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRRecommendations.medicationSummary.period",
        "path" : "HDRRecommendations.medicationSummary.period",
        "short" : "A.2.9.2.10 - Period of treatment",
        "definition" : "The interval of time during which it is being asserted that the patient is/was/will be taking the medication (or was not taking).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "HDRRecommendations.medicationSummary.daysSupplied",
        "path" : "HDRRecommendations.medicationSummary.daysSupplied",
        "short" : "A.2.9.2.11 - Days supplied",
        "definition" : "Number of days for which the patient was provided with the drug. Supply is intended to either hand over the medicine or write out a prescription. A 0 value indicates that the patient has not been provided with the drug (e.g. if the patient has a sufficient supply of the drug)",
        "comment" : "UCUM",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRRecommendations.Recommendations",
        "path" : "HDRRecommendations.Recommendations",
        "short" : "A.2.9.3 - Other recommendations",
        "definition" : "Other recommendations (advice) after discharge. Multiple recommendations could be provided. E.g., recommendation to suggest hip replacement, reduce number of cigarettes, stop smoking, increase physical exercises, etc.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
