# A.2.4 - Admission evaluation (eHN) - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.2.4 - Admission evaluation (eHN)**

## Logical Model: A.2.4 - Admission evaluation (eHN) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HDRAdmissionEvaluation | *Version*:0.1.0 |
| Draft as of 2025-10-10 | *Computable Name*:HdrEHNAdmissionEvaluation |
| **Copyright/Legal**: Used by permission of the XpanDH project, all rights reserved Creative Commons License | |

 
Hospital Discharge Report - Admission evaluation - A.2.4 eHN Maturity Level: 0 Draft 

**Usages:**

* Use this Logical Model: [A - Hospital Discharge Report (eHN)](StructureDefinition-HospitalDischargeReport.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.xpandh.hdr|current/StructureDefinition/HDRAdmissionEvaluation)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-HDRAdmissionEvaluation.csv), [Excel](StructureDefinition-HDRAdmissionEvaluation.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "HDRAdmissionEvaluation",
  "url" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HDRAdmissionEvaluation",
  "version" : "0.1.0",
  "name" : "HdrEHNAdmissionEvaluation",
  "title" : "A.2.4 - Admission evaluation (eHN)",
  "status" : "draft",
  "date" : "2025-10-10T16:32:47+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "Hospital Discharge Report - Admission evaluation - A.2.4 eHN\nMaturity Level: 0 Draft",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of the XpanDH project, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/HDRAdmissionEvaluation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "HDRAdmissionEvaluation",
        "path" : "HDRAdmissionEvaluation",
        "short" : "A.2.4 - Admission evaluation (eHN)",
        "definition" : "Hospital Discharge Report - Admission evaluation - A.2.4 eHN\nMaturity Level: 0 Draft"
      },
      {
        "id" : "HDRAdmissionEvaluation.objectiveFindings",
        "path" : "HDRAdmissionEvaluation.objectiveFindings",
        "short" : "A.2.4.1 - Objective findings",
        "definition" : "Objective findings",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRAdmissionEvaluation.objectiveFindings.date",
        "path" : "HDRAdmissionEvaluation.objectiveFindings.date",
        "short" : "A.2.4.1.1 - Date and time",
        "definition" : "Date and time of the examination",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "HDRAdmissionEvaluation.objectiveFindings.anthropometricObservations",
        "path" : "HDRAdmissionEvaluation.objectiveFindings.anthropometricObservations",
        "short" : "A.2.4.1.3 - Anthropometric observations",
        "definition" : "Observation of Body weight and height of the patient, BMI, circumference of head, waist, hip, limbs and skin fold thickness.\nResult of the observation includes text, numeric and coded results of the measurement including measurement units. Multiple observations could be provided.\t",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRAdmissionEvaluation.objectiveFindings.anthropometricObservations.details",
        "path" : "HDRAdmissionEvaluation.objectiveFindings.anthropometricObservations.details",
        "short" : "A.2.4.1.3.1 - Observation details",
        "definition" : "Observation details include code that identifies observation, specification of the observed body structure or specimen, date and time of the specimen collection, observation method or protocol used and other aspects of the observation..",
        "comment" : "SNOMED CT\nLOINC",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRAdmissionEvaluation.objectiveFindings.anthropometricObservations.result",
        "path" : "HDRAdmissionEvaluation.objectiveFindings.anthropometricObservations.result",
        "short" : "A.2.4.1.3.2 - Observation result",
        "definition" : "Result of the observation including numeric and coded results of the measurement, details about how the tests were done to get the result values, information about reference ranges and result interpretation. Content of the observation result will vary according to the type of the observation.",
        "comment" : "UCUM (for units of measurement)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRAdmissionEvaluation.objectiveFindings.vitalSigns",
        "path" : "HDRAdmissionEvaluation.objectiveFindings.vitalSigns",
        "short" : "A.2.4.1.4 - Vital signs",
        "definition" : "Vital signs observation:",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRAdmissionEvaluation.objectiveFindings.vitalSigns.description",
        "path" : "HDRAdmissionEvaluation.objectiveFindings.vitalSigns.description",
        "short" : "A.2.4.1.4.1 - Result description",
        "definition" : "Narrative representation of the observation result and findings.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HDRAdmissionEvaluation.objectiveFindings.vitalSigns.details",
        "path" : "HDRAdmissionEvaluation.objectiveFindings.vitalSigns.details",
        "short" : "A.2.4.1.4.2 - Observation details",
        "definition" : "Observation details include code that identifies observation, specification of the observed body structure or specimen, date and time of the specimen collection, observation method or protocol used and other aspects of the observation.",
        "comment" : "SNOMED CT\nLOINC",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRAdmissionEvaluation.objectiveFindings.vitalSigns.result",
        "path" : "HDRAdmissionEvaluation.objectiveFindings.vitalSigns.result",
        "short" : "A.2.4.1.4.3 - Observation result",
        "definition" : "Result of the observation including numeric and coded results of the measurement, details about how the tests were done to get the result values, information about reference ranges and result interpretation. Content of the observation result will vary according to the type of the observation.",
        "comment" : "UCUM (measurement units)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRAdmissionEvaluation.objectiveFindings.physicalExamination",
        "path" : "HDRAdmissionEvaluation.objectiveFindings.physicalExamination",
        "short" : "A.2.4.1.5 - Physical examination",
        "definition" : "Physical examination is the process of evaluating objective anatomical findings. It is typically the first diagnostic measure performed after taking the patient's history, which allows an initial assessment of symptoms and is useful for determining the differential diagnoses and further steps. Physical examination can be performed through observation, palpation, percussion, and auscultation.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRAdmissionEvaluation.objectiveFindings.physicalExamination.note",
        "path" : "HDRAdmissionEvaluation.objectiveFindings.physicalExamination.note",
        "short" : "A.2.4.1.5.1 - Observation Note",
        "definition" : "A narrative description of the observation. It should be structured by the organ system (e.g. head, neck, body, arms, ...)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HDRAdmissionEvaluation.functionalStatus",
        "path" : "HDRAdmissionEvaluation.functionalStatus",
        "short" : "A.2.4.2 - Functional status",
        "definition" : "Functional status",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "HDRAdmissionEvaluation.functionalStatus.description",
        "path" : "HDRAdmissionEvaluation.functionalStatus.description",
        "short" : "A.2.4.2.1 - Description",
        "definition" : "Need for the patient to be continuously assessed by third parties; functional status may influence decisions about how to plan and administer treatments",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HDRAdmissionEvaluation.functionalStatus.onsetDate",
        "path" : "HDRAdmissionEvaluation.functionalStatus.onsetDate",
        "short" : "A.2.4.2.2 - Onset Date",
        "definition" : "Onset date of a condition",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "HDRAdmissionEvaluation.functionalStatus.assessmentType",
        "path" : "HDRAdmissionEvaluation.functionalStatus.assessmentType",
        "short" : "A.2.4.2.3 - Functional assessment description",
        "definition" : "Description of the functional assessment",
        "comment" : "ICF",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HDRAdmissionEvaluation.functionalStatus.assessmentDate",
        "path" : "HDRAdmissionEvaluation.functionalStatus.assessmentDate",
        "short" : "A.2.4.2.4 - Functional assessment date",
        "definition" : "Date of the functional assessment ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "HDRAdmissionEvaluation.functionalStatus.assessmentResult",
        "path" : "HDRAdmissionEvaluation.functionalStatus.assessmentResult",
        "short" : "A.2.4.2.5 - Functional assessment result",
        "definition" : "Functional assessment result value",
        "comment" : "ICF",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      }
    ]
  }
}

```
