# Bundle: EU Hospital Discharge Report - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Bundle: EU Hospital Discharge Report**

## Resource Profile: Bundle: EU Hospital Discharge Report 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Bundle-hdr-xpandh | *Version*:0.1.0 |
| Draft as of 2025-10-10 | *Computable Name*:BundleHdrXpandh |
| **Copyright/Legal**: XpanDH Project | |

 
Clinical document used to represent a Hospital Discharge Report for the scope of the XpanDH project. 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.xpandh.hdr|current/StructureDefinition/Bundle-hdr-xpandh)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Bundle-hdr-xpandh.csv), [Excel](StructureDefinition-Bundle-hdr-xpandh.xlsx), [Schematron](StructureDefinition-Bundle-hdr-xpandh.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Bundle-hdr-xpandh",
  "url" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Bundle-hdr-xpandh",
  "version" : "0.1.0",
  "name" : "BundleHdrXpandh",
  "title" : "Bundle: EU Hospital Discharge Report",
  "status" : "draft",
  "date" : "2025-10-10T16:32:47+00:00",
  "publisher" : "XpanDH Project",
  "contact" : [
    {
      "name" : "XpanDH Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xpandh-project.iscte-iul.pt"
        }
      ]
    }
  ],
  "description" : "Clinical document used to represent a Hospital Discharge Report for the scope of the XpanDH project.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "XpanDH Project",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Bundle",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Bundle",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Bundle",
        "path" : "Bundle",
        "short" : "Hospital Discharge Report bundle",
        "definition" : "Hospital Discharge Report bundle.",
        "constraint" : [
          {
            "key" : "bdl-ips-1",
            "severity" : "error",
            "human" : "An IPS document must have no additional Composition (including Composition subclass) resources besides the first.",
            "expression" : "entry.tail().where(resource is Composition).empty()",
            "source" : "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Bundle-hdr-xpandh"
          }
        ]
      },
      {
        "id" : "Bundle.identifier",
        "path" : "Bundle.identifier",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Bundle.type",
        "path" : "Bundle.type",
        "fixedCode" : "document"
      },
      {
        "id" : "Bundle.timestamp",
        "path" : "Bundle.timestamp",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Bundle.link",
        "path" : "Bundle.link",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry",
        "path" : "Bundle.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resource"
            },
            {
              "type" : "profile",
              "path" : "resource"
            }
          ],
          "rules" : "open"
        },
        "short" : "Entry resource in the Hospital Discharge Report bundle",
        "definition" : "An entry resource included in the Hospital Discharge Report document bundle resource.",
        "comment" : "Must contain the HDR Composition as the first entry (only a single Composition resource instance may be included).  Additional constraints are specified in the HDR Composition profile.",
        "min" : 2,
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry.fullUrl",
        "path" : "Bundle.entry.fullUrl",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry.search",
        "path" : "Bundle.entry.search",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry.request",
        "path" : "Bundle.entry.request",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry.response",
        "path" : "Bundle.entry.response",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry:composition",
        "path" : "Bundle.entry",
        "sliceName" : "composition",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Bundle.entry:composition.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Composition",
            "profile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Composition-hdr-eu-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:patient",
        "path" : "Bundle.entry",
        "sliceName" : "patient",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Bundle.entry:patient.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Patient",
            "profile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Patient-eu-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:allergyintolerance",
        "path" : "Bundle.entry",
        "sliceName" : "allergyintolerance",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:allergyintolerance.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "AllergyIntolerance",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/AllergyIntolerance-uv-ips"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:condition",
        "path" : "Bundle.entry",
        "sliceName" : "condition",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:condition.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Condition",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips",
              "http://hl7.org/fhir/StructureDefinition/Condition"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:device",
        "path" : "Bundle.entry",
        "sliceName" : "device",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:device.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Device"
          }
        ]
      },
      {
        "id" : "Bundle.entry:deviceusestatement",
        "path" : "Bundle.entry",
        "sliceName" : "deviceusestatement",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:deviceusestatement.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "DeviceUseStatement",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/DeviceUseStatement-uv-ips"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:diagnosticreport",
        "path" : "Bundle.entry",
        "sliceName" : "diagnosticreport",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:diagnosticreport.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "DiagnosticReport",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/DiagnosticReport-uv-ips"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:imagingstudy",
        "path" : "Bundle.entry",
        "sliceName" : "imagingstudy",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:imagingstudy.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "ImagingStudy",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/ImagingStudy-uv-ips"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:immunization",
        "path" : "Bundle.entry",
        "sliceName" : "immunization",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:immunization.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Immunization",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/Immunization-uv-ips"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:media",
        "path" : "Bundle.entry",
        "sliceName" : "media",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:media.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Media",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/Media-observation-uv-ips"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:medication",
        "path" : "Bundle.entry",
        "sliceName" : "medication",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:medication.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Medication",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:medicationrequest",
        "path" : "Bundle.entry",
        "sliceName" : "medicationrequest",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:medicationrequest.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "MedicationRequest",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationRequest-uv-ips"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:medicationstatement",
        "path" : "Bundle.entry",
        "sliceName" : "medicationstatement",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:medicationstatement.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "MedicationStatement",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:practitioner",
        "path" : "Bundle.entry",
        "sliceName" : "practitioner",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:practitioner.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Practitioner",
            "profile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Practitioner-eu-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:practitionerrole",
        "path" : "Bundle.entry",
        "sliceName" : "practitionerrole",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:practitionerrole.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "PractitionerRole",
            "profile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/PractitionerRole-eu-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:procedure",
        "path" : "Bundle.entry",
        "sliceName" : "procedure",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:procedure.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Procedure",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/Procedure-uv-ips"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:organization",
        "path" : "Bundle.entry",
        "sliceName" : "organization",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:organization.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Organization",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/Organization-uv-ips"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:observation-pregnancy-edd",
        "path" : "Bundle.entry",
        "sliceName" : "observation-pregnancy-edd",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:observation-pregnancy-edd.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Observation",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/Observation-pregnancy-edd-uv-ips"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:observation-pregnancy-outcome",
        "path" : "Bundle.entry",
        "sliceName" : "observation-pregnancy-outcome",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:observation-pregnancy-outcome.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Observation",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/Observation-pregnancy-outcome-uv-ips"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:observation-pregnancy-status",
        "path" : "Bundle.entry",
        "sliceName" : "observation-pregnancy-status",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:observation-pregnancy-status.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Observation",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/Observation-pregnancy-status-uv-ips"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:observation-alcohol-use",
        "path" : "Bundle.entry",
        "sliceName" : "observation-alcohol-use",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:observation-alcohol-use.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Observation",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/Observation-alcoholuse-uv-ips"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:observation-tobacco-use",
        "path" : "Bundle.entry",
        "sliceName" : "observation-tobacco-use",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:observation-tobacco-use.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Observation",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/Observation-tobaccouse-uv-ips"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:observation-results",
        "path" : "Bundle.entry",
        "sliceName" : "observation-results",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:observation-results.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Observation",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/Observation-results-uv-ips"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:specimen",
        "path" : "Bundle.entry",
        "sliceName" : "specimen",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:specimen.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Specimen",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/Specimen-uv-ips"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:medicationDispense",
        "path" : "Bundle.entry",
        "sliceName" : "medicationDispense",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:medicationDispense.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "MedicationDispense"
          }
        ]
      },
      {
        "id" : "Bundle.entry:medicationAdministration",
        "path" : "Bundle.entry",
        "sliceName" : "medicationAdministration",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:medicationAdministration.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "MedicationAdministration"
          }
        ]
      },
      {
        "id" : "Bundle.entry:familyMemberHistory",
        "path" : "Bundle.entry",
        "sliceName" : "familyMemberHistory",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:familyMemberHistory.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "FamilyMemberHistory"
          }
        ]
      },
      {
        "id" : "Bundle.entry:documentReference",
        "path" : "Bundle.entry",
        "sliceName" : "documentReference",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:documentReference.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "DocumentReference"
          }
        ]
      },
      {
        "id" : "Bundle.entry:flag",
        "path" : "Bundle.entry",
        "sliceName" : "flag",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:flag.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1,
        "type" : [
          {
            "code" : "Flag",
            "profile" : [
              "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Flag-eu-xpandh"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.signature",
        "path" : "Bundle.signature",
        "short" : "Report Digital Signature"
      },
      {
        "id" : "Bundle.signature.type",
        "path" : "Bundle.signature.type",
        "short" : "Digital Signature Purposes"
      },
      {
        "id" : "Bundle.signature.when",
        "path" : "Bundle.signature.when",
        "short" : "When was signed"
      },
      {
        "id" : "Bundle.signature.who",
        "path" : "Bundle.signature.who",
        "short" : "Who signed."
      },
      {
        "id" : "Bundle.signature.data",
        "path" : "Bundle.signature.data",
        "short" : "Signature content"
      }
    ]
  }
}

```
