# Mracena - XpanDH Hospital Discharge Report v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Mracena**

## Example Patient: Mracena

Profile: [Patient: HDR](StructureDefinition-Patient-eu-xpandh.md)

Mračena Mrakomorová Female, DoB: 1971-11-26 ( urn:oid:1.3.158.165387.100.10.53.9#7161264528)

-------

| | |
| :--- | :--- |
| Other Id: | `https://ncez.mzcr.cz/standards/fhir/sid/rid`/456789123 |
| Contact Detail | * [+421 603 853 227](tel:+421603853227)
* Hlavná ulica 156, Velké mesto(home)
 |
| Languages: | * Slovak (preferred)
* English
* Hungarian
 |
| matka: | * Biologická Matka Mrakomorová 
* [+421 604 123 456](tel:+421604123456)
 |
| priateľ/priateľka: | * Alena Priateľková 
* Horná ulica 18, 123 45, Trenčín, Slovensko(home)
* [+421 601 111 111](tel:+421601111111)
 |
| Links: | * General Practitioner: MUDr. Josef Švejk (Identifier: `https://ncez.mzcr.cz/standards/fhir/sid/nrzp`/123456789)
 |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "Mracena",
  "meta" : {
    "profile" : [
      "http://hl7.eu/fhir/ig/xpandh/hdr/StructureDefinition/Patient-eu-xpandh"
    ]
  },
  "identifier" : [
    {
      "system" : "urn:oid:1.3.158.165387.100.10.53.9",
      "value" : "7161264528"
    },
    {
      "system" : "https://ncez.mzcr.cz/standards/fhir/sid/rid",
      "value" : "456789123"
    }
  ],
  "name" : [
    {
      "use" : "usual",
      "family" : "Mrakomorová",
      "given" : ["Mračena"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "+421 603 853 227",
      "use" : "home"
    }
  ],
  "gender" : "female",
  "birthDate" : "1971-11-26",
  "address" : [
    {
      "use" : "home",
      "type" : "physical",
      "text" : "Hlavná ulica 156, Velké mesto",
      "line" : ["Hlavná ulica 156"],
      "_line" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
              "valueString" : "18"
            }
          ]
        }
      ],
      "city" : "Velké mesto",
      "postalCode" : "81101",
      "country" : "SK"
    }
  ],
  "contact" : [
    {
      "relationship" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
              "code" : "MTH",
              "display" : "matka"
            },
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v2-0131",
              "code" : "N",
              "display" : "príbuzný"
            }
          ]
        }
      ],
      "name" : {
        "use" : "usual",
        "family" : "Mrakomorová",
        "given" : ["Biologická", "Matka"]
      },
      "telecom" : [
        {
          "system" : "phone",
          "value" : "+421 604 123 456",
          "use" : "mobile"
        }
      ]
    },
    {
      "relationship" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
              "code" : "FRND",
              "display" : "priateľ/priateľka"
            },
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v2-0131",
              "code" : "C",
              "display" : "Emergentný kontakt"
            }
          ]
        }
      ],
      "name" : {
        "use" : "usual",
        "family" : "Priateľková",
        "given" : ["Alena"]
      },
      "telecom" : [
        {
          "system" : "phone",
          "value" : "+421 601 111 111",
          "use" : "home"
        }
      ],
      "address" : {
        "use" : "home",
        "type" : "physical",
        "text" : "Horná ulica 18, 123 45, Trenčín, Slovensko",
        "line" : ["Horná ulica 18"],
        "city" : "Trenčín",
        "postalCode" : "123 45",
        "country" : "SK"
      }
    }
  ],
  "communication" : [
    {
      "language" : {
        "coding" : [
          {
            "system" : "urn:ietf:bcp:47",
            "code" : "sk"
          }
        ]
      },
      "preferred" : true
    },
    {
      "language" : {
        "coding" : [
          {
            "system" : "urn:ietf:bcp:47",
            "code" : "en"
          }
        ]
      }
    },
    {
      "language" : {
        "coding" : [
          {
            "system" : "urn:ietf:bcp:47",
            "code" : "hu"
          }
        ]
      }
    }
  ],
  "generalPractitioner" : [
    {
      "identifier" : {
        "system" : "https://ncez.mzcr.cz/standards/fhir/sid/nrzp",
        "value" : "123456789"
      },
      "display" : "MUDr. Josef Švejk"
    }
  ]
}

```
