# Yellow Button related Tools - xShare Project Yellow Button v0.2.0-ci-build

* [**Table of Contents**](toc.md)
* **Yellow Button related Tools**

## Yellow Button related Tools

### xShare Yellow Button Toolbox

The governance of xShare tools and assets is designed to ensure that the developed artifacts are not only technically robust but also accessible for organizations interested in adopting the xShare Yellow Button.

To facilitate this adoption, all artifacts, while remaining on GitHub to support development, will be linked by the x-bundle registry.

The registry acts as a comprehensive catalogue of modular components specified within WP2, enhancing accessibility and guiding implementers through the adoption and integration process.

A first list of tools is reported in the [x-Bundle regstry](https://x-bundles.ehr-exchange-format.eu/yb-tool/tools.html)

This includes among the others

#### HL7 FHIR Mapping language tools ( CDA2FHIR )

The capability of transforming HL7 CDA instances, currently used in the MyHealth@EU infrastructure for the Patient Summary and the ePrescription, into HL7 FHIR-compliant resources, adopted by the EEHRxF and for the MyHealth@EU new services, is a common requirement.

While several different technologies may be used for this purpose, HL7 FHIR Mapping language is one of the frequently adopted.

There are several open libraries or servivces that can be used and examples of CDA to FHIR maps.

A first list is provided in the [HL7 FHIR Mapping Language tools X-Bundle](https://x-bundles.ehr-exchange-format.eu/fml-tool/tools.html)

#### Smart Health Links

[Smart Health Links](https://build.fhir.org/ig/HL7/smart-health-cards-and-links/) (SHL) provide a streamlined, secure way to share personal health information through easily accessible links. These links facilitate patient-centred data exchange by allowing individuals to grant access to selected health data securely and efficiently across various healthcare systems and applications. The SHL framework is built on interoperability standards that ensure health information can be shared and accessed consistently across platforms, supporting scenarios from clinical care to personal health management.

* an SHL overview is provided in the [SHL Introduction](https://docs.smarthealthit.org/smart-health-links/) site
* Some reference [SHL Source Code](https://github.com/jmandel/vaxx.link) is available in GitHub.

#### xShare toolbox GitHub

A GitHub repository ([xShare GitHub](https://github.com/xSHARE-project-eu)) have been established and maintained to support collaborative development and version control for all technical assets related to the technical assets that were developed to support xShare toolbox. These repositories serve as a central hub for code management, issue tracking, and collaborative problem-solving among the involved partners and others, as the reference code is open source and publicly available to the community. Regular updates, thorough documentation, and structured branching strategies ensure that all modifications are transparent and traceable. This collaborative environment fosters innovation and ensures that all partners can contribute effectively to developing and maintaining the project's technical components. It also supports the continuity of other projects or endeavours, thereby enhancing these technical assets to improve their functionality and impact.

#### HL7 FHIR Validators

HL7 FHIR validator allow users to verify FHIR resources conform to the HL7 FHIR standards and to specified profiles.

An overview of how the FHIR specification supports validation of resources is provided in the HL7 FHIR standard [Validating Resources](https://build.fhir.org/validation) page.

An initial list of related tools is listed in the [Validation and testing tools X-Bundle](https://x-bundles.ehr-exchange-format.eu/test-tool/tools.html)

#### EEHRxF Sandboxes

There are several HL7 FHIR public servers that can be used as HL7 FHIR sandboxes. A first list is provided in the HL7 Confluence page [Public Test Servers](https://confluence.hl7.org/spaces/FHIR/pages/35718859/Public+Test+Servers)

In the [HL7 Europe Sandbox](https://sandbox.hl7europe.eu/) a set of links to HAPI based HL7 FHIR Servers customized for supporting some relevant published European FHIR IG is provided.

