# Home - xShare Project Yellow Button v0.2.0-ci-build

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xshare-yb/ImplementationGuide/hl7.eu.fhir.xshare-yb | *Version*:0.2.0-ci-build |
| Active as of 2025-10-14 | *Computable Name*:XshareYbIg |

> This specification is subject to continuous maintenance.Revisions and extensions may be introduced over time, including updates to the business scenarios and to the reference technical specification.**Readers should be aware that changes may occur and are encouraged to stay informed about the latest developments.**

### Scope

 This guide provides instructions to help you understand, implement, conform to, and label your product in accordance with the **xShare Yellow Button**. 

 More contextual information about the xShare Yellow Button, including tools and supporting material can be found at the [X-Bundle Registry](https://x-bundles.ehr-exchange-format.eu/usecases/usecases.html). 

### Purpose

The **xShare Yellow Button is a simple way to share your data with a single click**.

This guide explains how to understand, implement, and conform to the xShare Yellow Button specification.

It is intended for developers, implementers, and testers of systems that use the xShare Yellow Button.

The xShare Yellow Button enables natural persons to share their health data in European Electronic Health Record Exchange Format (EEHRxF) by offering three main capabilities:

* The download of their health data
* The health data sharing by using a one-time link
* The health data sharing by using a link valid for a period of time

This version of the xShare Yellow Button specification focuses on the first two features.

In the following paragraphs you will find the information you need to

*  [get started with the xShare Yellow Button](#get-started) 
*  [get more from this specification.](#get-more) 

### Get Started

New readers are encouraged to begin with the one page xShare Yellow Button "get started" pages explaining in a simple and concise way what do you need to do to implement and prove conformance to this guide:

*  [Get Started with the xShare Yellow Button Download](get-started-down.md) 
*  [Get Started with the xShare Yellow Button One-time share](get-started-share.md) 

### Understand this Guide

Readers that would like to get more from this specifications are encouraged to familiarize themselves with how information is organized in this guide.

The information in this guide is structured according to the BDAT model (Business, Data, Application, and Technology), as illustrated in the figure below.

Fig. 1: Navigating this guide

Where: 

* The[**business domain**](business.md)describes the business goals, processes and rules the xShare Yellow Button is referring to.


  It substantially describes why, how and where to use the xShare Yellow Button, from a users perspective.
*  The[**data domain**](content.md)describes the data model and the data exchange format. 
*  The [**application domain**](application.md) describes - in a implementation indipendent form - what are the (software) components involved and how they interact, collaborate, or are coordinated. It also provides an overview of the system architecture. 
* The [**technology domain**](technical.md) describes the technology stack and the infrastructure required to support the xShare Yellow Button. This includes technical standards, specifications, and security considerations.


  This is where implemantable specifications are described.

