# Artifacts Summary - xShare Project Yellow Button v0.2.0-ci-build

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Requirements: Actor Definitions 

The following artifacts define the types of individuals and/or systems that will interact as part of the use cases covered by this implementation guide.

| | |
| :--- | :--- |
| [xShare Yellow Button Consumer](ActorDefinition-actorDefinition-yb-consumer.md) | An actor that consumes FHIR Document Bundles obtained via download or Smart Health Links, as defined in the xShare Yellow Button Guide.The xShare Yellow Button Consumer shall be able to act as:* xShare Yellow Button Content Consumer, always
* xShare Yellow Button Link Consumer, if the One-time Share option is supported
* xShare Yellow Button Manifest Consumer, if the One-time Share option is supported
 |
| [xShare Yellow Button Provider](ActorDefinition-actorDefinition-yb-provider.md) | An actor that produces HL7 FHIR Document Bundles that can be downloaded or shared using Smart Health Links, as defined in the xShare Yellow Button Guide.The xShare Yellow Button Provider shall act:* always as xShare Yellow Button Content Creator,
* if the One-time Share option is supported, 
* as xShare Yellow Button Link Provider,
* as xShare Yellow Button Manifest Provider.
 
 |

### Behavior: Capability Statements 

The following artifacts define the specific capabilities that different types of systems are expected to have in order to comply with this implementation guide. Systems conforming to this implementation guide are expected to declare conformance to one or more of the following capability statements.

| | |
| :--- | :--- |
| [xShare Yellow Button Consumer Capability Statement](CapabilityStatement-capabilityStatement-yb-consumer.md) | Defines the capabilities of an xShare Yellow Button Consumer, which can retrieve and interpret FHIR Document Bundles obtained via download or Smart Health Links. |
| [xShare Yellow Button Provider Capability Statement](CapabilityStatement-capabilityStatement-yb-provider.md) | Defines the capabilities of an xShare Yellow Button Provider, responsible for producing FHIR Document Bundles for download or sharing via Smart Health Links. |

