# xShare Yellow Button Components - xShare Project Yellow Button v0.2.0-ci-build

* [**Table of Contents**](toc.md)
* **xShare Yellow Button Components**

## xShare Yellow Button Components

This page describes the roles (actors in the IHE world) that a conformant Yellow Button implementation can realize.

### Overview

Yellow Button implementers can claim conformance to the yellow button by implementing one of both of these components (actors):

* The **xShare Yellow Button Provider**
* The **xShare Yellow Button Consumer**

| | | |
| :--- | :--- | :--- |
| 📤 | [xShare YB Actor: Provider](ActorDefinition-actorDefinition-yb-provider.md) | [xShare YB Capability Statement: Provider](CapabilityStatement-capabilityStatement-yb-provider.md) |
| 📥 | [xShare YB Actor: Consumer](ActorDefinition-actorDefinition-yb-consumer.md) | [xShare YB Capability Statement: Consumer](CapabilityStatement-capabilityStatement-yb-consumer.md) |

The **xShare Yellow Button Provider** shall act:

* always as [xShare Yellow Button Content Creator](actors.md#xshare-yellow-button-content-creator),
* as [xShare Yellow Button Link Provider](actors.md#xshare-yellow-button-link-provider), if the One-time Share option is supported
* as xShare Yellow Button Manifest Provider, if the One-time Share option is supported

The **xShare Yellow Button Consumer** shall be able to act as:

* [xShare Yellow Button Content Consumer](actors.md#xshare-yellow-button-content-consumer), always
* [xShare Yellow Button Link Consumer](actors.md#xshare-yellow-button-link-consumer), if the One-time Share option is supported
* xShare Yellow Button Manifest Consumer, if the One-time Share option is supported

In the following paragraphs is provoded a grafical representation of the described roles for the:

* [General case](#yellow-button) (Yellow button)
* [Download](#download)
* [One-time Share](#one-time-share)

#### Yellow Button

#### Download

#### One-time Share

### xShare Yellow Button Content Creator

A Yellow Button implementation realizing the **xShare Yellow Button Provider** SHALL always act as [xShare Yellow Button Content Creator](actors.md#xshare-yellow-button-content-creator).

#### Conformance

**xShare Yellow Button Content Creator** shall be able to provide health data conformant with at least one of the content specifications listed in the [Yellow Button Information view](content.md) page.

### xShare Yellow Button Content Consumer

A Yellow Button implementation realizing the **xShare Yellow Button Consumer** SHALL always act as [xShare Yellow Button Content Consumer](actors.md#xshare-yellow-button-content-consumer).

#### Conformance

**xShare Yellow Button Content Consumer** shall be able to consume health data conformant with at least one of the content specifications listed in the [Yellow Button Information view](content.md) page.

### xShare Yellow Button Link Provider

A Yellow Button implementation realizing the **xShare Yellow Button Provider** SHALL always act as [xShare Yellow Button Link Provider](actors.md#xshare-yellow-button-link-provider), when the **One-time Share** feature is supported.

The **xShare Yellow Button Link Provider** is a software that enables users to receive and access health information - as listed in the [Yellow Button Information view](content.md) page - shared through SMART Health Links.

This role specializes the [SMART Health Links Sharing Application](https://hl7.org/fhir/uv/smart-health-cards-and-links/links-specification.html#actors) actor.

#### Conformance

**xShare Yellow Button Link Provider** shall:

* be grouped with the **xShare Yellow Button Content Creator**
* conform with the [SMART Health Links Sharing Application](https://hl7.org/fhir/uv/smart-health-cards-and-links/links-specification.html#actors) actor.

### xShare Yellow Button Link Consumer

A Yellow Button implementation realizing the **xShare Yellow Button Consumer** SHALL always act as [xShare Yellow Button Link Consumer](actors.md#xshare-yellow-button-link-consumer), when the **One-time Share** feature is supported.

The **xShare Yellow Button Link Consumer** is a software tSoftware that enables users to receive and access health information - as listed in the [Yellow Button Information view](content.md) page - shared through SMART Health Links.

This role specializes the [SMART Health Links Receiving Application](https://hl7.org/fhir/uv/smart-health-cards-and-links/links-specification.html#actors) actor.

#### Conformance

**xShare Yellow Button Link Provider** shall:

* be grouped with the **xShare Yellow Button Content Consumer**
* conform with the [SMART Health Links Receiving Application](https://hl7.org/fhir/uv/smart-health-cards-and-links/links-specification.html#actors) actor.

