# xShare Yellow Button Provider Capability Statement - xShare Project Yellow Button v0.2.0-ci-build

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **xShare Yellow Button Provider Capability Statement**

## CapabilityStatement: xShare Yellow Button Provider Capability Statement 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/xshare-yb/CapabilityStatement/capabilityStatement-yb-provider | *Version*:0.2.0-ci-build |
| Draft as of 2025-04-01 | *Computable Name*:CapabilityStatementXshareYBProvider |

 
Defines the capabilities of an xShare Yellow Button Provider, responsible for producing FHIR Document Bundles for download or sharing via Smart Health Links. 

 [Raw OpenAPI-Swagger Definition file](capabilityStatement-yb-provider.openapi.json) | [Download](capabilityStatement-yb-provider.openapi.json) 

## xShare Yellow Button Provider Capability Statement

* Implementation Guide Version: 0.2.0-ci-build 
* FHIR Version: 4.0.1 
* Supported Formats: `json`, `xml`
* Published on: 2025-04-01 
* Published by: xShare Project 

> **Note to Implementers: FHIR Capabilities**Any FHIR capability may be 'allowed' by the system unless explicitly marked as 'SHALL NOT'. A few items are marked as MAY in the Implementation Guide to highlight their potential relevance to the use case.

### SHALL Support the Following Implementation Guides

* [http://hl7.eu/fhir/laboratory/ImplementationGuide/hl7.fhir.eu.laboratory](http://hl7.eu/fhir/laboratory/0.1.1/index.html)
* [http://hl7.org/fhir/uv/ips/ImplementationGuide/hl7.fhir.uv.ips](http://hl7.org/fhir/uv/ips/STU2/index.html)
* [http://hl7.org/fhir/uv/smart-health-cards-and-links/ImplementationGuide/hl7.fhir.uv.smart-health-cards-and-links](http://hl7.org/fhir/uv/smart-health-cards-and-links/STU1/index.html)
* [http://fhir.ehdsi.eu/laboratory/ImplementationGuide/myhealth.eu.fhir.laboratory](http://fhir.ehdsi.eu/laboratory/0.1.1/index.html)

## FHIR Document Capabilities

| | | |
| :--- | :--- | :--- |
| producer | [Bundle: Laboratory Report](http://hl7.eu/fhir/laboratory/0.1.1/StructureDefinition-Bundle-eu-lab.html) | The provider can publish EU Laboratory Report documents via download or Smart Health Link. |
| producer | [Bundle (IPS)](http://hl7.org/fhir/uv/ips/STU2/StructureDefinition-Bundle-uv-ips.html) | The provider can publish IPS documents via download or Smart Health Link. |
| producer | [Bundle: Laboratory](http://fhir.ehdsi.eu/laboratory/0.1.1/StructureDefinition-Bundle-lab-myhealtheu.html) | The provider can publish MyHealth@EU lab reports via download or Smart Health Link. |



## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "capabilityStatement-yb-provider",
  "url" : "http://hl7.eu/fhir/ig/xshare-yb/CapabilityStatement/capabilityStatement-yb-provider",
  "version" : "0.2.0-ci-build",
  "name" : "CapabilityStatementXshareYBProvider",
  "title" : "xShare Yellow Button Provider Capability Statement",
  "status" : "draft",
  "date" : "2025-04-01",
  "publisher" : "xShare Project",
  "contact" : [
    {
      "name" : "xShare Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://xshare-project.eu/"
        }
      ]
    }
  ],
  "description" : "Defines the capabilities of an xShare Yellow Button Provider, responsible for producing FHIR Document Bundles for download or sharing via Smart Health Links.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "kind" : "requirements",
  "fhirVersion" : "4.0.1",
  "format" : ["json", "xml"],
  "implementationGuide" : [
    "http://hl7.eu/fhir/laboratory/ImplementationGuide/hl7.fhir.eu.laboratory",
    "http://hl7.org/fhir/uv/ips/ImplementationGuide/hl7.fhir.uv.ips",
    "http://hl7.org/fhir/uv/smart-health-cards-and-links/ImplementationGuide/hl7.fhir.uv.smart-health-cards-and-links",
    "http://fhir.ehdsi.eu/laboratory/ImplementationGuide/myhealth.eu.fhir.laboratory"
  ],
  "document" : [
    {
      "mode" : "producer",
      "documentation" : "The provider can publish EU Laboratory Report documents via download or Smart Health Link.",
      "profile" : "http://hl7.eu/fhir/laboratory/StructureDefinition/Bundle-eu-lab"
    },
    {
      "mode" : "producer",
      "documentation" : "The provider can publish IPS documents via download or Smart Health Link.",
      "profile" : "http://hl7.org/fhir/uv/ips/StructureDefinition/Bundle-uv-ips"
    },
    {
      "mode" : "producer",
      "documentation" : "The provider can publish MyHealth@EU lab reports via download or Smart Health Link.",
      "profile" : "http://fhir.ehdsi.eu/laboratory/StructureDefinition/Bundle-lab-myhealtheu"
    }
  ]
}

```
