# Resource actorDefinition-yb-provider



## Resource Content

```json
{
  "resourceType" : "Basic",
  "id" : "actorDefinition-yb-provider",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.url",
      "valueUri" : "http://hl7.eu/fhir/ig/xshare-yb/ActorDefinition/actorDefinition-yb-provider"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.version",
      "valueString" : "0.2.0-ci-build"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.name",
      "valueString" : "ActorDefinitionYBProvider"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.title",
      "valueString" : "xShare Yellow Button Provider"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.date",
      "valueDateTime" : "2025-10-14T15:00:41+00:00"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.publisher",
      "valueString" : "xShare Project"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.contact",
      "valueContactDetail" : {
        "name" : "xShare Project",
        "telecom" : [
          {
            "system" : "url",
            "value" : "https://xshare-project.eu/"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.description",
      "valueMarkdown" : "An actor that produces HL7 FHIR Document Bundles that can be downloaded or shared using Smart Health Links, as defined in the xShare Yellow Button Guide.\n\nThe xShare Yellow Button Provider shall act:\n- always as xShare Yellow Button Content Creator,\n- if the One-time Share option is supported,\n   - as xShare Yellow Button Link Provider,\n   - as xShare Yellow Button Manifest Provider."
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.jurisdiction",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
            "code" : "150",
            "display" : "Europe"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.type",
      "valueCode" : "system"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.documentation",
      "valueMarkdown" : "The xShare Yellow Button Provider exposes clinical documents such as IPS or lab reports as FHIR Document Bundles. These can be offered via direct download or shared using Smart Health Links."
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.capabilities",
      "valueCanonical" : "http://hl7.eu/fhir/ig/xshare-yb/CapabilityStatement/capabilityStatement-yb-provider"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/fhir-types",
        "code" : "ActorDefinition"
      }
    ]
  }
}

```
