# Resource actorDefinition-yb-consumer



## Resource Content

```json
{
  "resourceType" : "Basic",
  "id" : "actorDefinition-yb-consumer",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.url",
      "valueUri" : "http://hl7.eu/fhir/ig/xshare-yb/ActorDefinition/actorDefinition-yb-consumer"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.version",
      "valueString" : "0.2.0-ci-build"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.name",
      "valueString" : "ActorDefinitionYBConsumer"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.title",
      "valueString" : "xShare Yellow Button Consumer"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.date",
      "valueDateTime" : "2025-10-14T15:00:41+00:00"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.publisher",
      "valueString" : "xShare Project"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.contact",
      "valueContactDetail" : {
        "name" : "xShare Project",
        "telecom" : [
          {
            "system" : "url",
            "value" : "https://xshare-project.eu/"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.description",
      "valueMarkdown" : "An actor that consumes FHIR Document Bundles obtained via download or Smart Health Links, as defined in the xShare Yellow Button Guide.\n\nThe xShare Yellow Button Consumer shall be able to act as:\n- xShare Yellow Button Content Consumer, always\n- xShare Yellow Button Link Consumer, if the One-time Share option is supported\n- xShare Yellow Button Manifest Consumer, if the One-time Share option is supported"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.jurisdiction",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
            "code" : "150",
            "display" : "Europe"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.type",
      "valueCode" : "system"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.documentation",
      "valueMarkdown" : "The xShare Yellow Button Consumer receives and processes clinical documents such as IPS or lab reports provided as FHIR Document Bundles, either via direct download or Smart Health Link."
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.capabilities",
      "valueCanonical" : "http://hl7.eu/fhir/ig/xshare-yb/CapabilityStatement/capabilityStatement-yb-consumer"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/fhir-types",
        "code" : "ActorDefinition"
      }
    ]
  }
}

```
