# Industry Label Certification Process - xShare Project Yellow Button v0.2.0-ci-build

* [**Table of Contents**](toc.md)
* **Industry Label Certification Process**

## Industry Label Certification Process

### Labeling Levels

The xShare Industry Label is designed to be a flexible and adaptable certification system that can be tailored to the specific needs of different stakeholders. The label is divided into three levels, each with its own set of requirements and evaluation processes. This tiered approach allows for a gradual progression from self-assessment to more rigorous third-party evaluations, ensuring that organisations can choose the level of certification that best suits their needs.

| | | |
| :--- | :--- | :--- |
| 🥉 | **Bronze**(Self-assessment by the entity) | 1. Provide a guidance document (handbook or similar) for self-declaration.2. Users access the hub's website.3. Fill in a conformance statement.4. Receive the**Bronze logo**to display on their system/website. |
| 🥈 | **Silver**(External technical evaluation incl. test trials) | 1. Develop a guidance document for external evaluation (IHE to oversee the process).2. Make the Yellow Button available for download.3. Create a test case within**Gazelle**to validate correct format.4. Conduct test trials via an external evaluation body.5. Issue the**Silver logo**using**Gazelle**. |
| 🥇 | **Gold**(Gold standard - full process incl. implementation verification by regional authorities) | 1. Integrate into regional certification frameworks (e.g., Catalonia's Health Seal of Excellence).2. Ensure the health app/software supports advanced interoperability (e.g., IPS exchange).3. Submit a conformance statement.4. Define sample submission requirements for compliance verification.5. Regional entity (e.g., TIC Salut) verifies sample implementation using**Gazelle**and issues a formal report.6. Manual expert validation (e.g., joint review meetings) complements automated checks.7. Issue the**Gold logo**indicating full trust and operational integration. |

### Labeling Process

The process begins when an organisation needs to certify their health system with the EEHRxF. This step involves the initiation of a formal certification process aimed at ensuring that health systems or applications adhere to the standards and policies defined within the European Electronic Health Record Exchange Format (EEHRxF). At this stage, a decision arises, posing the question: "What is the level of certification needed?" The applicant must decide between two available paths based on the desired rigor of the certification: Level One (Self-assessment) or Level Two (Third-party assessment).

 ****Disclaimer:**The current process to attain the xShare Industry Label and demonstrate compliance with the EEHRxF is currently under development and this process is likely to go through alterations.** 

xShare Industry Label certification process

#### Level One (Self-assessment) Path

The self-assessment path is designed for organisations that prefer to evaluate their compliance with the EEHRxF standards independently. This path allows organisations to conduct a preliminary assessment of their systems and applications without the need for external validation.

1. **Step 1:**Register on the EEHRxF Policy and Standards Hub website. This portal (not online yet) serves as the entry point for applicants seeking self-certification. The website ([https://ehr-exchange-format.eu/](https://ehr-exchange-format.eu/)) will provide comprehensive resources, including policy documents, technical specifications, and the self-assessment tool.
1. **Step 2:**Access the xShare Industry Label self-assessment tool ([https://ehds-testing.ihe-europe.net/](https://ehds-testing.ihe-europe.net/)). In the Gazelle environment, a testing tool with a checklist for EEHRxF certification criteria will guide organisations through the process.
1. **Step 3:**Upload relevant data into the system to evaluate compliance with EEHRxF standards based on the xShare Industry Label criteria.
1. **Step 4:**The self-assessment tool evaluates the submitted data based on predefined criteria (a checklist) and provides preliminary feedback about compliance status.

**Decision Point:** "Is the uploaded data compliant with EEHRxF certification criteria?"

* **If Yes:** 
1. Receive positive preliminary feedback and comments.
1. Proceed to the quality criteria evaluation phase.
1. **Decision Point:**"Does the system comply with the quality assessment criteria?"
1. If compliant: Receive a final positive assessment and certification.
1. If not compliant: Receive negative feedback and guidelines for improvement.
 
* **If No:** 
* Receive negative preliminary feedback and improvement guidelines.
* The process ends without certification.
 

#### Level Two (Third-party Assessment) Path

The third-party assessment path is designed for organisations that seek external validation of their compliance with the EEHRxF standards. This path involves a more rigorous evaluation process, including technical assessments and potential test trials.

1. **Step 1:**The Member State-designated organisation responsible for overseeing the certification process receives the request from the Industry.
1. **Step 2:**Submit a formal request for certification, including documentation and payment, to the designated authority (e.g., TIC Salut in Catalonia).
1. **Step 3:**The authority acknowledges receipt of the request and associated payment.
1. **Step 4:**Relevant data is identified for assessment, including technical specifications and functional details.
1. **Step 5:**Provide data in an acceptable format (such as XML or JSON) for submission into the assessment tool.
1. **Step 6:**Define priority data category validation format and mandatory requirements for compliance.
1. **Step 7:**Submit a declaration of conformity for analysis against EEHRxF standards.
1. **Steps 8-10:**Evaluate structure, functionality, and specific features using tools like Gazelle.
1. **Step 11:**Evaluate overall conformance, including the xShare Industry Label as an add-on.
1. **Step 12:**An assessment report is created to highlight any non-conformities.

**Decision Point:** "Has the system passed the evaluation criteria, including EEHRxF conformity?"

* **If Yes:** The authority provides the certification label, concluding the process successfully.
* **If No:** The certification label is not issued, and a conformity report is provided with improvement recommendations.

