# Get Started with the xShare Yellow Button Download - xShare Project Yellow Button v0.2.0-ci-build

* [**Table of Contents**](toc.md)
* **Get Started with the xShare Yellow Button Download**

## Get Started with the xShare Yellow Button Download

This is a brief guideline on why and how to implement the xShare Yellow Button Download feature in your system, and prove its conformance.

To use the Yellow Button Label you have to:

-------

### Why the Yellow Button?

* Enhance your system by offering natural persons a tool to easily access their data in a shareable and standardized format.
* Comply with the EHDS regulation.

-------

### What You Should Be Able to Do

Given that your system manages Natural Person authentication in accordance with European Regulations , the following functionality should be provided:

* Your system enables the authenticated Natural Person (data owner) to: 
* View and select from the available health data to download.
* Optionally configure download options (e.g., format, translations, pseudonymization, etc.).
* Download the selected content to a chosen destination.
 

**A detailed diagram is available[here](application.md#download).**

-------

### How to Implement: the specifications

For this version of the xShare Yellow Button **the only technical specifications to prove conformance with are the content specifications** listed below, acting as [**xShare Yellow Button Content Creator**](actors.md#xshare-yellow-button-content-creator):

| | | |
| :--- | :--- | :--- |
| ![](medical-app.png) | [Patient Summary](https://x-bundles.ehr-exchange-format.eu/ps-content/content.html) | [HL7 International Patient Summary FHIR IG v2.0.0](https://hl7.org/fhir/uv/ips/) |
| ![](experiment-results.png) | [Laboratory Report](https://x-bundles.ehr-exchange-format.eu/lab-rpt-content/content.html) | [HL7 Europe Laboratory Report FHIR IG v0.1.1](http://hl7.eu/fhir/laboratory) |
| ![](experiment-results.png) | [MyHealth@EU Laboratory Report](https://x-bundles.ehr-exchange-format.eu/myh-eu-lab-cnt/content.html) | [MyHealth@EU Laboratory Report FHIR IG v0.1.1](https://fhir.ehdsi.eu/laboratory) |

Early implementers might be interested in

(a) piloting the following 'frozen' specifications

| | | |
| :--- | :--- | :--- |
| ![](hospital.png) | [Hospital Discharge Report](https://x-bundles.ehr-exchange-format.eu/hdr-content/content.html) | [HL7 Europe Hospital Discharge Report FHIR IG v0.1.0-ballot](https://hl7.eu/fhir/hdr/) |
| ![](prescription.png) | [Medicine Prescription and Dispense](https://x-bundles.ehr-exchange-format.eu/mpd-content/content.html) | [HL7 EU Medication Prescription and Dispense FHIR IG v0.1.0-ballot](https://hl7.eu/fhir/mpd/) |
| ![](radiology.png) | [Imaging Report](https://x-bundles.ehr-exchange-format.eu/dir-content/content.html) | [HL7 EU Imaging Report FHIR IG v0.1.0-snapshot1](https://hl7.eu/fhir/imaging-r5/0.1.0-snapshot1) |
| ![](radiology.png) | [Imaging Study Manifest](https://x-bundles.ehr-exchange-format.eu/dir-content/content.html) | [IHE Manifest-based Access to DICOM Objects (MADO) v0.6](https://euridice.org/wp-content/uploads/2025/09/IHE_RAD-Suppl_MADO_Profile-draft_0.6.pdf) |

(a) trying the following on development specification

| | | |
| :--- | :--- | :--- |
| ![](medical-app.png) | [Patient Summary](https://x-bundles.ehr-exchange-format.eu/ps-content/content.html) | [HL7 Europe Patient Summary FHIR IG (0.1.0-ci-build)](https://build.fhir.org/ig/hl7-eu/eps) |

-------

### Declare and Prove Your Conformance

#### Claim Your Conformance

To claim conformance with the xShare Yellow Button Download, implementers must issue a [conformance statement](conf-statement.md) specifying the content specifications and the optional features supported (e.g. additional download formats, password protected content, psuedoanonymized data;…).

-------

#### Prove Your Conformance

To prove conformance to the **xShare Yellow Button Download** as [**xShare Yellow Button Provider**](ActorDefinition-actorDefinition-yb-provider.md) you must:

1. Demonstrate that only authenticated Natural Persons can access the xShare Yellow Button Download feature.
1. Claim that user autentication is realized in conformance with the European Regulations
1. Demonstrate that (only) authenticated Natural Persons can search for and select the documents or data they wish to download.
1. Pass validation tests for each of the declared supported content specifications (e.g., Patient Summary, Laboratory Results), as listed in the[Yellow Button Information view](content.md)page.
1. Ensure that the download content is available in the selected target format.

-------

To prove conformance to the **xShare Yellow Button Download** as [**xShare Yellow Button Consumer**](ActorDefinition-actorDefinition-yb-consumer.md) you must:

1. Demonstrate that is able to 'consume' (e.g. display, import,…) any of the declared supported content specifications (e.g., Patient Summary, Laboratory Results), as listed in the[Yellow Button Information view](content.md)page.

### Label Your System

To label your system follow the [labeling process](labeling_process.md).

