# Yellow Button Information view - xShare Project Yellow Button v0.2.0-ci-build

* [**Table of Contents**](toc.md)
* **Yellow Button Information view**

## Yellow Button Information view

### Data Domain

The [**data domain**](content.md) describes data models and exchange formats used by the Yellow Button.

This page lists only the implementable specification aginst which the conformance is tested.

A complete list of the Conceptual, Logical and Implementable models and specifications is provided in the the xBundle registry [xShare Yellow Button - content](https://x-bundles.ehr-exchange-format.eu/xb-1-cnt/content.html).

### Implementable specification

For this version of the xShare Yellow Button **the only technical specifications to prove conformance with are the content specifications** listed below:

| | | |
| :--- | :--- | :--- |
| ![](medical-app.png) | [Patient Summary](https://x-bundles.ehr-exchange-format.eu/ps-content/content.html) | [HL7 International Patient Summary FHIR IG v2.0.0](https://hl7.org/fhir/uv/ips/) |
| ![](experiment-results.png) | [Laboratory Report](https://x-bundles.ehr-exchange-format.eu/lab-rpt-content/content.html) | [HL7 Europe Laboratory Report FHIR IG v0.1.1](http://hl7.eu/fhir/laboratory) |
| ![](experiment-results.png) | [MyHealth@EU Laboratory Report](https://x-bundles.ehr-exchange-format.eu/myh-eu-lab-cnt/content.html) | [MyHealth@EU Laboratory Report FHIR IG v0.1.1](https://fhir.ehdsi.eu/laboratory) |

Early implementers might be interested in

(a) piloting the following 'frozen' specifications

| | | |
| :--- | :--- | :--- |
| ![](hospital.png) | [Hospital Discharge Report](https://x-bundles.ehr-exchange-format.eu/hdr-content/content.html) | [HL7 Europe Hospital Discharge Report FHIR IG v0.1.0-ballot](https://hl7.eu/fhir/hdr/) |
| ![](prescription.png) | [Medicine Prescription and Dispense](https://x-bundles.ehr-exchange-format.eu/mpd-content/content.html) | [HL7 EU Medication Prescription and Dispense FHIR IG v0.1.0-ballot](https://hl7.eu/fhir/mpd/) |
| ![](radiology.png) | [Imaging Report](https://x-bundles.ehr-exchange-format.eu/dir-content/content.html) | [HL7 EU Imaging Report FHIR IG v0.1.0-snapshot1](https://hl7.eu/fhir/imaging-r5/0.1.0-snapshot1) |
| ![](radiology.png) | [Imaging Study Manifest](https://x-bundles.ehr-exchange-format.eu/dir-content/content.html) | [IHE Manifest-based Access to DICOM Objects (MADO) v0.6](https://euridice.org/wp-content/uploads/2025/09/IHE_RAD-Suppl_MADO_Profile-draft_0.6.pdf) |

(a) trying the following on development specification

| | | |
| :--- | :--- | :--- |
| ![](medical-app.png) | [Patient Summary](https://x-bundles.ehr-exchange-format.eu/ps-content/content.html) | [HL7 Europe Patient Summary FHIR IG (0.1.0-ci-build)](https://build.fhir.org/ig/hl7-eu/eps) |

**Note: The list of formats is subject to continous revisions, based on the availability of new IG versions.**

### Declare and Prove Your Conformance

#### Claim Your Conformance

See the [Claim Your Conformance](conformance.md#claim-your-conformance) section.

#### Prove Your Conformance

See the [Prove Your Conformance](conformance.md#prove-your-conformance) section.

The solution should act as [xShare Yellow Button Content Creator](actors.md#xshare-yellow-button-content-creator) for the type of content declared to be supported and be able to demostrate conformance with what is specified in the [Prove Your Conformance](conformance.md#prove-your-conformance) section.

