# Terminology - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* **Terminology**

## Terminology

### Code Systems

These code systems have been defined for this implementation guide:

* [Conditions](CodeSystem-ConditionsCS.md)
* [OrphaNet](CodeSystem-OrphaNet.md)
* [PCSP Code System](CodeSystem-cs-generic-eu-pcsp.md)
* [Radiotherapy sites](CodeSystem-cs-radiotherapy-pcsp.md)
* [PCSP Recommendations](CodeSystem-cs-recommendation-eu-pcsp.md)
* [PCSP Conditions at risk](CodeSystem-cs-riskcondition-eu-pcsp.md)
* [Risk Factors](CodeSystem-cs-riskfactor-eu-pcsp.md)
* [International Classification of Childhood Cancer, Third Edition](CodeSystem-iccc-3.md)
* [International Classification of Diseases for Oncology, Third Edition](CodeSystem-icd-o-3.md)

### Value Sets

These value sets have been defined for this implementation guide:

* [Chemotherapy cumulative dose units](ValueSet-ChemoUnitsVs.md)
* [Active or resolved Condition](ValueSet-activeResolved-condition-vs.md)
* [Annotation type](ValueSet-annotation-type-vs.md)
* [Conditions: follow up](ValueSet-cond-test-vs.md)
* [Antineoplastic and immunostimulating agents](ValueSet-drugsAtc-eu-pcsp.md)
* [Grade: follow up](ValueSet-grade-test-vs.md)
* [Laterality Qualifier Value Set](ValueSet-laterality-qualifier-lrub-vs.md)
* [Body Location Qualifier Value Set](ValueSet-mcode-body-location-qualifier-vs.md)
* [Stage Group Value Set](ValueSet-mcode-cancer-stage-group-vs.md)
* [Cancer Staging System Value Set](ValueSet-mcode-cancer-staging-system-vs.md)
* [Observation Codes for Distant Metastases Category](ValueSet-mcode-observation-codes-distant-metastases-vs.md)
* [Observation Codes for Primary Tumor Category](ValueSet-mcode-observation-codes-primary-tumor-vs.md)
* [Observation Codes for Regional Node Category](ValueSet-mcode-observation-codes-regional-nodes-vs.md)
* [Observation Codes for Stage Group Category](ValueSet-mcode-observation-codes-stage-group-vs.md)
* [TNM Distant Metastases Category Value Set](ValueSet-mcode-tnm-distant-metastases-category-vs.md)
* [TNM Primary Tumor Category Value Set](ValueSet-mcode-tnm-primary-tumor-category-vs.md)
* [TNM Regional Nodes Category Value Set](ValueSet-mcode-tnm-regional-nodes-category-vs.md)
* [Morphologically abnormal structure](ValueSet-morphologicAbnormality-eu-vs.md)
* [Other Infors Condition](ValueSet-otherInfos-condition-vs.md)
* [Relapse type (Local/Distant/Combined)](ValueSet-relapse-type-vs.md)
* [Toxicity Severity](ValueSet-toxicityseverity-vs.md)
* [Acute Gvhd Grade](ValueSet-vs-Gvhd-acute-grade-eu-pcsp.md)
* [Chronic Gvhd condition](ValueSet-vs-Gvhd-chronic-grade-eu-pcsp.md)
* [Gvhd condition](ValueSet-vs-Gvhd-type-eu-pcsp.md)
* [Prosthesis Type](ValueSet-vs-ProsthesisType-eu-pcsp.md)
* [Prosthetic Surgical Procedure Type](ValueSet-vs-ProstheticProcedureType-eu-pcsp.md)
* [Surgical Actions](ValueSet-vs-action-eu-pcsp.md)
* [Affected Organs (surgery)](ValueSet-vs-affectedOrgan-eu-pcsp.md)
* [Amputation Surgical Procedure Type](ValueSet-vs-amputationProcedureType-eu-pcsp.md)
* [Brachytherapy Type](ValueSet-vs-brachytherapyType-eu-pcsp.md)
* [Calculated|Estimated](ValueSet-vs-calcest-eu-pcsp.md)
* [Colostomy Surgical Procedure Type](ValueSet-vs-colostomyProcedureType-eu-pcsp.md)
* [Document Type](ValueSet-vs-docref-doctype-eu-pcsp.md)
* [FLT Plan Type](ValueSet-vs-flt-plan-type-eu-pcsp.md)
* [Body Location Qualifier Value Set](ValueSet-vs-fromToPosteriorAnterior-eu-pcsp.md)
* [Gastrostomy Surgical Procedure Type](ValueSet-vs-gastrostomyProcedureType-eu-pcsp.md)
* [Hereditary Predispositions or Disease](ValueSet-vs-hereditary-eu-pcsp.md)
* [ICCC-3](ValueSet-vs-iccc3-eu-pcsp.md)
* [Hereditary Predispositions (ICD10)](ValueSet-vs-icd10-predisposition-eu-pcsp.md)
* [ICD-O-3 Morphology](ValueSet-vs-icdo3-morphology-eu-pcsp.md)
* [ICD-O-3 Topography](ValueSet-vs-icdo3-topography-eu-pcsp.md)
* [Radiotherapy Isotopes](ValueSet-vs-isotopes-eu-pcsp.md)
* [Not Applicable|Unknown](ValueSet-vs-naunk-eu-pcsp.md)
* [Not Performed|Unknown](ValueSet-vs-npunk-eu-pcsp.md)
* [Hereditary Predispositions (Orphacode)](ValueSet-vs-orpha-predisposition-eu-pcsp.md)
* [Other/Unknown/Text](ValueSet-vs-othUnkTxt-eu-pcsp.md)
* [Radiotherapy sites](ValueSet-vs-radiotherapy-pcsp.md)
* [Radiotherapy Device Type](ValueSet-vs-radiotherapyDeviceType-eu-pcsp.md)
* [Radiotherapy Dose Type](ValueSet-vs-radiotherapyDoseType-eu-pcsp.md)
* [Radiotherapy dose units](ValueSet-vs-radiotherapyDoseUnit-eu-pcsp.md)
* [Radiotherapy Type](ValueSet-vs-radiotherapyType-eu-pcsp.md)
* [Recommendations](ValueSet-vs-recommendation-eu-pcsp.md)
* [Conditions at risk](ValueSet-vs-riskcondition-eu-pcsp.md)
* [Risk Factors](ValueSet-vs-riskfactor-eu-pcsp.md)
* [Route of administration](ValueSet-vs-roa-eu-pcsp.md)
* [Sacrified Organs (surgery)](ValueSet-vs-sacrifiedOrgan-eu-pcsp.md)
* [Stem Cell Donor type](ValueSet-vs-sct-donorType-eu-pcsp.md)
* [SCT Prophylaxis Cathegory](ValueSet-vs-sct-prophylaxis-cathegory-eu-pcsp.md)
* [SCT Prophylaxis Type](ValueSet-vs-sct-prophylaxis-type-eu-pcsp.md)
* [Stem Cell Source type](ValueSet-vs-sct-sourceType-eu-pcsp.md)
* [Before/after procedure](ValueSet-vs-sct-timing-eu-pcsp.md)
* [Stem Cell Transplantation type](ValueSet-vs-sct-type-eu-pcsp.md)
* [Shunt Procedure Type](ValueSet-vs-shuntProcedureType-eu-pcsp.md)
* [Surgical Procedure Type](ValueSet-vs-surgicalProcedureType-eu-pcsp.md)
* [Unknown|Other](ValueSet-vs-unknownOther-eu-pcsp.md)

### Concept Maps

These concept maps have been defined for this implementation guide:

