# Extensions - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* **Extensions**

## Extensions

[Annotation Type](StructureDefinition-annotation-type.md)

This extension is used to indicate the kind of note captured

[Previous Status](StructureDefinition-condition-previousStatus.md)

This extension provides a mean to indicate the previous clinicalStatus of a condition. It might be used for example to indicate if a relapse is now in remission.

[Relapse Type](StructureDefinition-condition-relapseType.md)

This extension is used to indicate if a relapse/progression is local, remote or combined.

[Act Location](StructureDefinition-event-location.md)

This extension provides a means to indicate where an act was, is or it is intended to take place.

[Body Location Qualifier](StructureDefinition-mcode-body-location-qualifier.md)

Qualifier to refine an body location. These include qualifiers for relative location, directionality, number, and plane, and exclude qualifiers for laterality.

[Condition related to resource](StructureDefinition-mcode-condition-related.md)

The resource has an unspecified relationship with a Condition.

[Laterality Qualifier](StructureDefinition-mcode-laterality-qualifier.md)

Qualifier to specify laterality.

[Randomization arm for trial](StructureDefinition-procedure-fltArm.md)

This extension is used to provide a textual description of the randomization arm for trials (FLT).

[Not affected Organ](StructureDefinition-procedure-notAffectedOrgan.md)

This extension is used to explicitly indicate the Organ (body site) that has not been affected by this procedure.

[Performed Timing](StructureDefinition-procedure-performedTiming.md)

This extension allows to indicate when the procedure was performed as Timing.

[Procedure Used Reference](StructureDefinition-procedure-usedReference.md)

Extend the usedReference element to BiologicallyDerivedProduct

[Radiotherapy Energy or Isotope](StructureDefinition-radiotherapy-energy-or-isotope.md)

The radiation energy used for radiotherapy. The energy spectrum is characterized by the maximum energy, the maximum accelaration voltage, or the used isotope. This extension is based on the CodeX™ Radiation Therapy RadiotherapyEnergyOrIsotope extension

[Resource related information](StructureDefinition-resource-relatedInfo.md)

This extension provides a means to link the source resource to any target related information. This extension shall not be used when other more specific elements or standard extensions apply. E.g. Observation.hasMember.

[Stem Cell Donor Type](StructureDefinition-sct-donor-type.md)

Specify the type of donor for the cell used in a transplantation

[Stem Cell Source Type](StructureDefinition-sct-source-type.md)

Specify the type of source for the cell used in a transplantation

[Sacrified organ](StructureDefinition-surgery-sacrifiedOrgan.md)

Organs are 'sacrified' either to allow a radical excision of the tumor or on purpose (spleen) for staging procedures

