# Artifacts Summary - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### SurPass Logical model 

Logical data models as HL7 FHIR resources

| | |
| :--- | :--- |
| [SurPass V2.0](StructureDefinition-SurPass.md) | Survivorship Passport V2.0 |

### SurPass Bundle profile 

HL7 FHIR profile for the SurPass document bundle

| | |
| :--- | :--- |
| [Bundle: Survivor Passport](StructureDefinition-Bundle-eu-pcsp.md) | This profile represents the constraints applied to the Bundle resource by the PCSP FHIR Implementation Guide. |

### Structures: Logical Models 

These define data models that represent the domain covered by this implementation guide in more business-friendly terms than the underlying FHIR resources.

| | |
| :--- | :--- |
| [Care Plan](StructureDefinition-PlanOfCare.md) | Care Plan |
| [Chemotherapy](StructureDefinition-Chemotherapy.md) | Chemotherapy |
| [Diagnosis](StructureDefinition-Diagnosis.md) | Diagnosis |
| [Front Line Treatment](StructureDefinition-FrontLineTreatment.md) | Front Line Treatment. The first treatment given for a disease. It is often part of a standard set of treatments, such as surgery followed by chemotherapy and radiation. When used by itself, first-line therapy is the one accepted as the best treatment. If it does not cure the disease or it causes severe side effects, other treatment may be added or used instead. Also called induction therapy, primary therapy, and primary treatment. |
| [Major Surgery](StructureDefinition-MajorSurgery.md) | Major Surgery. |
| [Metadata FSE Italy](StructureDefinition-DocMetadataFSE.md) | Metadata FSE Italy. |
| [Other info and relevant events](StructureDefinition-OtherInfos.md) | Other info and relevant events |
| [Progression-Relapse after FLT](StructureDefinition-RelapseAfterFLT.md) | Progression-Relapse after FLT |
| [Progression-Relapse during FLT](StructureDefinition-RelapseDuringFLT.md) | Progression-Relapse during FLT |
| [Radiotherapy](StructureDefinition-Radiotherapy.md) | Radiotherapy |
| [Stem Cell Transplantation](StructureDefinition-StemCellTransplantation.md) | Stem Cell Transplantation. |
| [Subject of care](StructureDefinition-Subject.md) | Subject of care |
| [Treatment Summary](StructureDefinition-TreatmentSummary.md) | Treatment Summary data model |

### Structures: Questionnaires 

These define forms used by systems conforming to this implementation guide to capture or expose data to end users.

| | |
| :--- | :--- |
| [FollowupSurPass](Questionnaire-FollowupSurPass.md) | Follow up form. The first Followup-Surpass form must be completed at the same time as the SurPass is delivered or in any case at the first visit after the end of the treatment (OT). |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [BiologicallyDerivedProduct: Stem Cell](StructureDefinition-BiologicallyDerivedProduct-sct-eu-pcsp.md) | This profile defines how to represent Stem Cell in FHIR for describing a Stem Cell Transplantation data required by the PanCareSurPass algorithm to generate the care plan. |
| [CarePlan: PCSP-generated plan](StructureDefinition-CarePlan-eu-pcsp.md) | This profile defines how to represent the Care Plan proposed by the PCSP platoform in HL7 FHIR. This profile can be used for both the version generated by the platoform and that curated and validated by Clinicians. |
| [Composition: Survivor Passport](StructureDefinition-Composition-surpass-eu-pcsp.md) | This profile defines how to represent a PCSP Survivor Passport by using a HL7 FHIR Composition for the purpose of the PanCareSurPass project. |
| [Condition: GvHD](StructureDefinition-Condition-gvhd-eu-pcsp.md) | This profile defines how to represent Graft versus host disease (GvHD) in HL7 FHIR for the purpose of the PanCareSurPass project. |
| [Condition: Metastatic Cancer](StructureDefinition-Condition-secondaryCancer-eu-pcsp.md) | This profile defines how to represent metastatic cancer in FHIR for the purpose of the PanCareSurPass project. This profile is inspired from the[mCode IG](http://build.fhir.org/ig/HL7/fhir-mCODE-ig). Records the history of secondary neoplasms, including location(s) and the date of onset of metastases. A secondary cancer results from the spread (metastasization) of cancer from its original site (Definition from: NCI Dictionary of Cancer Terms). |
| [Condition: Others](StructureDefinition-Condition-otherinfos-eu-pcsp.md) | This profile defines how to describe the presence of some other conditions (e.g. Hypogonadism, Growth hormone deficiency, Hydrocephalus in HL7 FHIR for the purpose of the PanCareSurPass project. |
| [Condition: Primary Cancer](StructureDefinition-Condition-primaryCancer-eu-pcsp.md) | This profile defines how to represent Primary Cancer Condition in HL7 FHIR for the purpose of the PanCareSurPass project. This profile is inspired from the[mCode IG](http://build.fhir.org/ig/HL7/fhir-mCODE-ig). A primary cancer condition, the original or first tumor in the body (Definition from:[NCI Dictionary of Cancer Terms](https://www.cancer.gov/publications/dictionaries/cancer-terms/def/primary-tumor)). Cancers that are not clearly secondary (i.e., of uncertain origin or behavior) should be documented as primary. This profile should be also used for documenting primary cancer relapses during or after FLT. |
| [Condition: Severe Toxicity](StructureDefinition-Condition-toxicity-eu-pcsp.md) | This profile defines how to describe a Severe Toxicity event in HL7 FHIR for the purpose of the PanCareSurPass project. |
| [DocumentReference: PCSP](StructureDefinition-DocumentReference-eu-pcsp.md) | This profile defines how to embed a PDF PCSP Survivor Passport in FHIR for the purpose of the PanCareSurPass project. This profile can be aslo used for send attachments (e.g Raditherapy reports or HDR) to the platform |
| [Encounter: Treatment Center](StructureDefinition-Encounter-eu-pcsp.md) | This profile defines how to represent data of arrival to the center and Center information in FHIR for the purpose of the PanCareSurPass project. |
| [Location: PCSP](StructureDefinition-Location-eu-pcsp.md) | This profile defines how to represent FHIR Location for the purpose of the PanCareSurPass project. |
| [MedicationAdministration: Chemotherapy](StructureDefinition-MedicationAdministration-eu-pcsp.md) | This profile defines how to represent MedicationAdministration in HL7 FHIR for describing Chemotherapy data for the purpose of the PanCareSurPass project. |
| [MedicationStatement: Chemotherapy](StructureDefinition-MedicationStatement-eu-pcsp.md) | This profile defines how to represent MedicationStatement in FHIR for describing minimal information about provided medications for the purpose of the PanCareSurPass project. |
| [Observation: Blood type/RH](StructureDefinition-Observation-bld-abo-rh-eu-pcsp.md) | This profile defines how to represent Blood type/RH before or after the SCT in HL7 FHIR for the purpose of the PanCareSurPass project. |
| [Observation: Cancer Stage Group](StructureDefinition-mcode-cancer-stage-group.md) | The extent of the cancer in the body, according to a given cancer staging classification system, based on evidence such as physical examination, imaging, and/or biopsy or based on pathologic analysis of a specimen. |
| [Observation: Chemotherapy Cumulative Dose](StructureDefinition-Observation-cumulativeDoseChemo-eu-pcsp.md) | This profile defines how to represent Chemotherapy Cumulative Dose in FHIR for the purpose of the PanCareSurPass project. |
| [Observation: Diagnosis details](StructureDefinition-Observation-diagnosis-eu-pcsp.md) | This profile defines how to represent diagnosis details (when the diagnosis was made; who made it;…) in FHIR for the purpose of the PanCareSurPass project. |
| [Observation: Hereditary Predisposition](StructureDefinition-Observation-predisposition-eu-pcsp.md) | This profile defines how to represent Hereditary Predispositions in HL7 FHIR for the purpose of the PanCareSurPass project. |
| [Observation: Radiotherapy Total Dose PCSP](StructureDefinition-Observation-totalDoseRad-eu-pcsp.md) | This profile defines how to represent Radiotherapy Total Dose in FHIR for the purpose of the PanCareSurPass project. |
| [Observation: Risk Factor](StructureDefinition-Observation-riskfactor-eu-pcsp.md) | This profile defines how to represent a Risk Factor in HL7 FHIR as determined by the PCSP platoform. |
| [Observation: TNM Distant Metastases Category](StructureDefinition-mcode-tnm-distant-metastases-category.md) | Category describing the extent of a tumor metastasis in remote anatomical locations, based on evidence such as physical examination, imaging, and/or biopsy. |
| [Observation: TNM Primary Tumor Category](StructureDefinition-mcode-tnm-primary-tumor-category.md) | Category of the primary tumor, based on its size and extent, based on evidence such as physical examination, imaging, and/or biopsy. |
| [Observation: TNM Regional Nodes Category](StructureDefinition-mcode-tnm-regional-nodes-category.md) | Category of the presence or absence of metastases in regional lymph nodes, based on evidence such as physical examination, imaging, and/or biopsy. |
| [Organization: Primary Treatment Center / Center of diagnosis](StructureDefinition-Organization-center-eu-pcsp.md) | This profile defines how to represent the Primary Treatment Center or the Center of diagnosis in FHIR for the purpose of the PanCareSurPass project. |
| [Patient: PCSP](StructureDefinition-Patient-eu-pcsp.md) | This profile defines how to represent Patient in FHIR for the purpose of the PanCareSurPass project. |
| [PlanDefinition: Front Line Treatment](StructureDefinition-PlanDefinition-flt-eu-pcsp.md) | This profile defines how to provide Front Line Treatment protocol infos in FHIR for the scope of the PanCareSurPass project. |
| [Procedure: Catheter](StructureDefinition-Procedure-cvc-otherinfos-eu-pcsp.md) | This profile defines how to describe the Catheterization of vein Procedure in HL7 FHIR for the purpose of the PanCareSurPass project. |
| [Procedure: Cryopreservation](StructureDefinition-Procedure-cryopreservation-otherinfos-eu-pcsp.md) | This profile defines how to describe the cryopreservation of sperms or oocyte for cancer patient in HL7 FHIR for the purpose of the PanCareSurPass project. |
| [Procedure: Front Line Treatment](StructureDefinition-Procedure-flt-eu-pcsp.md) | This profile defines how to provide Front Line Treatment data in FHIR for the scope of the PanCareSurPass project. |
| [Procedure: Other Treatments](StructureDefinition-Procedure-treatment-otherinfos-eu-pcsp.md) | This profile defines how to convey textual information about other oncological treatments in HL7 FHIR for the purpose of the PanCareSurPass project. |
| [Procedure: Radiotherapy](StructureDefinition-Procedure-radiotheraphy-eu-pcsp.md) | This profile defines how to represent Procedures in FHIR for describing a set of Radiotherapy data required by the PanCareSurPass algorithm to generate the care plan. |
| [Procedure: Radiotherapy Boost](StructureDefinition-Procedure-radiotheraphyBoost-eu-pcsp.md) | This profile defines how to represent Procedures in FHIR for describing a set of data required by PanCareSurPass for Radiotherapy Boosts |
| [Procedure: Radiotherapy Shielding](StructureDefinition-Procedure-radiotheraphyShield-eu-pcsp.md) | This profile defines how to represent Shielding Procedures in FHIR for describing a set of Radiotherapy data required by the PanCareSurPass algorithm to generate the care plan. |
| [Procedure: SCT Prophylaxis](StructureDefinition-Procedure-sct-prophylaxis-eu-pcsp.md) | This profile defines how to represent GVHD prophylaxis, conditioning regimen Procedures in FHIR for supporting Stem Cell Transplantation data, as required by the PanCareSurPass algorithm to generate the care plan. |
| [Procedure: Stem Cell Transplantation](StructureDefinition-Procedure-sct-eu-pcsp.md) | This profile defines how to represent Procedures in FHIR for describing a set of Stem Cell Transplantation data required by the PanCareSurPass algorithm to generate the care plan. |
| [Procedure: Surgery](StructureDefinition-Procedure-surgery-eu-pcsp.md) | This profile defines how to represent Procedures in FHIR for describing a set of Surgery data required by the PanCareSurPass algorithm to generate the care plan. It is used also to provide inforamtion about shunt, amputation, and other procedures |
| [Procedure: Transfusion other infos](StructureDefinition-Procedure-transfusion-otherinfos-eu-pcsp.md) | This profile defines how to describe the Transfusion Procedure in HL7 FHIR for the purpose of the PanCareSurPass project. |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Act Location](StructureDefinition-event-location.md) | This extension provides a means to indicate where an act was, is or it is intended to take place. |
| [Annotation Type](StructureDefinition-annotation-type.md) | This extension is used to indicate the kind of note captured |
| [Body Location Qualifier](StructureDefinition-mcode-body-location-qualifier.md) | Qualifier to refine an body location. These include qualifiers for relative location, directionality, number, and plane, and exclude qualifiers for laterality. |
| [Condition related to resource](StructureDefinition-mcode-condition-related.md) | The resource has an unspecified relationship with a Condition. |
| [Laterality Qualifier](StructureDefinition-mcode-laterality-qualifier.md) | Qualifier to specify laterality. |
| [Not affected Organ](StructureDefinition-procedure-notAffectedOrgan.md) | This extension is used to explicitly indicate the Organ (body site) that has not been affected by this procedure. |
| [Performed Timing](StructureDefinition-procedure-performedTiming.md) | This extension allows to indicate when the procedure was performed as Timing. |
| [Previous Status](StructureDefinition-condition-previousStatus.md) | This extension provides a mean to indicate the previous clinicalStatus of a condition. It might be used for example to indicate if a relapse is now in remission. |
| [Procedure Used Reference](StructureDefinition-procedure-usedReference.md) | Extend the usedReference element to BiologicallyDerivedProduct |
| [Radiotherapy Energy or Isotope](StructureDefinition-radiotherapy-energy-or-isotope.md) | The radiation energy used for radiotherapy. The energy spectrum is characterized by the maximum energy, the maximum accelaration voltage, or the used isotope. This extension is based on the CodeX™ Radiation Therapy RadiotherapyEnergyOrIsotope extension |
| [Randomization arm for trial](StructureDefinition-procedure-fltArm.md) | This extension is used to provide a textual description of the randomization arm for trials (FLT). |
| [Relapse Type](StructureDefinition-condition-relapseType.md) | This extension is used to indicate if a relapse/progression is local, remote or combined. |
| [Resource related information](StructureDefinition-resource-relatedInfo.md) | This extension provides a means to link the source resource to any target related information. This extension shall not be used when other more specific elements or standard extensions apply. E.g. Observation.hasMember. |
| [Sacrified organ](StructureDefinition-surgery-sacrifiedOrgan.md) | Organs are 'sacrified' either to allow a radical excision of the tumor or on purpose (spleen) for staging procedures |
| [Stem Cell Donor Type](StructureDefinition-sct-donor-type.md) | Specify the type of donor for the cell used in a transplantation |
| [Stem Cell Source Type](StructureDefinition-sct-source-type.md) | Specify the type of source for the cell used in a transplantation |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Active or resolved Condition](ValueSet-activeResolved-condition-vs.md) | Active or resolved Condition |
| [Acute Gvhd Grade](ValueSet-vs-Gvhd-acute-grade-eu-pcsp.md) | Acute Gvhd Grade |
| [Affected Organs (surgery)](ValueSet-vs-affectedOrgan-eu-pcsp.md) | Affected Organs (surgery) |
| [Amputation Surgical Procedure Type](ValueSet-vs-amputationProcedureType-eu-pcsp.md) | Types of amputation procedure this resource is referring to |
| [Annotation type](ValueSet-annotation-type-vs.md) | Annotation type |
| [Antineoplastic and immunostimulating agents](ValueSet-drugsAtc-eu-pcsp.md) | List of WHO ATC codes for antineoplastic and immunostimulating agents. |
| [Before/after procedure](ValueSet-vs-sct-timing-eu-pcsp.md) | SCT Timing events: Before/after procedure |
| [Body Location Qualifier Value Set](ValueSet-mcode-body-location-qualifier-vs.md) | Qualifiers to refine a body structure or location including qualifiers for relative location, directionality, number, and plane, and excluding qualifiers for laterality. |
| [Body Location Qualifier Value Set](ValueSet-vs-fromToPosteriorAnterior-eu-pcsp.md) | Types of documents exchanged with the PCSP platform |
| [Brachytherapy Type](ValueSet-vs-brachytherapyType-eu-pcsp.md) | Types of Brachytherapy this procedure is referring to |
| [Calculated|Estimated](ValueSet-vs-calcest-eu-pcsp.md) | 
| | |
| :--- | :--- |
| Calculated | Estimated Value Set |
 |
| [Cancer Staging System Value Set](ValueSet-mcode-cancer-staging-system-vs.md) | System used for staging. |
| [Chemotherapy cumulative dose units](ValueSet-ChemoUnitsVs.md) | Chemotherapy cumulative dose units |
| [Chronic Gvhd condition](ValueSet-vs-Gvhd-chronic-grade-eu-pcsp.md) | Acute Gvhd Grade |
| [Colostomy Surgical Procedure Type](ValueSet-vs-colostomyProcedureType-eu-pcsp.md) | Types of colostomy procedure this resource is referring to |
| [Conditions at risk](ValueSet-vs-riskcondition-eu-pcsp.md) | Condition at risk proposed by the PCSP algorithm |
| [Conditions: follow up](ValueSet-cond-test-vs.md) | Conditions: follow up |
| [Document Type](ValueSet-vs-docref-doctype-eu-pcsp.md) | Types of documents exchanged with the PCSP platform |
| [FLT Plan Type](ValueSet-vs-flt-plan-type-eu-pcsp.md) | FLT Plan Type |
| [Gastrostomy Surgical Procedure Type](ValueSet-vs-gastrostomyProcedureType-eu-pcsp.md) | Types of Gastrostomy procedure this resource is referring to |
| [Grade: follow up](ValueSet-grade-test-vs.md) | Grade: follow up |
| [Gvhd condition](ValueSet-vs-Gvhd-type-eu-pcsp.md) | Gvhd condition |
| [Hereditary Predispositions (ICD10)](ValueSet-vs-icd10-predisposition-eu-pcsp.md) | Hereditary Predispositions (ICD10) |
| [Hereditary Predispositions (Orphacode)](ValueSet-vs-orpha-predisposition-eu-pcsp.md) | Hereditary Predispositions (Orphacode) |
| [Hereditary Predispositions or Disease](ValueSet-vs-hereditary-eu-pcsp.md) | Hereditary Predispositions or Disease |
| [ICCC-3](ValueSet-vs-iccc3-eu-pcsp.md) | International Classification of Childhood Cancer, third edition + exceptional values |
| [ICD-O-3 Morphology](ValueSet-vs-icdo3-morphology-eu-pcsp.md) | ICD-O-3 Morphology |
| [ICD-O-3 Topography](ValueSet-vs-icdo3-topography-eu-pcsp.md) | ICD-O-3 Topography |
| [Laterality Qualifier Value Set](ValueSet-laterality-qualifier-lrub-vs.md) | Qualifiers to specify laterality. |
| [Morphologically abnormal structure](ValueSet-morphologicAbnormality-eu-vs.md) | Morphologically abnormal structure. |
| [Not Applicable|Unknown](ValueSet-vs-naunk-eu-pcsp.md) | Not Applicable/Unknown Value Set |
| [Not Performed|Unknown](ValueSet-vs-npunk-eu-pcsp.md) | Not Performed/Unknown Value Set |
| [Observation Codes for Distant Metastases Category](ValueSet-mcode-observation-codes-distant-metastases-vs.md) | Identifying codes based on the timing of classification for distant metastases (M) staging observations. |
| [Observation Codes for Primary Tumor Category](ValueSet-mcode-observation-codes-primary-tumor-vs.md) | Identifying codes based on the timing of classification for primary tumor (T) staging observations. |
| [Observation Codes for Regional Node Category](ValueSet-mcode-observation-codes-regional-nodes-vs.md) | Identifying codes based on the timing of classification for regional node (N) staging observations. |
| [Observation Codes for Stage Group Category](ValueSet-mcode-observation-codes-stage-group-vs.md) | Identifying codes based on the timing of classification for stage group observations. |
| [Other Infors Condition](ValueSet-otherInfos-condition-vs.md) | Other Infors Condition |
| [Other/Unknown/Text](ValueSet-vs-othUnkTxt-eu-pcsp.md) | Other/Unknown/Text Value Set |
| [Prosthesis Type](ValueSet-vs-ProsthesisType-eu-pcsp.md) | Types of Prosthesis this procedure is referring to |
| [Prosthetic Surgical Procedure Type](ValueSet-vs-ProstheticProcedureType-eu-pcsp.md) | Types of Prosthetic procedure this resource is referring to |
| [Radiotherapy Device Type](ValueSet-vs-radiotherapyDeviceType-eu-pcsp.md) | Radiotherapy device type this procedure is referring to |
| [Radiotherapy Dose Type](ValueSet-vs-radiotherapyDoseType-eu-pcsp.md) | Types of radiotherapy cumulative dose this procedure is referring to |
| [Radiotherapy Isotopes](ValueSet-vs-isotopes-eu-pcsp.md) | Radiotherapy Isotopes |
| [Radiotherapy Type](ValueSet-vs-radiotherapyType-eu-pcsp.md) | Types of radiotherapy this procedure is referring to |
| [Radiotherapy dose units](ValueSet-vs-radiotherapyDoseUnit-eu-pcsp.md) | Radiotherapy dose units |
| [Radiotherapy sites](ValueSet-vs-radiotherapy-pcsp.md) | PancareSurPass radiotherapy sites Value Set |
| [Recommendations](ValueSet-vs-recommendation-eu-pcsp.md) | Recommendations proposed by the PCSP algorithm |
| [Relapse type (Local/Distant/Combined)](ValueSet-relapse-type-vs.md) | Relapse type (Local/Distant/Combined) |
| [Risk Factors](ValueSet-vs-riskfactor-eu-pcsp.md) | Risk Factors used by the PCSP algorithm |
| [Route of administration](ValueSet-vs-roa-eu-pcsp.md) | Route of administration |
| [SCT Prophylaxis Cathegory](ValueSet-vs-sct-prophylaxis-cathegory-eu-pcsp.md) | SCT Prophylaxis Cathegory |
| [SCT Prophylaxis Type](ValueSet-vs-sct-prophylaxis-type-eu-pcsp.md) | SCT Prophylaxis Type |
| [Sacrified Organs (surgery)](ValueSet-vs-sacrifiedOrgan-eu-pcsp.md) | Sacrified Organs (surgery). Organs are 'sacrified' either to allow a radical excision of the tumor or on purpose (spleen) for staging procedures |
| [Shunt Procedure Type](ValueSet-vs-shuntProcedureType-eu-pcsp.md) | Types of shunt surgical procedure this resource is referring to |
| [Stage Group Value Set](ValueSet-mcode-cancer-stage-group-vs.md) | This value set is intended to contain allowable values for Stage Group, according to TNM staging rules. AJCC codes (preferably, version 8 for current cancers) SHOULD be used. |
| [Stem Cell Donor type](ValueSet-vs-sct-donorType-eu-pcsp.md) | Stem Cell Donor type |
| [Stem Cell Source type](ValueSet-vs-sct-sourceType-eu-pcsp.md) | Stem Cell Source type |
| [Stem Cell Transplantation type](ValueSet-vs-sct-type-eu-pcsp.md) | Stem Cell Transplantation type |
| [Surgical Actions](ValueSet-vs-action-eu-pcsp.md) | Surgical Actions |
| [Surgical Procedure Type](ValueSet-vs-surgicalProcedureType-eu-pcsp.md) | Types of surgical procedure this resource is referring to |
| [TNM Distant Metastases Category Value Set](ValueSet-mcode-tnm-distant-metastases-category-vs.md) | This value set is intended to contain allowable values for the M category, according to TNM staging rules. AJCC codes (preferably, version 8 for current cancers) SHOULD be used. |
| [TNM Primary Tumor Category Value Set](ValueSet-mcode-tnm-primary-tumor-category-vs.md) | This value set is intended to contain allowable values for the T category, according to TNM staging rules. AJCC codes (preferably, version 8 for current cancers) SHOULD be used. |
| [TNM Regional Nodes Category Value Set](ValueSet-mcode-tnm-regional-nodes-category-vs.md) | This value set is intended to contain allowable values for the N category, according to TNM staging rules. AJCC codes (preferably, version 8 for current cancers) SHOULD be used. |
| [Toxicity Severity](ValueSet-toxicityseverity-vs.md) | Toxicity Severity |
| [Unknown|Other](ValueSet-vs-unknownOther-eu-pcsp.md) | Unknown or Other |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Conditions](CodeSystem-ConditionsCS.md) | PancareSurPass Conditions Code System |
| [International Classification of Childhood Cancer, Third Edition](CodeSystem-iccc-3.md) | The International Classification of Childhood Cancer, Third Edition (ICCC-3) is a classification system used to categorize childhood cancers based on their histology and primary site. It is widely used in pediatric oncology for epidemiological studies and clinical research. |
| [International Classification of Diseases for Oncology, Third Edition](CodeSystem-icd-o-3.md) | The International Classification of Diseases for Oncology, Third Edition (ICD-O-3) is a coding system used primarily for classifying and coding neoplasms (tumors) based on their topography (site) and morphology (histology). It is widely used in cancer registries and epidemiological research. |
| [OrphaNet](CodeSystem-OrphaNet.md) | Orphanet selected codes |
| [PCSP Code System](CodeSystem-cs-generic-eu-pcsp.md) | Coded concepts specified by the PancareSurPass Project |
| [PCSP Conditions at risk](CodeSystem-cs-riskcondition-eu-pcsp.md) | Condition at risk proposed by the PCSP algorithm |
| [PCSP Recommendations](CodeSystem-cs-recommendation-eu-pcsp.md) | Recommendations proposed by the PCSP algorithm |
| [Radiotherapy sites](CodeSystem-cs-radiotherapy-pcsp.md) | PancareSurPass radiotherapy sites Code System |
| [Risk Factors](CodeSystem-cs-riskfactor-eu-pcsp.md) | Risk Factors used by the PCSP algorithm |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [Austria - Bundle: Example of a Childhood Cancer Survivor Passport](Bundle-54.md) | Example of a Childhood Cancer Survivor Passport Bundle for the PanCareSurPass project |
| [Cineca - Clinical Protocol](PlanDefinition-3976.md) | Clinical protocol for the CINECA project |
| [Cineca - Patient: Sample of Patient (Rossi)](Patient-PatientCineca.md) | Sample of Patient created based on information available in the PCSP platform |
| [Hulafe - Bundle: Example of a Childhood Cancer Survivor Passport](Bundle-BundleHulafe.md) | Example of a Childhood Cancer Survivor Passport Bundle for the PanCareSurPass project (Hulafe) |
| [Hulafe - CarePlan: Follow-up Recommendations](CarePlan-CarePlanExample-1.md) | Sample of Care Plan generated by the platform |
| [Hulafe - Condition: Primary Diagnosis](Condition-PrimaryCancerHulafe-1.md) | Sample of Primary Diagnosis based on information provided by Hulafe (Condition) |
| [Hulafe - DocumentReference: Preliminary SurPass](DocumentReference-DocumentReferenceExample-1.md) | Sample of DocumentReference used to refer a preliminary SurPass |
| [Hulafe - Encounter: Primary Diagnosis](Encounter-EncHulafe-1.md) | Sample of Primary Diagnosis based on information provided by Hulafe (Encounter) |
| [Hulafe - Location: Chemotherapy](Location-ChemoHulafe-1-Location.md) | Sample of Chemotherapy based on information provided by Hulafe (Location) |
| [Hulafe - MedicationAdministration: Chemotherapy Ciclofosfamide](MedicationAdministration-ChemoHulafe-1-Ciclofosfamide.md) | Sample of Chemotherapy based on information provided by Hulafe (Ciclofosfamide) |
| [Hulafe - MedicationAdministration: Chemotherapy Citarabina](MedicationAdministration-ChemoHulafe-1-Citarabina.md) | Sample of Chemotherapy based on information provided by Hulafe (Citarabina) |
| [Hulafe - MedicationAdministration: Chemotherapy Metotrexato](MedicationAdministration-ChemoHulafe-1-Metotrexato.md) | Sample of Chemotherapy based on information provided by Hulafe (Metotrexato) |
| [Hulafe - MedicationAdministration: Chemotherapy Vincristina](MedicationAdministration-ChemoHulafe-1-Vincristina.md) | Sample of Chemotherapy based on information provided by Hulafe (Vincristina) |
| [Hulafe - MedicationStatement: Chemotherapy Corticosteroids](MedicationStatement-ChemoHulafe-1-corticosteroids.md) | Sample of Chemotherapy based on information provided by Hulafe (Corticosteroids not used for at least 4 weeks continuously) |
| [Hulafe - Observation: Chemotherapy Ciclofosfamide Cumulative Dose](Observation-ChemoHulafe-1-Ciclofosfamide-dose.md) | Sample of Chemotherapy based on information provided by Hulafe (Ciclofosfamide Cumulative Dose) |
| [Hulafe - Observation: Chemotherapy Citarabina Cumulative Dose](Observation-ChemoHulafe-1-Citarabina-dose.md) | Sample of Chemotherapy based on information provided by Hulafe (Citarabina Cumulative Dose) |
| [Hulafe - Observation: Chemotherapy Metotrexato Cumulative Dose](Observation-ChemoHulafe-1-Metotrexato-dose.md) | Sample of Chemotherapy based on information provided by Hulafe (Metotrexato Cumulative Dose) |
| [Hulafe - Observation: Chemotherapy Vincristina Cumulative Dose](Observation-ChemoHulafe-1-Vincristina-dose.md) | Sample of Chemotherapy based on information provided by Hulafe (Vincristina Cumulative Dose) |
| [Hulafe - Observation: Risk Factor Anthracyclines](Observation-ObservationRiskFactor-4.md) | Sample of Risk Factor: Anthracyclines >= 250 mg/m2 |
| [Hulafe - Observation: Risk Factor RT breasts](Observation-ObservationRiskFactor-2.md) | Sample of Risk Factor: RT >= 10 Gy to breasts |
| [Hulafe - Observation: Risk Factor RT heart](Observation-ObservationRiskFactor-3.md) | Sample of Risk Factor: RT >= 35 Gy to heart |
| [Hulafe - Observation: Risk Factor RT thyroid gland](Observation-ObservationRiskFactor-1.md) | Sample of Risk Factor: RT to thyroid gland |
| [Hulafe - Organization: Primary Diagnosis](Organization-OrgHulafe-1.md) | Sample of Primary Diagnosis based on information provided by Hulafe (Organization) |
| [Hulafe - Patient: Sample of Patient (Basoa Mancebo)](Patient-PatientHulafe.md) | Sample of Patient created based on information provided by Hulafe |
| [Hulafe - Patient: Sample of demographics data](Patient-PatientHulafe-1.md) | Sample of Patient demographics data based on information provided by Hulafe |
| [Mainz - BiologicallyDerivedProduct: Stem Cell Transplantation (Zeisig)](BiologicallyDerivedProduct-BiologicallyDerivedProduct-SCT1.md) | Sample of stem cell transplantation biologically derived product (Zeisig) |
| [Mainz - Condition: Primary Cancer (Fischer)](Condition-ConditionPrimCancerMainzFischer.md) | Sample of Primary Cancer Condition based on information available by Mainz (Fischer) |
| [Mainz - Condition: complete Primary Cancer Condition example (TBC) (Zeisig)](Condition-ConditionPrimCancerMainzZeisig.md) | Sample of Primary Cancer Condition based on information available by Mainz (Zeisig) |
| [Mainz - Condition: complete metastatic site Condition example (TBC) (Zeisig)](Condition-ConditionSecCancerMainzZeisig.md) | Sample of metastatic site Condition based on information available by Mainz (Zeisig) |
| [Mainz - Encounter: Primary Cancer (Fischer)](Encounter-EncounterPrimCancerMainzFischer.md) | Sample of Encounter associated to the Primary Cancer Condition Mainz sample (Fischer) |
| [Mainz - Encounter: Primary Cancer (Zeisig)](Encounter-EncounterPrimCancerMainzZeisig.md) | Sample of Encounter associated to the Primary Cancer Condition Mainz sample (Zeisig) |
| [Mainz - Location: Stem Cell Transplantation (Zeisig)](Location-Location-SCT1.md) | Sample of location for stem cell transplantation (Zeisig) |
| [Mainz - Observation: Blood type/RH before the SCT (Zeisig)](Observation-ObservationCBloodSCT-1-1.md) | Sample of blood type/RH observation (Zeisig) |
| [Mainz - Observation: Primary Cancer (Zeisig)](Observation-ObservationPrimCancerMainzZeisig.md) | Sample of Observation associated to the Primary Cancer Condition Mainz sample to provide details about the diagnosis (Zeisig) |
| [Mainz - Observation: Radiotherapy Total Dose (Zeisig)](Observation-ObservationRadTotalDose-1.md) | Sample of radiotherapy total dose observation from Mainz (Zeisig) |
| [Mainz - Patient: Sample of Patient (Fischer)](Patient-PatientMainzFischer.md) | Sample of Patient created based on information provided by Mainz (Fischer) |
| [Mainz - Patient: Sample of Patient (Zeisig)](Patient-PatientMainzZeisig.md) | Sample of Patient created based on information provided by Mainz (Zeisig) |
| [Mainz - Procedure: Radiotherapy (Zeisig)](Procedure-ProcedureRadio-1.md) | Sample of radiotherapy procedure based on information from Mainz (Zeisig) |
| [Mainz - Procedure: Stem Cell Transplantation (Zeisig)](Procedure-ProcedureSTC-1.md) | Sample of stem cell transplantation procedure from Mainz (Zeisig) |
| [Mainz - Procedure: Transfusion (Zeisig)](Procedure-ProcedureTransfusion-1.md) | Sample of transfusion procedure (Zeisig) |
| [Vulsk - Patient: Sample of Patient (Jonaitė)](Patient-PatientVulsk.md) | Sample of Patient created based on information provided by Vulsk |

