# Surgical Procedure Type - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Surgical Procedure Type**

## ValueSet: Surgical Procedure Type 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-surgicalProcedureType-eu-pcsp | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:SurgicalProcedureTypeVs |

 
Types of surgical procedure this resource is referring to 

 **References** 

* [Procedure: Surgery](StructureDefinition-Procedure-surgery-eu-pcsp.md)

### Logical Definition (CLD)

This value set includes codes based on the following rules:

* Import all the codes that are contained in [Shunt Procedure Type](ValueSet-vs-shuntProcedureType-eu-pcsp.md)
* Import all the codes that are contained in [Amputation Surgical Procedure Type](ValueSet-vs-amputationProcedureType-eu-pcsp.md)
* Import all the codes that are contained in [Colostomy Surgical Procedure Type](ValueSet-vs-colostomyProcedureType-eu-pcsp.md)
* Import all the codes that are contained in [Gastrostomy Surgical Procedure Type](ValueSet-vs-gastrostomyProcedureType-eu-pcsp.md)
* Import all the codes that are contained in [Prosthetic Surgical Procedure Type](ValueSet-vs-ProstheticProcedureType-eu-pcsp.md)
* Import all the codes that are contained in http://hl7.org/fhir/uv/ips/ValueSet/absent-or-unknown-procedures-uv-ips

 

### Expansion

No Expansion for this valueset (not supported by Publication Tooling)

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "vs-surgicalProcedureType-eu-pcsp",
  "url" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-surgicalProcedureType-eu-pcsp",
  "version" : "1.0.0",
  "name" : "SurgicalProcedureTypeVs",
  "title" : "Surgical Procedure Type",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "Types of surgical procedure this resource is referring to",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "valueSet" : [
          "http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-shuntProcedureType-eu-pcsp"
        ]
      },
      {
        "valueSet" : [
          "http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-amputationProcedureType-eu-pcsp"
        ]
      },
      {
        "valueSet" : [
          "http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-colostomyProcedureType-eu-pcsp"
        ]
      },
      {
        "valueSet" : [
          "http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-gastrostomyProcedureType-eu-pcsp"
        ]
      },
      {
        "valueSet" : [
          "http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-ProstheticProcedureType-eu-pcsp"
        ]
      },
      {
        "valueSet" : [
          "http://hl7.org/fhir/uv/ips/ValueSet/absent-or-unknown-procedures-uv-ips"
        ]
      }
    ]
  }
}

```
