# Hereditary Predispositions (Orphacode) - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Hereditary Predispositions (Orphacode)**

## ValueSet: Hereditary Predispositions (Orphacode) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-orpha-predisposition-eu-pcsp | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:OrphaHereditaryPredisposition |

 
Hereditary Predispositions (Orphacode) 

 **References** 

* [Observation: Hereditary Predisposition](StructureDefinition-Observation-predisposition-eu-pcsp.md)

### Logical Definition (CLD)

 

### Expansion

This value set contains 78 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "vs-orpha-predisposition-eu-pcsp",
  "url" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-orpha-predisposition-eu-pcsp",
  "version" : "1.0.0",
  "name" : "OrphaHereditaryPredisposition",
  "title" : "Hereditary Predispositions (Orphacode)",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "Hereditary Predispositions (Orphacode)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "https://www.orpha.net",
        "concept" : [
          {
            "code" : "84",
            "display" : "Fanconi anemia"
          },
          {
            "code" : "100",
            "display" : "Ataxia telangiectasia"
          },
          {
            "code" : "109",
            "display" : "Bannayan-Riley-Ruvalcaba syndrome"
          },
          {
            "code" : "116",
            "display" : "Beckwith-Wiedemann syndrome"
          },
          {
            "code" : "122",
            "display" : "Birt-Hogg-Dube´ syndrome"
          },
          {
            "code" : "125",
            "display" : "Bloom syndrome"
          },
          {
            "code" : "144",
            "display" : "Lynch  Syndrome"
          },
          {
            "code" : "145",
            "display" : "Hereditary breast and ovarian cancer syndrome"
          },
          {
            "code" : "201",
            "display" : "Cowden Syndrome"
          },
          {
            "code" : "321",
            "display" : "Multiple osteochondromas"
          },
          {
            "code" : "347",
            "display" : "Frasier syndrome"
          },
          {
            "code" : "373",
            "display" : "Simpson-Golabi-Behmel syndrome"
          },
          {
            "code" : "377",
            "display" : "Gorlin syndrome"
          },
          {
            "code" : "500",
            "display" : "LEOPARD syndrome"
          },
          {
            "code" : "523",
            "display" : "Hereditary leiomyomatosis and renal cell cancer"
          },
          {
            "code" : "524",
            "display" : "Li-Fraumeni Syndrome"
          },
          {
            "code" : "587",
            "display" : "Muir Torre syndrome"
          },
          {
            "code" : "618",
            "display" : "Familial Melanoma"
          },
          {
            "code" : "637",
            "display" : "Neurofibromatosis type 2"
          },
          {
            "code" : "647",
            "display" : "Nijmegen breakage syndrome"
          },
          {
            "code" : "648",
            "display" : "Noonan syndrome"
          },
          {
            "code" : "652",
            "display" : "Multiple endocrine neoplasia type 1"
          },
          {
            "code" : "653",
            "display" : "Multiple endocrine neoplasia type 2"
          },
          {
            "code" : "654",
            "display" : "Nephroblastoma"
          },
          {
            "code" : "660",
            "display" : "Omphalocele"
          },
          {
            "code" : "676",
            "display" : "Hereditary chronic pancreatitis"
          },
          {
            "code" : "733",
            "display" : "Familial adenomatous polyposis"
          },
          {
            "code" : "744",
            "display" : "Proteus syndrome"
          },
          {
            "code" : "805",
            "display" : "Tuberous sclerosis complex"
          },
          {
            "code" : "811",
            "display" : "Shwachman-Diamond syndrome"
          },
          {
            "code" : "821",
            "display" : "Sotos syndrome"
          },
          {
            "code" : "870",
            "display" : "Down syndrome"
          },
          {
            "code" : "881",
            "display" : "Turner syndrome"
          },
          {
            "code" : "892",
            "display" : "von Hippel-Lindau syndrome"
          },
          {
            "code" : "893",
            "display" : "WAGR syndrome"
          },
          {
            "code" : "902",
            "display" : "Werner syndrome"
          },
          {
            "code" : "906",
            "display" : "Wiskott-Aldrich syndrome"
          },
          {
            "code" : "910",
            "display" : "Xeroderma pigmentosum"
          },
          {
            "code" : "1331",
            "display" : "Familial prostate cancer"
          },
          {
            "code" : "1340",
            "display" : "Cardio-Facio-Cutaneous (CFC) syndrome"
          },
          {
            "code" : "1359",
            "display" : "Carney Complex"
          },
          {
            "code" : "1572",
            "display" : "Common variable immune deficiency"
          },
          {
            "code" : "1915",
            "display" : "Fetal alcohol syndrome"
          },
          {
            "code" : "2128",
            "display" : "Isolated Hemihypertrophy"
          },
          {
            "code" : "2346",
            "display" : "Angioosteohypertrophic syndrome"
          },
          {
            "code" : "2442",
            "display" : "X-linked lymphoproliferative syndrome"
          },
          {
            "code" : "2678",
            "display" : "Neurofibromatosis type 6"
          },
          {
            "code" : "2869",
            "display" : "Peutz-Jeghers syndrome"
          },
          {
            "code" : "2909",
            "display" : "Rothmund Thomson syndrome"
          },
          {
            "code" : "2929",
            "display" : "Juvenile polyposis syndrome"
          },
          {
            "code" : "3261",
            "display" : "Autoimmune lymphoproliferative syndrome"
          },
          {
            "code" : "26106",
            "display" : "Hereditary diffuse gastric cancer"
          },
          {
            "code" : "29072",
            "display" : "Hereditary pheochromocytoma-paraganglioma"
          },
          {
            "code" : "44890",
            "display" : "Gastrointestinal stromal tumor"
          },
          {
            "code" : "47044",
            "display" : "Hereditary papillary renal cancer syndrome"
          },
          {
            "code" : "77828",
            "display" : "Genetic obesity"
          },
          {
            "code" : "93460",
            "display" : "Overgrowth syndrome"
          },
          {
            "code" : "97286",
            "display" : "Carney-Stratakis Syndrome"
          },
          {
            "code" : "99817",
            "display" : "Non-polyposis Turcot syndrome"
          },
          {
            "code" : "99818",
            "display" : "Turcot Syndrome with polyposis"
          },
          {
            "code" : "101088",
            "display" : "X-linked hyper-IgM syndrome"
          },
          {
            "code" : "141145",
            "display" : "Hemifacial hyperplasia"
          },
          {
            "code" : "156207",
            "display" : "Macroglossia"
          },
          {
            "code" : "220460",
            "display" : "Attenuated familial adenomatous polyposis"
          },
          {
            "code" : "231040",
            "display" : "Noonan syndrome with multiple lentigines"
          },
          {
            "code" : "231108",
            "display" : "Familial rhabdoid tumor"
          },
          {
            "code" : "251347",
            "display" : "Ataxia-telangiectasia-like disorder"
          },
          {
            "code" : "295049",
            "display" : "Upper limb Hypertrophy"
          },
          {
            "code" : "295051",
            "display" : "Lower limb hypertrophy"
          },
          {
            "code" : "319487",
            "display" : "Familial follicular or papillary thyroid cancer"
          },
          {
            "code" : "331223",
            "display" : "Hyper IgE Syndrome (HIES)"
          },
          {
            "code" : "357027",
            "display" : "Hereditary retinoblastoma"
          },
          {
            "code" : "363700",
            "display" : "Neurofibromatosis type 1 due to NF1 mutation or intragenic deletion"
          },
          {
            "code" : "404560",
            "display" : "Familial atypical multiple mole melanoma syndrome"
          },
          {
            "code" : "423776",
            "display" : "Hereditary gastric cancer"
          },
          {
            "code" : "443909",
            "display" : "Hereditary nonpolyposis colon cancer"
          },
          {
            "code" : "458830",
            "display" : "Rare capillary malformation with associated anomalies"
          }
        ]
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-NullFlavor",
        "concept" : [
          {
            "code" : "OTH",
            "display" : "Other"
          }
        ]
      }
    ]
  }
}

```
