# Hereditary Predispositions (ICD10) - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Hereditary Predispositions (ICD10)**

## ValueSet: Hereditary Predispositions (ICD10) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-icd10-predisposition-eu-pcsp | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:ICD10HereditaryPredisposition |

 
Hereditary Predispositions (ICD10) 

 **References** 

* [Observation: Hereditary Predisposition](StructureDefinition-Observation-predisposition-eu-pcsp.md)

### Logical Definition (CLD)

 

### Expansion

Expansion from tx.fhir.org based on:

* codesystem ICD-10 version 2019-covid-expanded
* [codesystem DataAbsentReason v1.0.0 (CodeSystem)](http://terminology.hl7.org/6.5.0/CodeSystem-data-absent-reason.html)

This value set contains 17 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "vs-icd10-predisposition-eu-pcsp",
  "url" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-icd10-predisposition-eu-pcsp",
  "version" : "1.0.0",
  "name" : "ICD10HereditaryPredisposition",
  "title" : "Hereditary Predispositions (ICD10)",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "Hereditary Predispositions (ICD10)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/data-absent-reason",
        "concept" : [
          {
            "code" : "not-applicable"
          }
        ]
      },
      {
        "system" : "http://hl7.org/fhir/sid/icd-10",
        "concept" : [
          {
            "code" : "D61.0",
            "display" : "Constitutional aplastic anemia"
          },
          {
            "code" : "D82.0",
            "display" : "Wiskott-Aldrich syndrome"
          },
          {
            "code" : "D82.3",
            "display" : "Immunodeficiency following hereditary defective response to Epstein-Barr virus"
          },
          {
            "code" : "E34.8",
            "display" : "Other specified endocrine disorders"
          },
          {
            "code" : "G11.3",
            "display" : "Cerebellar ataxia with defective DNA repair"
          },
          {
            "code" : "K86.1",
            "display" : "Other chronic pancreatitis"
          },
          {
            "code" : "L72.8",
            "display" : "Other follicular cysts of the skin and subcutaneous tissue"
          },
          {
            "code" : "Q78.6",
            "display" : "Multiple congenital exostoses"
          },
          {
            "code" : "Q82.1",
            "display" : "Xeroderma pigmentosum"
          },
          {
            "code" : "Q82.2",
            "display" : "Congenital cutaneous mastocytosis"
          },
          {
            "code" : "Q82.8",
            "display" : "Other specified congenital malformations of skin"
          },
          {
            "code" : "Q85.0",
            "display" : "Neurofibromatosis (nonmalignant)"
          },
          {
            "code" : "Q85.1",
            "display" : "Tuberous sclerosis"
          },
          {
            "code" : "Q85.8",
            "display" : "Other phakomatoses, not elsewhere classified"
          },
          {
            "code" : "Q87.3",
            "display" : "Congenital malformation syndromes involving early overgrowth"
          },
          {
            "code" : "Q87.8",
            "display" : "Other specified congenital malformation syndromes, not elsewhere classified"
          }
        ]
      }
    ]
  }
}

```
