# Document Type - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Document Type**

## ValueSet: Document Type 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-docref-doctype-eu-pcsp | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:DocRefDocType |

 
Types of documents exchanged with the PCSP platform 

 **References** 

* [DocumentReference: PCSP](StructureDefinition-DocumentReference-eu-pcsp.md)

### Logical Definition (CLD)

 

### Expansion

This value set contains 4 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "vs-docref-doctype-eu-pcsp",
  "url" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-docref-doctype-eu-pcsp",
  "version" : "1.0.0",
  "name" : "DocRefDocType",
  "title" : "Document Type",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "Types of documents exchanged with the PCSP platform",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://hl7.eu/fhir/ig/pcsp/CodeSystem/cs-generic-eu-pcsp",
        "concept" : [
          {
            "code" : "surpass",
            "display" : "Childhood Cancer Survivor Passport"
          }
        ]
      },
      {
        "system" : "http://loinc.org",
        "concept" : [
          {
            "code" : "18748-4",
            "display" : "Diagnostic Imaging Report"
          },
          {
            "code" : "34105-7",
            "display" : "Hospital Discharge summary"
          },
          {
            "code" : "11502-2",
            "display" : "LABORATORY REPORT.TOTAL"
          }
        ]
      }
    ]
  }
}

```
