# Antineoplastic and immunostimulating agents - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Antineoplastic and immunostimulating agents**

## ValueSet: Antineoplastic and immunostimulating agents 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/ValueSet/drugsAtc-eu-pcsp | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:VsPcspAtcCodes |

 
List of WHO ATC codes for antineoplastic and immunostimulating agents. 

 **References** 

* [MedicationAdministration: Chemotherapy](StructureDefinition-MedicationAdministration-eu-pcsp.md)

### Logical Definition (CLD)

 

### Expansion

Expansion from tx.fhir.org based on codesystem WHO ATC version 2025

This value set contains 320 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "drugsAtc-eu-pcsp",
  "url" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/drugsAtc-eu-pcsp",
  "version" : "1.0.0",
  "name" : "VsPcspAtcCodes",
  "title" : "Antineoplastic and immunostimulating agents",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "List of WHO ATC codes for antineoplastic and immunostimulating agents.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://www.whocc.no/atc",
        "concept" : [
          {
            "code" : "L01AA01",
            "display" : "Cyclophosphamide"
          },
          {
            "code" : "L01AA02",
            "display" : "Chlorambucil"
          },
          {
            "code" : "L01AA03",
            "display" : "Melphalan"
          },
          {
            "code" : "L01AA05",
            "display" : "Chlormethine"
          },
          {
            "code" : "L01AA06",
            "display" : "Ifosfamide"
          },
          {
            "code" : "L01AA07",
            "display" : "Trofosfamide"
          },
          {
            "code" : "L01AA08",
            "display" : "Prednimustine"
          },
          {
            "code" : "L01AA09",
            "display" : "Bendamustine"
          },
          {
            "code" : "L01AB01",
            "display" : "Busulfan"
          },
          {
            "code" : "L01AB02",
            "display" : "Treosulfan"
          },
          {
            "code" : "L01AB03",
            "display" : "Mannosulfan"
          },
          {
            "code" : "L01AC01",
            "display" : "Thiotepa"
          },
          {
            "code" : "L01AC02",
            "display" : "Triaziquone"
          },
          {
            "code" : "L01AC03",
            "display" : "Carboquone"
          },
          {
            "code" : "L01AD01",
            "display" : "Carmustine"
          },
          {
            "code" : "L01AD02",
            "display" : "Lomustine"
          },
          {
            "code" : "L01AD03",
            "display" : "Semustine"
          },
          {
            "code" : "L01AD04",
            "display" : "Streptozocin"
          },
          {
            "code" : "L01AD05",
            "display" : "Fotemustine"
          },
          {
            "code" : "L01AD06",
            "display" : "Nimustine"
          },
          {
            "code" : "L01AD07",
            "display" : "Ranimustine"
          },
          {
            "code" : "L01AG01",
            "display" : "Etoglucid"
          },
          {
            "code" : "L01AX",
            "display" : "Peptichemio"
          },
          {
            "code" : "L01AX01",
            "display" : "Mitobronitol"
          },
          {
            "code" : "L01AX02",
            "display" : "Pipobroman"
          },
          {
            "code" : "L01AX03",
            "display" : "Temozolomide"
          },
          {
            "code" : "L01AX04",
            "display" : "Dacarbazine"
          },
          {
            "code" : "L01BA01",
            "display" : "Methotrexate"
          },
          {
            "code" : "L01BA03",
            "display" : "Raltitrexed"
          },
          {
            "code" : "L01BA04",
            "display" : "Pemetrexed"
          },
          {
            "code" : "L01BA05",
            "display" : "Pralatrexate"
          },
          {
            "code" : "L01BB02",
            "display" : "Mercaptopurine"
          },
          {
            "code" : "L01BB03",
            "display" : "Thioguanine"
          },
          {
            "code" : "L01BB04",
            "display" : "Cladribine"
          },
          {
            "code" : "L01BB05",
            "display" : "Fludarabine"
          },
          {
            "code" : "L01BB06",
            "display" : "Clofarabine"
          },
          {
            "code" : "L01BB07",
            "display" : "Nelarabine"
          },
          {
            "code" : "L01BC01",
            "display" : "Cytarabine"
          },
          {
            "code" : "L01BC02",
            "display" : "Fluorouracil"
          },
          {
            "code" : "L01BC03",
            "display" : "Tegafur"
          },
          {
            "code" : "L01BC04",
            "display" : "Carmofur"
          },
          {
            "code" : "L01BC05",
            "display" : "Gemcitabine"
          },
          {
            "code" : "L01BC06",
            "display" : "Capecitabine"
          },
          {
            "code" : "L01BC07",
            "display" : "Azacitidine"
          },
          {
            "code" : "L01BC08",
            "display" : "Decitabine"
          },
          {
            "code" : "L01BC52",
            "display" : "Fluorouracil, combinations"
          },
          {
            "code" : "L01BC53",
            "display" : "Tegafur, combinations"
          },
          {
            "code" : "L01BC59",
            "display" : "Trifluridine, combinations"
          },
          {
            "code" : "L01CA01",
            "display" : "Vinblastine"
          },
          {
            "code" : "L01CA02",
            "display" : "Vincristine"
          },
          {
            "code" : "L01CA03",
            "display" : "Vindesine"
          },
          {
            "code" : "L01CA04",
            "display" : "Vinorelbine"
          },
          {
            "code" : "L01CA05",
            "display" : "Vinflunine"
          },
          {
            "code" : "L01CA06",
            "display" : "Vintafolide"
          },
          {
            "code" : "L01CB01",
            "display" : "Etoposide"
          },
          {
            "code" : "L01CB02",
            "display" : "Teniposide"
          },
          {
            "code" : "L01CC01",
            "display" : "Demecolcine"
          },
          {
            "code" : "L01CD01",
            "display" : "Paclitaxel"
          },
          {
            "code" : "L01CD02",
            "display" : "Docetaxel"
          },
          {
            "code" : "L01CD03",
            "display" : "Paclitaxel poliglumex"
          },
          {
            "code" : "L01CD04",
            "display" : "Cabazitaxel"
          },
          {
            "code" : "L01CX01",
            "display" : "Trabectedin"
          },
          {
            "code" : "L01DA01",
            "display" : "Dactinomycin"
          },
          {
            "code" : "L01DB01",
            "display" : "Doxorubicin"
          },
          {
            "code" : "L01DB02",
            "display" : "Daunorubicin"
          },
          {
            "code" : "L01DB03",
            "display" : "Epirubicin"
          },
          {
            "code" : "L01DB04",
            "display" : "Aclarubicin"
          },
          {
            "code" : "L01DB05",
            "display" : "Zorubicin"
          },
          {
            "code" : "L01DB06",
            "display" : "Idarubicin"
          },
          {
            "code" : "L01DB07",
            "display" : "Mitoxantrone"
          },
          {
            "code" : "L01DB08",
            "display" : "Pirarubicin"
          },
          {
            "code" : "L01DB09",
            "display" : "Valrubicin"
          },
          {
            "code" : "L01DB10",
            "display" : "Amrubicin"
          },
          {
            "code" : "L01DB11",
            "display" : "Pixantrone"
          },
          {
            "code" : "L01DC01",
            "display" : "Bleomycin"
          },
          {
            "code" : "L01DC02",
            "display" : "Mithramycin"
          },
          {
            "code" : "L01DC03",
            "display" : "Mitomycin"
          },
          {
            "code" : "L01DC04",
            "display" : "Ixabepilone"
          },
          {
            "code" : "L01XA01",
            "display" : "Cisplatin"
          },
          {
            "code" : "L01XA02",
            "display" : "Carboplatin"
          },
          {
            "code" : "L01XA03",
            "display" : "Oxaliplatin"
          },
          {
            "code" : "L01XA04",
            "display" : "Satraplatin"
          },
          {
            "code" : "L01XA05",
            "display" : "Polyplatillen"
          },
          {
            "code" : "L01XB01",
            "display" : "Procarbazine"
          },
          {
            "code" : "L01FX01",
            "display" : "Edrecolomab"
          },
          {
            "code" : "L01FA01",
            "display" : "Rituximab"
          },
          {
            "code" : "L01FD01",
            "display" : "Trastuzumab"
          },
          {
            "code" : "L04AG06",
            "display" : "Alemtuzumab"
          },
          {
            "code" : "L01FX02",
            "display" : "Gemtuzumab"
          },
          {
            "code" : "L01FE01",
            "display" : "Cetuximab"
          },
          {
            "code" : "L01FG01",
            "display" : "Bevacizumab"
          },
          {
            "code" : "L01FE02",
            "display" : "Panitumumab"
          },
          {
            "code" : "L01FX03",
            "display" : "Catumaxomab"
          },
          {
            "code" : "L01FA02",
            "display" : "Ofatumumab"
          },
          {
            "code" : "L01FX04",
            "display" : "Ipilimumab"
          },
          {
            "code" : "L01FX05",
            "display" : "Brentuximab vedotin"
          },
          {
            "code" : "L01FD02",
            "display" : "Pertuzumab"
          },
          {
            "code" : "L01FD03",
            "display" : "Trastuzumab emtansine"
          },
          {
            "code" : "L01FA03",
            "display" : "Obinutuzumab"
          },
          {
            "code" : "L01FX06",
            "display" : "Dinutuximab"
          },
          {
            "code" : "L01FF01",
            "display" : "Nivolumab"
          },
          {
            "code" : "L01FF02",
            "display" : "Pembrolizumab"
          },
          {
            "code" : "L01FX07",
            "display" : "Blinatumomab"
          },
          {
            "code" : "L01FG02",
            "display" : "Ramucirumab"
          },
          {
            "code" : "L01FE03",
            "display" : "Necitumumab"
          },
          {
            "code" : "L01FX08",
            "display" : "Elotuzumab"
          },
          {
            "code" : "L01FC01",
            "display" : "Daratumumab"
          },
          {
            "code" : "L01FX09",
            "display" : "Mogamulizumab"
          },
          {
            "code" : "L01FB01",
            "display" : "Inotuzumab ozogamicin"
          },
          {
            "code" : "L01FX10",
            "display" : "Olaratumab"
          },
          {
            "code" : "L01XD01",
            "display" : "Porfimer sodium"
          },
          {
            "code" : "L01XD03",
            "display" : "Methyl aminolevulinate"
          },
          {
            "code" : "L01XD04",
            "display" : "Aminolevulinic acid"
          },
          {
            "code" : "L01XD05",
            "display" : "Temoporfin"
          },
          {
            "code" : "L01XD06",
            "display" : "Efaproxiral"
          },
          {
            "code" : "L01EA01",
            "display" : "Imatinib"
          },
          {
            "code" : "L01EB01",
            "display" : "Gefitinib"
          },
          {
            "code" : "L01EB02",
            "display" : "Erlotinib"
          },
          {
            "code" : "L01EX01",
            "display" : "Sunitinib"
          },
          {
            "code" : "L01EX02",
            "display" : "Sorafenib"
          },
          {
            "code" : "L01EA02",
            "display" : "Dasatinib"
          },
          {
            "code" : "L01EH01",
            "display" : "Lapatinib"
          },
          {
            "code" : "L01EA03",
            "display" : "Nilotinib"
          },
          {
            "code" : "L01EG01",
            "display" : "Temsirolimus"
          },
          {
            "code" : "L01EG02",
            "display" : "Everolimus"
          },
          {
            "code" : "L01EX03",
            "display" : "Pazopanib"
          },
          {
            "code" : "L01EX04",
            "display" : "Vandetanib"
          },
          {
            "code" : "L01EB03",
            "display" : "Afatinib"
          },
          {
            "code" : "L01EA04",
            "display" : "Bosutinib"
          },
          {
            "code" : "L01EC01",
            "display" : "Vemurafenib"
          },
          {
            "code" : "L01ED01",
            "display" : "Crizotinib"
          },
          {
            "code" : "L01EK01",
            "display" : "Axitinib"
          },
          {
            "code" : "D11AH09",
            "display" : "Ruxolitinib"
          },
          {
            "code" : "L01EG03",
            "display" : "Ridaforolimus"
          },
          {
            "code" : "L01EX05",
            "display" : "Regorafenib"
          },
          {
            "code" : "L01EX06",
            "display" : "Masitinib"
          },
          {
            "code" : "L01EC02",
            "display" : "Dabrafenib"
          },
          {
            "code" : "L01EA05",
            "display" : "Ponatinib"
          },
          {
            "code" : "L01EE01",
            "display" : "Trametinib"
          },
          {
            "code" : "L01EX07",
            "display" : "Cabozantinib"
          },
          {
            "code" : "L01EL01",
            "display" : "Ibrutinib"
          },
          {
            "code" : "L01ED02",
            "display" : "Ceritinib"
          },
          {
            "code" : "L01EX08",
            "display" : "Lenvatinib"
          },
          {
            "code" : "L01EX09",
            "display" : "Nintedanib"
          },
          {
            "code" : "L01EK02",
            "display" : "Cediranib"
          },
          {
            "code" : "L01EF01",
            "display" : "Palbociclib"
          },
          {
            "code" : "L01EK03",
            "display" : "Tivozanib"
          },
          {
            "code" : "L01EB04",
            "display" : "Osimertinib"
          },
          {
            "code" : "L01ED03",
            "display" : "Alectinib"
          },
          {
            "code" : "L01EB05",
            "display" : "Rociletinib"
          },
          {
            "code" : "L01EE02",
            "display" : "Cobimetinib"
          },
          {
            "code" : "L01EX10",
            "display" : "Midostaurin"
          },
          {
            "code" : "L01EB06",
            "display" : "Olmutinib"
          },
          {
            "code" : "L01XX",
            "display" : "Other antineoplastic agent"
          },
          {
            "code" : "L01XX01",
            "display" : "Amsacrine"
          },
          {
            "code" : "L01XX02",
            "display" : "Asparaginase"
          },
          {
            "code" : "L01XX03",
            "display" : "Altretamine"
          },
          {
            "code" : "L01XX05",
            "display" : "Hydroxycarbamide"
          },
          {
            "code" : "L01XX07",
            "display" : "Lonidamine"
          },
          {
            "code" : "L01XX08",
            "display" : "Pentostatin"
          },
          {
            "code" : "P01CX04",
            "display" : "Miltefosine"
          },
          {
            "code" : "L01XX10",
            "display" : "Masoprocol"
          },
          {
            "code" : "L01XX11",
            "display" : "Estramustine"
          },
          {
            "code" : "D10AD01",
            "display" : "Tretinoin"
          },
          {
            "code" : "L01XX16",
            "display" : "Mitoguazone"
          },
          {
            "code" : "L01CE01",
            "display" : "Topotecan"
          },
          {
            "code" : "L01XX18",
            "display" : "Tiazofurine"
          },
          {
            "code" : "L01CE02",
            "display" : "Irinotecan"
          },
          {
            "code" : "D11AH04",
            "display" : "Alitretinoin"
          },
          {
            "code" : "L01XX23",
            "display" : "Mitotane"
          },
          {
            "code" : "L01XX24",
            "display" : "Pegaspargase"
          },
          {
            "code" : "L01XF03",
            "display" : "Bexarotene"
          },
          {
            "code" : "L01XX27",
            "display" : "Arsenic trioxide"
          },
          {
            "code" : "L01XX29",
            "display" : "Denileukin diftitox"
          },
          {
            "code" : "L01XG01",
            "display" : "Bortezomib"
          },
          {
            "code" : "L01XX33",
            "display" : "Celecoxib"
          },
          {
            "code" : "L01XX35",
            "display" : "Anagrelide"
          },
          {
            "code" : "L01XX36",
            "display" : "Oblimersen"
          },
          {
            "code" : "L01XL01",
            "display" : "Sitimagene ceradenovec"
          },
          {
            "code" : "L01XH01",
            "display" : "Vorinostat"
          },
          {
            "code" : "L01XH02",
            "display" : "Romidepsin"
          },
          {
            "code" : "L01XX40",
            "display" : "Omacetaxine mepesuccinate"
          },
          {
            "code" : "L01XX41",
            "display" : "Eribulin"
          },
          {
            "code" : "L01XH03",
            "display" : "Panobinostat"
          },
          {
            "code" : "L01XJ01",
            "display" : "Vismodegib"
          },
          {
            "code" : "L01XX44",
            "display" : "Aflibercept"
          },
          {
            "code" : "L01XG02",
            "display" : "Carfilzomib"
          },
          {
            "code" : "L01XK01",
            "display" : "Olaparib"
          },
          {
            "code" : "L01EM01",
            "display" : "Idelalisib"
          },
          {
            "code" : "L01XJ02",
            "display" : "Sonidegib"
          },
          {
            "code" : "L01XH04",
            "display" : "Belinostat"
          },
          {
            "code" : "L01XG03",
            "display" : "Ixazomib"
          },
          {
            "code" : "L01XL02",
            "display" : "Talimogene laherparepvec"
          },
          {
            "code" : "L01XX52",
            "display" : "Venetoclax"
          },
          {
            "code" : "L01XX53",
            "display" : "Vosaroxin"
          },
          {
            "code" : "L01XY",
            "display" : "Combination of antineoplastic agents"
          },
          {
            "code" : "G03CB02",
            "display" : "Diethylstilbestrol"
          },
          {
            "code" : "L02AA02",
            "display" : "Polyestradiol phosphate"
          },
          {
            "code" : "G03CA01",
            "display" : "Ethinylestradiol"
          },
          {
            "code" : "L02AA04",
            "display" : "Fosfestrol"
          },
          {
            "code" : "G03AC05",
            "display" : "Megestrol"
          },
          {
            "code" : "G03AC06",
            "display" : "Medroxyprogesterone"
          },
          {
            "code" : "G03DA01",
            "display" : "Gestonorone"
          },
          {
            "code" : "L02AE01",
            "display" : "Buserelin"
          },
          {
            "code" : "L02AE02",
            "display" : "Leuprorelin"
          },
          {
            "code" : "L02AE03",
            "display" : "Goserelin"
          },
          {
            "code" : "L02AE04",
            "display" : "Triptorelin"
          },
          {
            "code" : "L02AE05",
            "display" : "Histrelin"
          },
          {
            "code" : "L02BA01",
            "display" : "Tamoxifen"
          },
          {
            "code" : "L02BA02",
            "display" : "Toremifene"
          },
          {
            "code" : "L02BA03",
            "display" : "Fulvestrant"
          },
          {
            "code" : "L02BB01",
            "display" : "Flutamide"
          },
          {
            "code" : "L02BB02",
            "display" : "Nilutamide"
          },
          {
            "code" : "L02BB03",
            "display" : "Bicalutamide"
          },
          {
            "code" : "L02BB04",
            "display" : "Enzalutamide"
          },
          {
            "code" : "L02BG01",
            "display" : "Aminogluthetimide"
          },
          {
            "code" : "L02BG02",
            "display" : "Formestane"
          },
          {
            "code" : "L02BG03",
            "display" : "Anastrozole"
          },
          {
            "code" : "L02BG04",
            "display" : "Letrozole"
          },
          {
            "code" : "L02BG05",
            "display" : "Vorozole"
          },
          {
            "code" : "L02BG06",
            "display" : "Exemestane"
          },
          {
            "code" : "L02BX01",
            "display" : "Abarelix"
          },
          {
            "code" : "L02BX02",
            "display" : "Degarelix"
          },
          {
            "code" : "L02BX03",
            "display" : "Abiraterone"
          },
          {
            "code" : "L03AA02",
            "display" : "Filgrastim"
          },
          {
            "code" : "L03AA03",
            "display" : "Molgramostim"
          },
          {
            "code" : "L03AA09",
            "display" : "Sargramostim"
          },
          {
            "code" : "L03AA10",
            "display" : "Lenograstim"
          },
          {
            "code" : "L03AA12",
            "display" : "Ancestim"
          },
          {
            "code" : "L03AA13",
            "display" : "Pegfilgrastim"
          },
          {
            "code" : "L03AA14",
            "display" : "Lipegfilgrastim"
          },
          {
            "code" : "L03AA15",
            "display" : "Balugrastim"
          },
          {
            "code" : "L03AA16",
            "display" : "Empegfilgrastim"
          },
          {
            "code" : "L03AB01",
            "display" : "Interferon alfa natural"
          },
          {
            "code" : "L03AB02",
            "display" : "Interferon beta natural"
          },
          {
            "code" : "L03AB03",
            "display" : "Interferon gamma"
          },
          {
            "code" : "L03AB04",
            "display" : "Interferon alfa-2a"
          },
          {
            "code" : "L03AB05",
            "display" : "Interferon alfa-2b"
          },
          {
            "code" : "L03AB06",
            "display" : "Interferon alfa-n1"
          },
          {
            "code" : "L03AB07",
            "display" : "Interferon beta-1a"
          },
          {
            "code" : "L03AB08",
            "display" : "Interferon beta-1b"
          },
          {
            "code" : "L03AB09",
            "display" : "Interferon alfacon-1"
          },
          {
            "code" : "L03AB10",
            "display" : "Peginterferon alfa-2b"
          },
          {
            "code" : "L03AB11",
            "display" : "Peginterferon alfa-2a"
          },
          {
            "code" : "L03AB12",
            "display" : "Albinterferon alfa-2b"
          },
          {
            "code" : "L03AB13",
            "display" : "Peginterferon beta-1a"
          },
          {
            "code" : "L03AB14",
            "display" : "Cepeginterferon alfa-2b"
          },
          {
            "code" : "L03AB60",
            "display" : "Peginterferon alfa-2b, combinations"
          },
          {
            "code" : "L03AB61",
            "display" : "Peginterferon alfa-2a, combinations"
          },
          {
            "code" : "L03AC01",
            "display" : "Aldesleukin"
          },
          {
            "code" : "L03AC02",
            "display" : "Oprelvekin"
          },
          {
            "code" : "L03AX01",
            "display" : "Lentinan"
          },
          {
            "code" : "L03AX02",
            "display" : "Roquinimex"
          },
          {
            "code" : "L03AX03",
            "display" : "BCG vaccine"
          },
          {
            "code" : "L03AX04",
            "display" : "Pegademase"
          },
          {
            "code" : "L03AX05",
            "display" : "Pidotimod"
          },
          {
            "code" : "L03AX07",
            "display" : "Poly I:C"
          },
          {
            "code" : "L03AX08",
            "display" : "Poly ICLC"
          },
          {
            "code" : "L03AX09",
            "display" : "Thymopentin"
          },
          {
            "code" : "L03AX10",
            "display" : "Immunocyanin"
          },
          {
            "code" : "L03AX11",
            "display" : "Tasonermin"
          },
          {
            "code" : "L03AX12",
            "display" : "Melanoma vaccine"
          },
          {
            "code" : "L03AX13",
            "display" : "Glatiramer acetate"
          },
          {
            "code" : "L03AX14",
            "display" : "Histamine dihydrochloride"
          },
          {
            "code" : "L03AX15",
            "display" : "Mifamurtide"
          },
          {
            "code" : "L03AX16",
            "display" : "Plerixafor"
          },
          {
            "code" : "L03AX17",
            "display" : "Sipuleucel-T"
          },
          {
            "code" : "L03AX18",
            "display" : "Cridanimod"
          },
          {
            "code" : "L03AX19",
            "display" : "Dasiprotimut-T"
          },
          {
            "code" : "L04AG01",
            "display" : "Muromonab-CD3"
          },
          {
            "code" : "L04AA03",
            "display" : "Antilymphocyte immunoglobulin (horse)"
          },
          {
            "code" : "L04AA04",
            "display" : "Antithymocyte immunoglobulin (rabbit)"
          },
          {
            "code" : "L04AA06",
            "display" : "Mycophenolic acid"
          },
          {
            "code" : "L01EG04",
            "display" : "Sirolimus"
          },
          {
            "code" : "L04AK01",
            "display" : "Leflunomide"
          },
          {
            "code" : "L04AA15",
            "display" : "Alefacept"
          },
          {
            "code" : "L04AA19",
            "display" : "Gusperimus"
          },
          {
            "code" : "L04AG02",
            "display" : "Efalizumab"
          },
          {
            "code" : "L04AA22",
            "display" : "Abetimus"
          },
          {
            "code" : "L04AG03",
            "display" : "Natalizumab"
          },
          {
            "code" : "L04AA24",
            "display" : "Abatacept"
          },
          {
            "code" : "L04AJ01",
            "display" : "Eculizumab"
          },
          {
            "code" : "L04AG04",
            "display" : "Belimumab"
          },
          {
            "code" : "L04AE01",
            "display" : "Fingolimod"
          },
          {
            "code" : "L04AA28",
            "display" : "Belatacept"
          },
          {
            "code" : "L04AF01",
            "display" : "Tofacitinib"
          },
          {
            "code" : "L04AK02",
            "display" : "Teriflunomide"
          },
          {
            "code" : "L04AA32",
            "display" : "Apremilast"
          },
          {
            "code" : "L04AG05",
            "display" : "Vedolizumab"
          },
          {
            "code" : "L04AG07",
            "display" : "Begelomab"
          },
          {
            "code" : "L04AG08",
            "display" : "Ocrelizumab"
          },
          {
            "code" : "L04AF02",
            "display" : "Baricitinib"
          },
          {
            "code" : "L04AB01",
            "display" : "Etanercept"
          },
          {
            "code" : "L04AB02",
            "display" : "Infliximab"
          },
          {
            "code" : "L04AB03",
            "display" : "Afelimomab"
          },
          {
            "code" : "L04AB04",
            "display" : "Adalimumab"
          },
          {
            "code" : "L04AB05",
            "display" : "Certolizumab pegol"
          },
          {
            "code" : "L04AB06",
            "display" : "Golimumab"
          },
          {
            "code" : "L04AC01",
            "display" : "Daclizumab"
          },
          {
            "code" : "L04AC02",
            "display" : "Basiliximab"
          },
          {
            "code" : "L04AC03",
            "display" : "Anakinra"
          },
          {
            "code" : "L04AC04",
            "display" : "Rilonacept"
          },
          {
            "code" : "L04AC05",
            "display" : "Ustekinumab"
          },
          {
            "code" : "R03DX09",
            "display" : "Mepolizumab"
          },
          {
            "code" : "L04AC07",
            "display" : "Tocilizumab"
          },
          {
            "code" : "L04AC08",
            "display" : "Canakinumab"
          },
          {
            "code" : "L04AC09",
            "display" : "Briakinumab"
          },
          {
            "code" : "L04AC10",
            "display" : "Secukinumab"
          },
          {
            "code" : "L04AC11",
            "display" : "Siltuximab"
          },
          {
            "code" : "L04AC12",
            "display" : "Brodalumab"
          },
          {
            "code" : "L04AC13",
            "display" : "Ixekizumab"
          },
          {
            "code" : "L04AC14",
            "display" : "Sarilumab"
          },
          {
            "code" : "L04AD01",
            "display" : "Ciclosporin"
          },
          {
            "code" : "D11AH01",
            "display" : "Tacrolimus"
          },
          {
            "code" : "L04AD03",
            "display" : "Voclosporin"
          },
          {
            "code" : "L04AX01",
            "display" : "Azathioprine"
          },
          {
            "code" : "L04AX02",
            "display" : "Thalidomide"
          },
          {
            "code" : "L04AX04",
            "display" : "Lenalidomide"
          },
          {
            "code" : "L04AX05",
            "display" : "Pirfenidone"
          },
          {
            "code" : "L04AX06",
            "display" : "Pomalidomide"
          }
        ]
      }
    ]
  }
}

```
