# Sacrified organ - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Sacrified organ**

## Extension: Sacrified organ 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/StructureDefinition/surgery-sacrifiedOrgan | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:SacrifiedOrgan |

Organs are 'sacrified' either to allow a radical excision of the tumor or on purpose (spleen) for staging procedures

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [Procedure: Surgery](StructureDefinition-Procedure-surgery-eu-pcsp.md)
* Examples for this Extension: [Bundle/54](Bundle-54.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.pcsp|current/StructureDefinition/surgery-sacrifiedOrgan)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-surgery-sacrifiedOrgan.csv), [Excel](StructureDefinition-surgery-sacrifiedOrgan.xlsx), [Schematron](StructureDefinition-surgery-sacrifiedOrgan.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "surgery-sacrifiedOrgan",
  "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/surgery-sacrifiedOrgan",
  "version" : "1.0.0",
  "name" : "SacrifiedOrgan",
  "title" : "Sacrified organ",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "Organs are 'sacrified' either to allow a radical excision of the tumor or on purpose (spleen) for staging procedures",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Procedure"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Sacrified organ",
        "definition" : "Organs are 'sacrified' either to allow a radical excision of the tumor or on purpose (spleen) for staging procedures"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/surgery-sacrifiedOrgan"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-sacrifiedOrgan-eu-pcsp"
        }
      }
    ]
  }
}

```
