# Stem Cell Source Type - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Stem Cell Source Type**

## Extension: Stem Cell Source Type 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/StructureDefinition/sct-source-type | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:SctSourceType |

Specify the type of source for the cell used in a transplantation

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [BiologicallyDerivedProduct: Stem Cell](StructureDefinition-BiologicallyDerivedProduct-sct-eu-pcsp.md)
* Examples for this Extension: [BiologicallyDerivedProduct/BiologicallyDerivedProduct-SCT1](BiologicallyDerivedProduct-BiologicallyDerivedProduct-SCT1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.pcsp|current/StructureDefinition/sct-source-type)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-sct-source-type.csv), [Excel](StructureDefinition-sct-source-type.xlsx), [Schematron](StructureDefinition-sct-source-type.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "sct-source-type",
  "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/sct-source-type",
  "version" : "1.0.0",
  "name" : "SctSourceType",
  "title" : "Stem Cell Source Type",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "Specify the type of source for the cell used in a transplantation",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Element"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Stem Cell Source Type",
        "definition" : "Specify the type of source for the cell used in a transplantation"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/sct-source-type"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      }
    ]
  }
}

```
