# Not affected Organ - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Not affected Organ**

## Extension: Not affected Organ 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/StructureDefinition/procedure-notAffectedOrgan | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:NotAffectedOrgan |

This extension is used to explicitly indicate the Organ (body site) that has not been affected by this procedure.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [Procedure: Surgery](StructureDefinition-Procedure-surgery-eu-pcsp.md)
* Examples for this Extension: [Bundle/54](Bundle-54.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.pcsp|current/StructureDefinition/procedure-notAffectedOrgan)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-procedure-notAffectedOrgan.csv), [Excel](StructureDefinition-procedure-notAffectedOrgan.xlsx), [Schematron](StructureDefinition-procedure-notAffectedOrgan.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "procedure-notAffectedOrgan",
  "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/procedure-notAffectedOrgan",
  "version" : "1.0.0",
  "name" : "NotAffectedOrgan",
  "title" : "Not affected Organ",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "This extension is used to explicitly indicate the Organ (body site) that has not been affected by this procedure.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Procedure"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Not affected Organ",
        "definition" : "This extension is used to explicitly indicate the Organ (body site) that has not been affected by this procedure."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/procedure-notAffectedOrgan"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-affectedOrgan-eu-pcsp"
        }
      }
    ]
  }
}

```
