# Laterality Qualifier - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Laterality Qualifier**

## Extension: Laterality Qualifier 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/StructureDefinition/mcode-laterality-qualifier | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:LateralityQualifier |

Qualifier to specify laterality.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [Condition: Primary Cancer](StructureDefinition-Condition-primaryCancer-eu-pcsp.md), [Condition: Metastatic Cancer](StructureDefinition-Condition-secondaryCancer-eu-pcsp.md), [Observation: Radiotherapy Total Dose PCSP](StructureDefinition-Observation-totalDoseRad-eu-pcsp.md), [Procedure: Radiotherapy](StructureDefinition-Procedure-radiotheraphy-eu-pcsp.md)...Show 3 more,[Procedure: Radiotherapy Boost](StructureDefinition-Procedure-radiotheraphyBoost-eu-pcsp.md),[Procedure: Radiotherapy Shielding](StructureDefinition-Procedure-radiotheraphyShield-eu-pcsp.md)and[Procedure: Surgery](StructureDefinition-Procedure-surgery-eu-pcsp.md)
* Examples for this Extension: [Bundle/54](Bundle-54.md), [Bundle/BundleHulafe](Bundle-BundleHulafe.md), [Condition/ConditionPrimCancerMainzZeisig](Condition-ConditionPrimCancerMainzZeisig.md) and [Condition/PrimaryCancerHulafe-1](Condition-PrimaryCancerHulafe-1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.pcsp|current/StructureDefinition/mcode-laterality-qualifier)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-mcode-laterality-qualifier.csv), [Excel](StructureDefinition-mcode-laterality-qualifier.xlsx), [Schematron](StructureDefinition-mcode-laterality-qualifier.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "mcode-laterality-qualifier",
  "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/mcode-laterality-qualifier",
  "version" : "1.0.0",
  "name" : "LateralityQualifier",
  "title" : "Laterality Qualifier",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "Qualifier to specify laterality.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Element"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Laterality Qualifier",
        "definition" : "Qualifier to specify laterality."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/mcode-laterality-qualifier"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      }
    ]
  }
}

```
