# Other info and relevant events - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Other info and relevant events**

## Logical Model: Other info and relevant events 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/StructureDefinition/OtherInfos | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:OtherInfos |

 
Other info and relevant events 

**Usages:**

* Use this Logical Model: [Treatment Summary](StructureDefinition-TreatmentSummary.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.pcsp|current/StructureDefinition/OtherInfos)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-OtherInfos.csv), [Excel](StructureDefinition-OtherInfos.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "OtherInfos",
  "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/OtherInfos",
  "version" : "1.0.0",
  "name" : "OtherInfos",
  "title" : "Other info and relevant events",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "Other info and relevant events",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "fhir",
      "uri" : "hl7.org/fhir/r4",
      "name" : "OtherInfos model to PCSP HL7 FHIR R4 Profiles"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/OtherInfos",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "OtherInfos",
        "path" : "OtherInfos",
        "short" : "Other info and relevant events",
        "definition" : "Other info and relevant events",
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Procedure"
          },
          {
            "identity" : "fhir",
            "map" : "Condition"
          }
        ]
      },
      {
        "id" : "OtherInfos.identifier",
        "path" : "OtherInfos.identifier",
        "short" : "Relevant event number",
        "definition" : "Progressive number of relevant event  (1=first; 2= second; 3 = third; ?).\nIn this field must be reported the ordinal number of relevant event to be described.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".identifier"
          }
        ]
      },
      {
        "id" : "OtherInfos.relatedDiagnosis",
        "path" : "OtherInfos.relatedDiagnosis",
        "short" : "Progressive number of diagnosis",
        "definition" : "Progressive number of diagnosis (1=first; 2= second; 3 = third; ?).  \nIn this field must be reported the ordinal number of the tumor diagnosis in which other info or relevant events occurred",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Procedure.reasonReference"
          }
        ]
      },
      {
        "id" : "OtherInfos.relatedRelapse",
        "path" : "OtherInfos.relatedRelapse",
        "short" : "Progressive number of relapse/progression (after FLT)",
        "definition" : "Progressive number of relevant event  (1=first; 2= second; 3 = third; ?).\nIn this field must be reported the ordinal number of relevant event to be described.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Procedure.reasonReference"
          },
          {
            "identity" : "fhir",
            "map" : "extension('http://hl7.org/fhir/StructureDefinition/condition-related').valueReference"
          }
        ]
      },
      {
        "id" : "OtherInfos.severeToxicity",
        "path" : "OtherInfos.severeToxicity",
        "short" : "Important toxicity during treatment",
        "definition" : "Important toxicity during treatment �",
        "min" : 0,
        "max" : "10",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Condition.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-toxicity-eu-pcsp')"
          }
        ]
      },
      {
        "id" : "OtherInfos.severeToxicity.flag",
        "path" : "OtherInfos.severeToxicity.flag",
        "short" : "Important toxicity during treatment",
        "definition" : "Answwer 'YES' OR 'NO' if non haematologic severe or life threatening (CTCAE grade 3 or 4) toxicity occurred during treatment.  Please note that febrile neutropenia events are not considered as 'severe' unless infection had severly affected important organs (e.g osteomyelitis, pneumonia) \n1 => Yes\n2 => No\n-9922 => NK ",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".exists()"
          },
          {
            "identity" : "fhir",
            "map" : ".verificationStatus"
          }
        ]
      },
      {
        "id" : "OtherInfos.severeToxicity.numberOfToxicity",
        "path" : "OtherInfos.severeToxicity.numberOfToxicity",
        "short" : "Number of toxicity",
        "definition" : "Number of toxicity",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "integer"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".identifier"
          }
        ]
      },
      {
        "id" : "OtherInfos.severeToxicity.date",
        "path" : "OtherInfos.severeToxicity.date",
        "short" : "Date of event",
        "definition" : "Date (dd/mm/yyyy) of the event. If the date is unkown or partially missed insert the year at the best of your knowledge.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".onsetDateTime"
          }
        ]
      },
      {
        "id" : "OtherInfos.severeToxicity.description",
        "path" : "OtherInfos.severeToxicity.description",
        "short" : "Description",
        "definition" : "Please describe any significant event (e.g. admission to the intensive care for a metabolic problem, seizures, severe toxic complication) occurring during therapy that might have fully recovered or be still remaining or with sequelae",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".text"
          },
          {
            "identity" : "fhir",
            "map" : ".note"
          }
        ]
      },
      {
        "id" : "OtherInfos.severeToxicity.isResolved",
        "path" : "OtherInfos.severeToxicity.isResolved",
        "short" : "Resolved ?",
        "definition" : "Please specify if the event is resolved or not",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".clinicalStatus"
          }
        ]
      },
      {
        "id" : "OtherInfos.hypogonadal",
        "path" : "OtherInfos.hypogonadal",
        "short" : "Hypogonadal ?",
        "definition" : "Please specify if hypogonadal occured during therapy",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Condition.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-otherinfos-eu-pcsp').where(code = http://snomed.info/sct#48130008 'Hypogonadism').exists()"
          }
        ]
      },
      {
        "id" : "OtherInfos.growthHormoneDeficiency",
        "path" : "OtherInfos.growthHormoneDeficiency",
        "short" : "Growth hormone deficiency ?",
        "definition" : "Please specify if growth hormon deficiency occured during therapy",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Condition.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-otherinfos-eu-pcsp').where(code = http://snomed.info/sct#397827003 'Growth hormone deficiency').exists()"
          }
        ]
      },
      {
        "id" : "OtherInfos.hydrocephalus",
        "path" : "OtherInfos.hydrocephalus",
        "short" : "Hydrocephalus ?",
        "definition" : "Please specify if hydrocephalus occured during therapy",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Condition.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-otherinfos-eu-pcsp').where(code = http://snomed.info/sct#230745008 'Hydrocephalus').exists()"
          }
        ]
      },
      {
        "id" : "OtherInfos.chronicViralHepatitis",
        "path" : "OtherInfos.chronicViralHepatitis",
        "short" : "Chronic viral hepatitis ?",
        "definition" : "Please specify if chronic viral hepatitis occured during therapy",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Condition.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-otherinfos-eu-pcsp').where(code = http://snomed.info/sct#10295004 'Chronic viral hepatitis').exists()"
          }
        ]
      },
      {
        "id" : "OtherInfos.sinusoidalObstructionSyndrome",
        "path" : "OtherInfos.sinusoidalObstructionSyndrome",
        "short" : "Sinusoidal obstruction syndrome ?",
        "definition" : "Please specify if sinusoidal obstruction syndrome occured during therapy",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Condition.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-otherinfos-eu-pcsp').where(code = http://snomed.info/sct#65617004 'Veno-occlusive disease of the liver').exists()"
          }
        ]
      },
      {
        "id" : "OtherInfos.catheter",
        "path" : "OtherInfos.catheter",
        "short" : "CVC positioning",
        "definition" : "Please report if at least one central venous line (catheter) was positioned",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Procedure.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-cvc-otherinfos-eu-pcsp')"
          }
        ]
      },
      {
        "id" : "OtherInfos.catheter.isInPlace",
        "path" : "OtherInfos.catheter.isInPlace",
        "short" : "If yes",
        "definition" : "Report if the CVC is still in place or was removed",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".focalDevice.action"
          }
        ]
      },
      {
        "id" : "OtherInfos.catheter.site",
        "path" : "OtherInfos.catheter.site",
        "short" : "Specify the site",
        "definition" : "Report where (in which vein) the CVC was positioned",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".bodySite"
          }
        ]
      },
      {
        "id" : "OtherInfos.catheter.relatedThrombosis",
        "path" : "OtherInfos.catheter.relatedThrombosis",
        "short" : "Catheter-related thrombosis",
        "definition" : "Catheter-related thrombosis",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Condition.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-otherinfos-eu-pcsp').where(code = http://snomed.info/sct#439127006 'Thrombosis')"
          }
        ]
      },
      {
        "id" : "OtherInfos.catheter.relatedThrombosis.occurred",
        "path" : "OtherInfos.catheter.relatedThrombosis.occurred",
        "short" : "Yes/No/UNK",
        "definition" : "Report if there was a catheter-related thrombosis due to a central venous catheter.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".exists()"
          }
        ]
      },
      {
        "id" : "OtherInfos.catheter.relatedThrombosis.specification",
        "path" : "OtherInfos.catheter.relatedThrombosis.specification",
        "short" : "Catheter-related thrombosis specification",
        "definition" : "Specify the details of the catheter-related thrombosis, including the location (vessel and laterality), treatment and status at the end of cancer treatment.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".text"
          }
        ]
      },
      {
        "id" : "OtherInfos.transfusion",
        "path" : "OtherInfos.transfusion",
        "short" : "Transfusion",
        "definition" : "Transfusion �",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Procedure.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-transfusion-otherinfos-eu-pcsp')"
          }
        ]
      },
      {
        "id" : "OtherInfos.transfusion.occured",
        "path" : "OtherInfos.transfusion.occured",
        "short" : "Yes/No/UNK",
        "definition" : "Please state if at least one blood (any component) transfusion was made",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".exists()"
          }
        ]
      },
      {
        "id" : "OtherInfos.transfusion.last",
        "path" : "OtherInfos.transfusion.last",
        "short" : "Last transfusion date",
        "definition" : "Please  report the date of the last transfusion given. If the date is unkown or partially missed insert the year at the best of your knowledge.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "extension('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/procedure-performedTiming').valueTiming.event.value.aggregate(iif($total.empty(), $this, iif($this > $total, $this, $total)))"
          },
          {
            "identity" : "fhir",
            "map" : "performedDateTime"
          }
        ]
      },
      {
        "id" : "OtherInfos.transfusion.moreThan10",
        "path" : "OtherInfos.transfusion.moreThan10",
        "short" : ">= 10 Transfusions ?",
        "definition" : "Please specify if patient recieved 10 or more than 10 trasfusions during therapy",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "iif(.extension(''http://hl7.eu/fhir/ig/pcsp/StructureDefinition/procedure-performedTiming').valueTiming.repeat.count > 9; true)"
          },
          {
            "identity" : "fhir",
            "map" : "iif(.extension(''http://hl7.eu/fhir/ig/pcsp/StructureDefinition/procedure-performedTiming').valueTiming.repeat..boundsRange.low > 9; true)"
          }
        ]
      },
      {
        "id" : "OtherInfos.fertilityPreservation",
        "path" : "OtherInfos.fertilityPreservation",
        "short" : "Fertility preservation",
        "definition" : "Please state if any procedure was performed for fertility preservation",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Procedure.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-cryopreservation-otherinfos-eu-pcsp')"
          }
        ]
      },
      {
        "id" : "OtherInfos.fertilityPreservation.description",
        "path" : "OtherInfos.fertilityPreservation.description",
        "short" : "Description",
        "definition" : "If fertility preservation was performed,please  describe it",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".text"
          }
        ]
      },
      {
        "id" : "OtherInfos.fertilityPreservation.storage",
        "path" : "OtherInfos.fertilityPreservation.storage",
        "short" : "Storage Institution",
        "definition" : "If fertility preservation was performed, describe with details of the institution where either sperm or ovarian tissue/oocytes have been stored",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "OtherInfos.otherTreatment",
        "path" : "OtherInfos.otherTreatment",
        "short" : "Other oncological treatments",
        "definition" : "Report here if any other treatment (not included in the chemotherapy, surgery or radiotherapy sections) was adminstered to the survivor",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "OtherInfos.dischargeLetter",
        "path" : "OtherInfos.dischargeLetter",
        "short" : "Discharge letter",
        "definition" : "Discharge letter",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Attachment"
          }
        ]
      }
    ]
  }
}

```
