# Location: PCSP - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Location: PCSP**

## Resource Profile: Location: PCSP 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Location-eu-pcsp | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:LocationPcsp |

 
This profile defines how to represent FHIR Location for the purpose of the PanCareSurPass project. 

**Usages:**

* Use this Profile: [Bundle: Survivor Passport](StructureDefinition-Bundle-eu-pcsp.md)
* Refer to this Profile: [MedicationAdministration: Chemotherapy](StructureDefinition-MedicationAdministration-eu-pcsp.md), [Procedure: Radiotherapy](StructureDefinition-Procedure-radiotheraphy-eu-pcsp.md) and [Procedure: Surgery](StructureDefinition-Procedure-surgery-eu-pcsp.md)
* Examples for this Profile: [Hospital la Fe](Location-ChemoHulafe-1-Location.md) and [Universitätsklinikum Schleswig-Holstein - Campus Lübeck](Location-Location-SCT1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.pcsp|current/StructureDefinition/Location-eu-pcsp)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Location-eu-pcsp.csv), [Excel](StructureDefinition-Location-eu-pcsp.xlsx), [Schematron](StructureDefinition-Location-eu-pcsp.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Location-eu-pcsp",
  "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Location-eu-pcsp",
  "version" : "1.0.0",
  "name" : "LocationPcsp",
  "title" : "Location: PCSP",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "This profile defines how to represent FHIR Location for the purpose of the PanCareSurPass project.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Location",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Location",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Location.name",
        "path" : "Location.name",
        "short" : "Name of the Institution",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Location.description",
        "path" : "Location.description",
        "short" : "Institution description"
      },
      {
        "id" : "Location.address.city",
        "path" : "Location.address.city",
        "short" : "Institution city"
      },
      {
        "id" : "Location.address.country",
        "path" : "Location.address.country",
        "short" : "Institution country"
      }
    ]
  }
}

```
