# Front Line Treatment - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Front Line Treatment**

## Logical Model: Front Line Treatment 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/StructureDefinition/FrontLineTreatment | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:FrontLineTreatment |

 
Front Line Treatment. The first treatment given for a disease. It is often part of a standard set of treatments, such as surgery followed by chemotherapy and radiation. When used by itself, first-line therapy is the one accepted as the best treatment. If it does not cure the disease or it causes severe side effects, other treatment may be added or used instead. Also called induction therapy, primary therapy, and primary treatment. 

**Usages:**

* Use this Logical Model: [Treatment Summary](StructureDefinition-TreatmentSummary.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.pcsp|current/StructureDefinition/FrontLineTreatment)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-FrontLineTreatment.csv), [Excel](StructureDefinition-FrontLineTreatment.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "FrontLineTreatment",
  "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/FrontLineTreatment",
  "version" : "1.0.0",
  "name" : "FrontLineTreatment",
  "title" : "Front Line Treatment",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "Front Line Treatment. The first treatment given for a disease. It is often part of a standard set of treatments, such as surgery followed by chemotherapy and radiation. When used by itself, first-line therapy is the one accepted as the best treatment. If it does not cure the disease or it causes severe side effects, other treatment may be added or used instead. Also called induction therapy, primary therapy, and primary treatment.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "fhir",
      "uri" : "hl7.org/fhir/r4",
      "name" : "FrontLineTreatment model to PCSP HL7 FHIR R4 Profiles"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/FrontLineTreatment",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "FrontLineTreatment",
        "path" : "FrontLineTreatment",
        "short" : "Front Line Treatment",
        "definition" : "Front Line Treatment. The first treatment given for a disease. It is often part of a standard set of treatments, such as surgery followed by chemotherapy and radiation. When used by itself, first-line therapy is the one accepted as the best treatment. If it does not cure the disease or it causes severe side effects, other treatment may be added or used instead. Also called induction therapy, primary therapy, and primary treatment.",
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Procedure.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-flt-eu-pcsp')"
          }
        ]
      },
      {
        "id" : "FrontLineTreatment.followedProtocol",
        "path" : "FrontLineTreatment.followedProtocol",
        "short" : "Followed Protocol",
        "definition" : "Followed Protocol",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".instantiatesCanonical"
          },
          {
            "identity" : "fhir",
            "map" : "PlanDefinition.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/PlanDefinition-flt-eu-pcsp')"
          }
        ]
      },
      {
        "id" : "FrontLineTreatment.followedProtocol.type",
        "path" : "FrontLineTreatment.followedProtocol.type",
        "short" : "Protocole type",
        "definition" : "2 => Trial/protocol\n2 => Personalized\n3 => Guidelines\n-9922 => NK",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".type"
          }
        ]
      },
      {
        "id" : "FrontLineTreatment.followedProtocol.name",
        "path" : "FrontLineTreatment.followedProtocol.name",
        "short" : "Protocole name",
        "definition" : "Protocole name",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".title"
          }
        ]
      },
      {
        "id" : "FrontLineTreatment.followedProtocol.description",
        "path" : "FrontLineTreatment.followedProtocol.description",
        "short" : "Protocol name or description",
        "definition" : "If a specific trial/protocol was used, please specify.  \nIn case of relapse/progression during front line treatment,please report both the name of the front line as well of the salvage treatment\nIf personalized, please specify.  ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".description"
          }
        ]
      },
      {
        "id" : "FrontLineTreatment.followedProtocol.arm",
        "path" : "FrontLineTreatment.followedProtocol.arm",
        "short" : "Group/Arm/Randomization",
        "definition" : "If the trial was randomized, please define randomization arm",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".extension('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/procedure-fltArm').valueString"
          }
        ]
      },
      {
        "id" : "FrontLineTreatment.dateEOT",
        "path" : "FrontLineTreatment.dateEOT",
        "short" : "Date of end of treatment",
        "definition" : "It might be the date of first elective end of treatment, or that of the second (or further) end of treatment after the first one. If the date is unkown or partially missed insert the year at the best of your knowledge.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Procedure.performedPeriod.end"
          }
        ]
      },
      {
        "id" : "FrontLineTreatment.isChemotherapy",
        "path" : "FrontLineTreatment.isChemotherapy",
        "short" : "Chemotherapy ?",
        "definition" : "Chemotherapy ?",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "MedicationAdministration.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/MedicationAdministration-eu-pcsp').exists()"
          }
        ]
      },
      {
        "id" : "FrontLineTreatment.isStemCellTransplantation",
        "path" : "FrontLineTreatment.isStemCellTransplantation",
        "short" : "Stem Cell transplantation ?",
        "definition" : "Stem Cell transplantation ?",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Procedure.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-sct-eu-pcsp').exists()"
          }
        ]
      },
      {
        "id" : "FrontLineTreatment.isRadiotherapy",
        "path" : "FrontLineTreatment.isRadiotherapy",
        "short" : "Radiotherapy ?",
        "definition" : "Radiotherapy ?",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Procedure.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-radiotheraphy-eu-pcsp').exists()"
          }
        ]
      },
      {
        "id" : "FrontLineTreatment.isMajorSurgery",
        "path" : "FrontLineTreatment.isMajorSurgery",
        "short" : "Major Surgery ?",
        "definition" : "Major Surgery ?",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Procedure.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-surgery-eu-pcsp').exists().not() [No Case, implicit]"
          },
          {
            "identity" : "fhir",
            "map" : "Procedure.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-surgery-eu-pcsp')..where(code = 'no-known-procedures').exists() [No Case, explicit]"
          },
          {
            "identity" : "fhir",
            "map" : "Procedure.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-surgery-eu-pcsp').where(code != 'no-known-procedures' or code != 'no-procedure-info').exists() [Yes Case]"
          },
          {
            "identity" : "fhir",
            "map" : "Procedure.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-surgery-eu-pcsp').where(code = 'no-procedure-info').exists() [Unk case]"
          }
        ]
      },
      {
        "id" : "FrontLineTreatment.notForRelapse",
        "path" : "FrontLineTreatment.notForRelapse",
        "short" : "Details not provided for relapses after EOT",
        "definition" : "Details not provided for relapses after EOT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "FrontLineTreatment.notForRelapse.completeRemission",
        "path" : "FrontLineTreatment.notForRelapse.completeRemission",
        "short" : "Complete remission",
        "definition" : "Complete remission",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "outcome"
          }
        ]
      },
      {
        "id" : "FrontLineTreatment.notForRelapse.completeRemission.status",
        "path" : "FrontLineTreatment.notForRelapse.completeRemission.status",
        "short" : "Complete remission (Yes/No)",
        "definition" : "Complete remission (Yes/No)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "outcome.coding"
          }
        ]
      },
      {
        "id" : "FrontLineTreatment.notForRelapse.completeRemission.description",
        "path" : "FrontLineTreatment.notForRelapse.completeRemission.description",
        "short" : "Textual description in case of no remission",
        "definition" : "Textual description in case of no remission",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "outcome.text"
          }
        ]
      },
      {
        "id" : "FrontLineTreatment.notForRelapse.isProgressionRelapseDuringFLT",
        "path" : "FrontLineTreatment.notForRelapse.isProgressionRelapseDuringFLT",
        "short" : "Progression/relapse during frontline treatment ?",
        "definition" : "Progression/relapse during frontline treatment ?",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Condition.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-primaryCancer-eu-pcsp').where( (extension('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/condition-previousStatus').valueCode = #replaspe or #recurrence) and  ( onsetDateTime < Procedure.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-flt-eu-pcsp').performedPeriod.end) ).exists()"
          }
        ]
      },
      {
        "id" : "FrontLineTreatment.notForRelapse.isProgressionRelapseAfterFLT",
        "path" : "FrontLineTreatment.notForRelapse.isProgressionRelapseAfterFLT",
        "short" : "Progression/relapse after first elective end of treatment ?",
        "definition" : "Progression/relapse after first elective end of treatment ?",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Condition.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-primaryCancer-eu-pcsp').where( (extension('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/condition-previousStatus').valueCode = #replaspe or #recurrence) and  ( onsetDateTime >= Procedure.conformsTo('http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Procedure-flt-eu-pcsp').performedPeriod.end) ).exists()"
          }
        ]
      }
    ]
  }
}

```
