# Condition: Primary Cancer - PanCareSurPass Project HL7 FHIR Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Condition: Primary Cancer**

## Resource Profile: Condition: Primary Cancer 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-primaryCancer-eu-pcsp | *Version*:1.0.0 |
| Active as of 2025-10-16 | *Computable Name*:ConditionPrimaryCancerPcsp |

 
This profile defines how to represent Primary Cancer Condition in HL7 FHIR for the purpose of the PanCareSurPass project. This profile is inspired from the[mCode IG](http://build.fhir.org/ig/HL7/fhir-mCODE-ig). A primary cancer condition, the original or first tumor in the body (Definition from:[NCI Dictionary of Cancer Terms](https://www.cancer.gov/publications/dictionaries/cancer-terms/def/primary-tumor)). Cancers that are not clearly secondary (i.e., of uncertain origin or behavior) should be documented as primary. This profile should be also used for documenting primary cancer relapses during or after FLT. 

**Usages:**

* Use this Profile: [Bundle: Survivor Passport](StructureDefinition-Bundle-eu-pcsp.md)
* Refer to this Profile: [CarePlan: PCSP-generated plan](StructureDefinition-CarePlan-eu-pcsp.md), [Composition: Survivor Passport](StructureDefinition-Composition-surpass-eu-pcsp.md), [Condition: GvHD](StructureDefinition-Condition-gvhd-eu-pcsp.md), [Condition: Others](StructureDefinition-Condition-otherinfos-eu-pcsp.md)...Show 21 more,[Condition: Primary Cancer](StructureDefinition-Condition-primaryCancer-eu-pcsp.md),[Condition: Metastatic Cancer](StructureDefinition-Condition-secondaryCancer-eu-pcsp.md),[Condition: Severe Toxicity](StructureDefinition-Condition-toxicity-eu-pcsp.md),[DocumentReference: PCSP](StructureDefinition-DocumentReference-eu-pcsp.md),[MedicationAdministration: Chemotherapy](StructureDefinition-MedicationAdministration-eu-pcsp.md),[MedicationStatement: Chemotherapy](StructureDefinition-MedicationStatement-eu-pcsp.md),[Procedure: Cryopreservation](StructureDefinition-Procedure-cryopreservation-otherinfos-eu-pcsp.md),[Procedure: Catheter](StructureDefinition-Procedure-cvc-otherinfos-eu-pcsp.md),[Procedure: Front Line Treatment](StructureDefinition-Procedure-flt-eu-pcsp.md),[Procedure: Radiotherapy](StructureDefinition-Procedure-radiotheraphy-eu-pcsp.md),[Procedure: Radiotherapy Boost](StructureDefinition-Procedure-radiotheraphyBoost-eu-pcsp.md),[Procedure: Radiotherapy Shielding](StructureDefinition-Procedure-radiotheraphyShield-eu-pcsp.md),[Procedure: Stem Cell Transplantation](StructureDefinition-Procedure-sct-eu-pcsp.md),[Procedure: SCT Prophylaxis](StructureDefinition-Procedure-sct-prophylaxis-eu-pcsp.md),[Procedure: Surgery](StructureDefinition-Procedure-surgery-eu-pcsp.md),[Procedure: Transfusion other infos](StructureDefinition-Procedure-transfusion-otherinfos-eu-pcsp.md),[Procedure: Other Treatments](StructureDefinition-Procedure-treatment-otherinfos-eu-pcsp.md),[Observation: Cancer Stage Group](StructureDefinition-mcode-cancer-stage-group.md),[Observation: TNM Distant Metastases Category](StructureDefinition-mcode-tnm-distant-metastases-category.md),[Observation: TNM Primary Tumor Category](StructureDefinition-mcode-tnm-primary-tumor-category.md)and[Observation: TNM Regional Nodes Category](StructureDefinition-mcode-tnm-regional-nodes-category.md)
* Examples for this Profile: [Condition/ConditionPrimCancerMainzFischer](Condition-ConditionPrimCancerMainzFischer.md), [Condition/ConditionPrimCancerMainzZeisig](Condition-ConditionPrimCancerMainzZeisig.md) and [Condition/PrimaryCancerHulafe-1](Condition-PrimaryCancerHulafe-1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.eu.fhir.pcsp|current/StructureDefinition/Condition-primaryCancer-eu-pcsp)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Condition-primaryCancer-eu-pcsp.csv), [Excel](StructureDefinition-Condition-primaryCancer-eu-pcsp.xlsx), [Schematron](StructureDefinition-Condition-primaryCancer-eu-pcsp.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Condition-primaryCancer-eu-pcsp",
  "url" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-primaryCancer-eu-pcsp",
  "version" : "1.0.0",
  "name" : "ConditionPrimaryCancerPcsp",
  "title" : "Condition: Primary Cancer",
  "status" : "active",
  "date" : "2025-10-16T12:02:24+00:00",
  "publisher" : "PanCareSurPass Project",
  "contact" : [
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    },
    {
      "name" : "PanCareSurPass Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.pancaresurpass.eu/"
        }
      ]
    }
  ],
  "description" : "This profile defines how to represent Primary Cancer Condition in HL7 FHIR for the purpose of the PanCareSurPass project. \r\nThis profile is inspired from the [mCode IG](http://build.fhir.org/ig/HL7/fhir-mCODE-ig). \r\nA primary cancer condition, the original or first tumor in the body (Definition from: [NCI Dictionary of Cancer Terms]( https://www.cancer.gov/publications/dictionaries/cancer-terms/def/primary-tumor)).  Cancers that are not clearly secondary (i.e., of uncertain origin or behavior) should be documented as primary.\r\nThis profile should be also used for documenting primary cancer relapses during or after FLT.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Condition",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Condition",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Condition",
        "path" : "Condition",
        "constraint" : [
          {
            "key" : "mutually-exclusive-predisposition",
            "severity" : "error",
            "human" : "Only one of Predisposition or Hereditary disease may be present",
            "expression" : "evidence.code.coding.where(system = 'http://snomed.info/sct' and code = '47708004').exists() implies evidence.code.coding.where(system = 'http://snomed.info/sct' and code = '32895009').empty()",
            "source" : "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-primaryCancer-eu-pcsp"
          }
        ]
      },
      {
        "id" : "Condition.extension",
        "path" : "Condition.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Condition.extension:condition-occurredFollowing",
        "path" : "Condition.extension",
        "sliceName" : "condition-occurredFollowing",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/condition-occurredFollowing|5.2.0"
            ]
          }
        ]
      },
      {
        "id" : "Condition.extension:condition-occurredFollowing.value[x]",
        "path" : "Condition.extension.value[x]",
        "short" : "For relapses, reference to the first occurance of this tumor.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Condition-primaryCancer-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Condition.extension:assertedDate",
        "path" : "Condition.extension",
        "sliceName" : "assertedDate",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/condition-assertedDate|5.2.0"
            ]
          }
        ]
      },
      {
        "id" : "Condition.extension:histologyMorphologyBehavior",
        "path" : "Condition.extension",
        "sliceName" : "histologyMorphologyBehavior",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/mcode/StructureDefinition/mcode-histology-morphology-behavior"
            ]
          }
        ]
      },
      {
        "id" : "Condition.extension:histologyMorphologyBehavior.value[x]",
        "path" : "Condition.extension.value[x]",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-icdo3-morphology-eu-pcsp"
        }
      },
      {
        "id" : "Condition.extension:previousStatus",
        "path" : "Condition.extension",
        "sliceName" : "previousStatus",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/condition-previousStatus"
            ]
          }
        ]
      },
      {
        "id" : "Condition.extension:relapseType",
        "path" : "Condition.extension",
        "sliceName" : "relapseType",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/condition-relapseType"
            ]
          }
        ]
      },
      {
        "id" : "Condition.extension:relapseType.value[x]",
        "path" : "Condition.extension.value[x]",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/relapse-type-vs"
        }
      },
      {
        "id" : "Condition.clinicalStatus",
        "path" : "Condition.clinicalStatus",
        "example" : [
          {
            "label" : "Relapse",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
                  "code" : "relapse"
                }
              ]
            }
          }
        ]
      },
      {
        "id" : "Condition.code",
        "path" : "Condition.code",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Condition.code.coding",
        "path" : "Condition.code.coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "$this"
            }
          ],
          "description" : "Slice based on the coding.code pattern",
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Condition.code.coding:iccc3-classification",
        "path" : "Condition.code.coding",
        "sliceName" : "iccc3-classification",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-iccc3-eu-pcsp"
        }
      },
      {
        "id" : "Condition.code.coding:exceptions",
        "path" : "Condition.code.coding",
        "sliceName" : "exceptions",
        "min" : 0,
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-ClassNullFlavor|3.0.0"
        }
      },
      {
        "id" : "Condition.bodySite",
        "path" : "Condition.bodySite",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/vs-icdo3-topography-eu-pcsp"
        }
      },
      {
        "id" : "Condition.bodySite.extension:locationQualifier",
        "path" : "Condition.bodySite.extension",
        "sliceName" : "locationQualifier",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/mcode-body-location-qualifier"
            ]
          }
        ]
      },
      {
        "id" : "Condition.bodySite.extension:lateralityQualifier",
        "path" : "Condition.bodySite.extension",
        "sliceName" : "lateralityQualifier",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/mcode-laterality-qualifier"
            ]
          }
        ]
      },
      {
        "id" : "Condition.bodySite.extension:lateralityQualifier.value[x]",
        "path" : "Condition.bodySite.extension.value[x]",
        "binding" : {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "purpose",
                  "valueCode" : "candidate"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://hl7.org/fhir/us/mcode/ValueSet/mcode-laterality-qualifier-vs"
                },
                {
                  "url" : "documentation",
                  "valueMarkdown" : "Qualifiers to specify laterality."
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            }
          ],
          "strength" : "preferred",
          "description" : "Qualifiers to specify laterality.",
          "valueSet" : "http://hl7.eu/fhir/ig/pcsp/ValueSet/laterality-qualifier-lrub-vs"
        }
      },
      {
        "id" : "Condition.subject",
        "path" : "Condition.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Patient-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Condition.encounter",
        "path" : "Condition.encounter",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Encounter",
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Encounter-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Condition.onset[x]",
        "path" : "Condition.onset[x]",
        "mustSupport" : true
      },
      {
        "id" : "Condition.stage",
        "path" : "Condition.stage",
        "mustSupport" : true
      },
      {
        "id" : "Condition.stage.summary",
        "path" : "Condition.stage.summary",
        "short" : "Most recent Stage Group",
        "definition" : "As for mCODE, in PCSP staging information MUST be captured in an Observation that conforms to the CancerStageGroup profile. For convenience, the stage group MAY appear in this element, copied from the CancerStageGroup, but Data Senders and Receivers MAY ignore it."
      },
      {
        "id" : "Condition.stage.assessment",
        "path" : "Condition.stage.assessment",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/mcode-cancer-stage-group"
            ]
          }
        ]
      },
      {
        "id" : "Condition.stage.type",
        "path" : "Condition.stage.type",
        "short" : "Staging system used.",
        "definition" : "As for mCODE, in PCSP staging information MUST be captured in an Observation that conforms to the CancerStageGroup profile. For convenience, the staging system MAY appear in this element, but Data Senders and Receivers MAY ignore it."
      },
      {
        "id" : "Condition.evidence",
        "path" : "Condition.evidence",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "code.coding"
            }
          ],
          "description" : "Slice based on the coding.code pattern",
          "rules" : "open"
        }
      },
      {
        "id" : "Condition.evidence:diagnosisDetails",
        "path" : "Condition.evidence",
        "sliceName" : "diagnosisDetails",
        "short" : "Diagnosis details",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Condition.evidence:diagnosisDetails.code.coding",
        "path" : "Condition.evidence.code.coding",
        "min" : 1,
        "patternCoding" : {
          "system" : "http://loinc.org",
          "code" : "29308-4",
          "display" : "Diagnosis"
        }
      },
      {
        "id" : "Condition.evidence:diagnosisDetails.detail",
        "path" : "Condition.evidence.detail",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-diagnosis-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Condition.evidence:geneticMarker",
        "path" : "Condition.evidence",
        "sliceName" : "geneticMarker",
        "short" : "Genetic Marker",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Condition.evidence:geneticMarker.code.coding",
        "path" : "Condition.evidence.code.coding",
        "min" : 1,
        "patternCoding" : {
          "system" : "http://snomed.info/sct",
          "code" : "106221001"
        }
      },
      {
        "id" : "Condition.evidence:geneticMarker.detail",
        "path" : "Condition.evidence.detail",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Observation",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference",
              "http://hl7.org/fhir/StructureDefinition/DiagnosticReport"
            ]
          }
        ]
      },
      {
        "id" : "Condition.evidence:geneticMarker.detail.display",
        "path" : "Condition.evidence.detail.display",
        "short" : "Text alternative for the resource (Genetic finding)"
      },
      {
        "id" : "Condition.evidence:immunology",
        "path" : "Condition.evidence",
        "sliceName" : "immunology",
        "short" : "Immunology",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Condition.evidence:immunology.code.coding",
        "path" : "Condition.evidence.code.coding",
        "min" : 1,
        "patternCoding" : {
          "system" : "http://snomed.info/sct",
          "code" : "365861007",
          "display" : "Finding of immune status"
        }
      },
      {
        "id" : "Condition.evidence:immunology.detail",
        "path" : "Condition.evidence.detail",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Observation",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference",
              "http://hl7.org/fhir/StructureDefinition/DiagnosticReport"
            ]
          }
        ]
      },
      {
        "id" : "Condition.evidence:predisposition",
        "path" : "Condition.evidence",
        "sliceName" : "predisposition",
        "short" : "Predisposition",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Condition.evidence:predisposition.code.coding",
        "path" : "Condition.evidence.code.coding",
        "min" : 1,
        "patternCoding" : {
          "system" : "http://snomed.info/sct",
          "code" : "47708004",
          "display" : "Genetic predisposition"
        }
      },
      {
        "id" : "Condition.evidence:predisposition.code.text",
        "path" : "Condition.evidence.code.text",
        "short" : "Text for predisposition"
      },
      {
        "id" : "Condition.evidence:predisposition.detail",
        "path" : "Condition.evidence.detail",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-predisposition-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Condition.evidence:hereditary",
        "path" : "Condition.evidence",
        "sliceName" : "hereditary",
        "short" : "Hereditary disease",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Condition.evidence:hereditary.code.coding",
        "path" : "Condition.evidence.code.coding",
        "min" : 1,
        "patternCoding" : {
          "system" : "http://snomed.info/sct",
          "code" : "32895009",
          "display" : "Hereditary disease"
        }
      },
      {
        "id" : "Condition.evidence:hereditary.code.text",
        "path" : "Condition.evidence.code.text",
        "short" : "Text for hereditary disease"
      },
      {
        "id" : "Condition.evidence:hereditary.detail",
        "path" : "Condition.evidence.detail",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/ig/pcsp/StructureDefinition/Observation-predisposition-eu-pcsp"
            ]
          }
        ]
      },
      {
        "id" : "Condition.note",
        "path" : "Condition.note",
        "short" : "Additional information about the Cancer Condition"
      }
    ]
  }
}

```
